/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.name.StandardClassIds;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;

public final class JavaToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE;
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final ClassId K_CLASS_CLASS_ID;
    private static final ClassId CLASS_CLASS_ID;
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    private static final HashMap<ClassId, ClassId> mutableToReadOnlyClassId;
    private static final HashMap<ClassId, ClassId> readOnlyToMutableClassId;
    private static final List<PlatformMutabilityMapping> mutabilityMappings;

    private JavaToKotlinClassMap() {
    }

    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    public final ClassId mapJavaToKotlin(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return javaToKotlin.get(fqName.toUnsafe());
    }

    public final ClassId mapKotlinToJava(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        if (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_FUNCTION_PREFIX)) {
            return FUNCTION_N_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_SUSPEND_FUNCTION_PREFIX)) {
            return FUNCTION_N_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_K_FUNCTION_PREFIX)) {
            return K_FUNCTION_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(fqNameUnsafe, NUMBERED_K_SUSPEND_FUNCTION_PREFIX)) {
            return K_FUNCTION_CLASS_ID;
        }
        return kotlinToJava.get(fqNameUnsafe);
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe object, String string) {
        if (!StringsKt.startsWith$default((String)(object = ((FqNameUnsafe)object).asString()), (String)string, (boolean)false, (int)2, null)) {
            return false;
        }
        String string2 = ((String)object).substring(string.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        object = string2;
        if (StringsKt.startsWith$default((CharSequence)string2, (char)'0', (boolean)false, (int)2, null)) {
            return false;
        }
        object = StringsKt.toIntOrNull((String)object);
        return object != null && (Integer)object >= 23;
    }

    private final void addMapping(PlatformMutabilityMapping object) {
        Object object2 = ((PlatformMutabilityMapping)object).component1();
        Object object3 = ((PlatformMutabilityMapping)object).component2();
        object = ((PlatformMutabilityMapping)object).component3();
        this.add((ClassId)object2, (ClassId)object3);
        this.addKotlinToJava(((ClassId)object).asSingleFqName(), (ClassId)object2);
        ((Map)mutableToReadOnlyClassId).put(object, object3);
        ((Map)readOnlyToMutableClassId).put(object3, object);
        object2 = ((ClassId)object3).asSingleFqName();
        object3 = ((ClassId)object).asSingleFqName();
        ((Map)mutableToReadOnly).put(((ClassId)object).asSingleFqName().toUnsafe(), object2);
        ((Map)readOnlyToMutable).put(((FqName)object2).toUnsafe(), object3);
    }

    private final void add(ClassId classId, ClassId classId2) {
        this.addJavaToKotlin(classId, classId2);
        this.addKotlinToJava(classId2.asSingleFqName(), classId);
    }

    private final void addTopLevel(Class<?> clazz, FqNameUnsafe fqNameUnsafe) {
        this.addTopLevel(clazz, fqNameUnsafe.toSafe());
    }

    private final void addTopLevel(Class<?> clazz, FqName fqName) {
        JavaToKotlinClassMap javaToKotlinClassMap = this;
        javaToKotlinClassMap.add(javaToKotlinClassMap.classId(clazz), ClassId.Companion.topLevel(fqName));
    }

    private final void addJavaToKotlin(ClassId classId, ClassId classId2) {
        ((Map)javaToKotlin).put(classId.asSingleFqName().toUnsafe(), classId2);
    }

    private final void addKotlinToJava(FqName fqName, ClassId classId) {
        ((Map)kotlinToJava).put(fqName.toUnsafe(), classId);
    }

    public final FqName mutableToReadOnly(FqNameUnsafe fqNameUnsafe) {
        return (FqName)((Map)mutableToReadOnly).get(fqNameUnsafe);
    }

    public final FqName readOnlyToMutable(FqNameUnsafe fqNameUnsafe) {
        return (FqName)((Map)readOnlyToMutable).get(fqNameUnsafe);
    }

    public final boolean isMutable(FqNameUnsafe fqNameUnsafe) {
        return ((Map)mutableToReadOnly).containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(FqNameUnsafe fqNameUnsafe) {
        return ((Map)readOnlyToMutable).containsKey(fqNameUnsafe);
    }

    private final ClassId classId(Class<?> object) {
        boolean bl;
        boolean bl2 = bl = !((Class)object).isPrimitive() && !((Class)object).isArray();
        if (_Assertions.ENABLED && !bl) {
            object = "Invalid class: " + object;
            throw new AssertionError(object);
        }
        Class<?> clazz = ((Class)object).getDeclaringClass();
        if (clazz == null) {
            String string = ((Class)object).getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return ClassId.Companion.topLevel(new FqName(string));
        }
        ClassId classId = this.classId(clazz);
        Name name = Name.identifier(((Class)object).getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        return classId.createNestedClassId(name);
    }

    /*
     * WARNING - void declaration
     */
    static {
        int n;
        void var1_13;
        INSTANCE = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionTypeKind.Function.INSTANCE.getPackageFqName() + '.' + FunctionTypeKind.Function.INSTANCE.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionTypeKind.KFunction.INSTANCE.getPackageFqName() + '.' + FunctionTypeKind.KFunction.INSTANCE.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionTypeKind.SuspendFunction.INSTANCE.getPackageFqName() + '.' + FunctionTypeKind.SuspendFunction.INSTANCE.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionTypeKind.KSuspendFunction.INSTANCE.getPackageFqName() + '.' + FunctionTypeKind.KSuspendFunction.INSTANCE.getClassNamePrefix();
        FUNCTION_N_CLASS_ID = ClassId.Companion.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        FUNCTION_N_FQ_NAME = FUNCTION_N_CLASS_ID.asSingleFqName();
        K_FUNCTION_CLASS_ID = StandardClassIds.INSTANCE.getKFunction();
        K_CLASS_CLASS_ID = StandardClassIds.INSTANCE.getKClass();
        CLASS_CLASS_ID = INSTANCE.classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        mutableToReadOnlyClassId = new HashMap();
        readOnlyToMutableClassId = new HashMap();
        Object[] objectArray = new PlatformMutabilityMapping[8];
        Object objectArray2 = objectArray;
        JavaToKotlinClassMap object3 = INSTANCE;
        ClassId classId = ClassId.Companion.topLevel(StandardNames.FqNames.iterable);
        FqName fqName = StandardNames.FqNames.mutableIterable;
        ClassId classId2 = new ClassId(classId.getPackageFqName(), FqNamesUtilKt.tail(fqName, classId.getPackageFqName()), false);
        objectArray[0] = new PlatformMutabilityMapping(object3.classId(Iterable.class), classId, classId2);
        JavaToKotlinClassMap javaToKotlinClassMap = INSTANCE;
        classId = ClassId.Companion.topLevel(StandardNames.FqNames.iterator);
        FqName fqName2 = StandardNames.FqNames.mutableIterator;
        ClassId classId3 = new ClassId(classId.getPackageFqName(), FqNamesUtilKt.tail(fqName2, classId.getPackageFqName()), false);
        objectArray2[1] = new PlatformMutabilityMapping(javaToKotlinClassMap.classId(Iterator.class), classId, classId3);
        JavaToKotlinClassMap classId32 = INSTANCE;
        classId = ClassId.Companion.topLevel(StandardNames.FqNames.collection);
        FqName fqName3 = StandardNames.FqNames.mutableCollection;
        ClassId classId4 = new ClassId(classId.getPackageFqName(), FqNamesUtilKt.tail(fqName3, classId.getPackageFqName()), false);
        objectArray2[2] = new PlatformMutabilityMapping(classId32.classId(Collection.class), classId, classId4);
        JavaToKotlinClassMap kSuspendFunction = INSTANCE;
        classId = ClassId.Companion.topLevel(StandardNames.FqNames.list);
        FqName fqName4 = StandardNames.FqNames.mutableList;
        ClassId classId5 = new ClassId(classId.getPackageFqName(), FqNamesUtilKt.tail(fqName4, classId.getPackageFqName()), false);
        objectArray2[3] = new PlatformMutabilityMapping(kSuspendFunction.classId(List.class), classId, classId5);
        JavaToKotlinClassMap javaToKotlinClassMap2 = INSTANCE;
        classId = ClassId.Companion.topLevel(StandardNames.FqNames.set);
        FqName fqName5 = StandardNames.FqNames.mutableSet;
        ClassId classId6 = new ClassId(classId.getPackageFqName(), FqNamesUtilKt.tail(fqName5, classId.getPackageFqName()), false);
        objectArray2[4] = new PlatformMutabilityMapping(javaToKotlinClassMap2.classId(Set.class), classId, classId6);
        JavaToKotlinClassMap javaToKotlinClassMap3 = INSTANCE;
        classId = ClassId.Companion.topLevel(StandardNames.FqNames.listIterator);
        FqName fqName6 = StandardNames.FqNames.mutableListIterator;
        ClassId classId7 = new ClassId(classId.getPackageFqName(), FqNamesUtilKt.tail(fqName6, classId.getPackageFqName()), false);
        objectArray2[5] = new PlatformMutabilityMapping(javaToKotlinClassMap3.classId(ListIterator.class), classId, classId7);
        JavaToKotlinClassMap javaToKotlinClassMap4 = INSTANCE;
        classId = ClassId.Companion.topLevel(StandardNames.FqNames.map);
        FqName fqName7 = StandardNames.FqNames.mutableMap;
        ClassId classId8 = new ClassId(classId.getPackageFqName(), FqNamesUtilKt.tail(fqName7, classId.getPackageFqName()), false);
        objectArray2[6] = new PlatformMutabilityMapping(javaToKotlinClassMap4.classId(Map.class), classId, classId8);
        JavaToKotlinClassMap javaToKotlinClassMap5 = INSTANCE;
        classId = ClassId.Companion.topLevel(StandardNames.FqNames.map).createNestedClassId(StandardNames.FqNames.mapEntry.shortName());
        FqName fqName8 = StandardNames.FqNames.mutableMapEntry;
        ClassId classId9 = new ClassId(classId.getPackageFqName(), FqNamesUtilKt.tail(fqName8, classId.getPackageFqName()), false);
        objectArray2[7] = new PlatformMutabilityMapping(javaToKotlinClassMap5.classId(Map.Entry.class), classId, classId9);
        mutabilityMappings = CollectionsKt.listOf((Object[])objectArray2);
        INSTANCE.addTopLevel(Object.class, StandardNames.FqNames.any);
        INSTANCE.addTopLevel(String.class, StandardNames.FqNames.string);
        INSTANCE.addTopLevel(CharSequence.class, StandardNames.FqNames.charSequence);
        INSTANCE.addTopLevel(Throwable.class, StandardNames.FqNames.throwable);
        INSTANCE.addTopLevel(Cloneable.class, StandardNames.FqNames.cloneable);
        INSTANCE.addTopLevel(Number.class, StandardNames.FqNames.number);
        INSTANCE.addTopLevel(Comparable.class, StandardNames.FqNames.comparable);
        INSTANCE.addTopLevel(Enum.class, StandardNames.FqNames._enum);
        INSTANCE.addTopLevel(Annotation.class, StandardNames.FqNames.annotation);
        for (PlatformMutabilityMapping platformMutabilityMapping : mutabilityMappings) {
            INSTANCE.addMapping(platformMutabilityMapping);
        }
        objectArray2 = JvmPrimitiveType.values();
        boolean bl = false;
        int n2 = ((Object)objectArray2).length;
        while (var1_13 < n2) {
            Object object = objectArray2[var1_13];
            FqName fqName9 = ((JvmPrimitiveType)((Object)object)).getWrapperFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName9, (String)"");
            ClassId classId10 = ClassId.Companion.topLevel(fqName9);
            PrimitiveType primitiveType = ((JvmPrimitiveType)((Object)object)).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"");
            INSTANCE.add(classId10, ClassId.Companion.topLevel(StandardNames.getPrimitiveFqName(primitiveType)));
            ++var1_13;
        }
        for (ClassId classId11 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            INSTANCE.add(ClassId.Companion.topLevel(new FqName("kotlin.jvm.internal." + classId11.getShortClassName().asString() + "CompanionObject")), classId11.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT));
        }
        for (n = 0; n < 23; ++n) {
            INSTANCE.add(ClassId.Companion.topLevel(new FqName("kotlin.jvm.functions.Function" + n)), StandardNames.getFunctionClassId(n));
            INSTANCE.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + n), K_FUNCTION_CLASS_ID);
        }
        for (n = 0; n < 22; ++n) {
            FunctionTypeKind.KSuspendFunction kSuspendFunction2 = FunctionTypeKind.KSuspendFunction.INSTANCE;
            String string = kSuspendFunction2.getPackageFqName() + '.' + kSuspendFunction2.getClassNamePrefix();
            INSTANCE.addKotlinToJava(new FqName(string + n), K_FUNCTION_CLASS_ID);
        }
        INSTANCE.addKotlinToJava(StandardNames.FqNames.nothing.toSafe(), INSTANCE.classId(Void.class));
    }

    public static final class PlatformMutabilityMapping {
        private final ClassId javaClass;
        private final ClassId kotlinReadOnly;
        private final ClassId kotlinMutable;

        public PlatformMutabilityMapping(ClassId classId, ClassId classId2, ClassId classId3) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
            Intrinsics.checkNotNullParameter((Object)classId2, (String)"");
            Intrinsics.checkNotNullParameter((Object)classId3, (String)"");
            this.javaClass = classId;
            this.kotlinReadOnly = classId2;
            this.kotlinMutable = classId3;
        }

        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        public final ClassId component1() {
            return this.javaClass;
        }

        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        public final ClassId component3() {
            return this.kotlinMutable;
        }

        public final String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ')';
        }

        public final int hashCode() {
            int n = this.javaClass.hashCode();
            n = n * 31 + this.kotlinReadOnly.hashCode();
            n = n * 31 + this.kotlinMutable.hashCode();
            return n;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PlatformMutabilityMapping)) {
                return false;
            }
            object = (PlatformMutabilityMapping)object;
            if (!Intrinsics.areEqual((Object)this.javaClass, (Object)((PlatformMutabilityMapping)object).javaClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kotlinReadOnly, (Object)((PlatformMutabilityMapping)object).kotlinReadOnly)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kotlinMutable, (Object)((PlatformMutabilityMapping)object).kotlinMutable);
        }
    }
}

