/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;

public final class IndexedParametersSubstitution
extends TypeSubstitution {
    private final TypeParameterDescriptor[] parameters;
    private final TypeProjection[] arguments;
    private final boolean approximateContravariantCapturedTypes;

    public IndexedParametersSubstitution(TypeParameterDescriptor[] typeParameterDescriptorArray, TypeProjection[] typeProjectionArray, boolean bl) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptorArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeProjectionArray, (String)"");
        this.parameters = typeParameterDescriptorArray;
        this.arguments = typeProjectionArray;
        this.approximateContravariantCapturedTypes = bl;
        boolean bl3 = bl2 = this.parameters.length <= this.arguments.length;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Number of arguments should not be less than number of parameters, but: parameters=" + this.parameters.length + ", args=" + this.arguments.length;
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ IndexedParametersSubstitution(TypeParameterDescriptor[] typeParameterDescriptorArray, TypeProjection[] typeProjectionArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(typeParameterDescriptorArray, typeProjectionArray, bl);
    }

    public final TypeParameterDescriptor[] getParameters() {
        return this.parameters;
    }

    public final TypeProjection[] getArguments() {
        return this.arguments;
    }

    public IndexedParametersSubstitution(List<? extends TypeParameterDescriptor> collection, List<? extends TypeProjection> list) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Collection collection2 = collection;
        collection = collection2;
        collection = collection2;
        Collection collection3 = list;
        collection = collection3;
        collection = collection3;
        this(collection2.toArray(new TypeParameterDescriptor[0]), collection3.toArray(new TypeProjection[0]), false, 4, null);
    }

    @Override
    public final boolean isEmpty() {
        return this.arguments.length == 0;
    }

    @Override
    public final boolean approximateContravariantCapturedTypes() {
        return this.approximateContravariantCapturedTypes;
    }

    @Override
    public final TypeProjection get(KotlinType annotated) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"");
        annotated = ((KotlinType)annotated).getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = annotated instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)annotated : null;
        if (typeParameterDescriptor == null) {
            return null;
        }
        annotated = typeParameterDescriptor;
        int n = typeParameterDescriptor.getIndex();
        if (n < this.parameters.length && Intrinsics.areEqual((Object)this.parameters[n].getTypeConstructor(), (Object)annotated.getTypeConstructor())) {
            return this.arguments[n];
        }
        return null;
    }
}

