/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public class ErrorScope
implements MemberScope {
    private final ErrorScopeKind kind;
    private final String debugMessage;

    public ErrorScope(ErrorScopeKind errorScopeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorScopeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.kind = errorScopeKind;
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length);
        String string = String.format(this.kind.getDebugMessage(), Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        this.debugMessage = string;
    }

    protected final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    public ClassifierDescriptor getContributedClassifier(Name name, LookupLocation object) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = name;
        String string = String.format((String)object, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        Name name2 = Name.special(string);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
        return new ErrorClassDescriptor(name2);
    }

    public Set<PropertyDescriptor> getContributedVariables(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        return ErrorUtils.INSTANCE.getErrorPropertyGroup();
    }

    public Set<SimpleFunctionDescriptor> getContributedFunctions(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        return SetsKt.setOf((Object)new ErrorFunctionDescriptor(ErrorUtils.INSTANCE.getErrorClass()));
    }

    @Override
    public Collection<DeclarationDescriptor> getContributedDescriptors(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return CollectionsKt.emptyList();
    }

    @Override
    public Set<Name> getFunctionNames() {
        return SetsKt.emptySet();
    }

    @Override
    public Set<Name> getVariableNames() {
        return SetsKt.emptySet();
    }

    @Override
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    @Override
    public void recordLookup(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
    }

    public String toString() {
        return "ErrorScope{" + this.debugMessage + '}';
    }
}

