/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.DefaultBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class ErrorTypeConstructor
implements TypeConstructor {
    private final ErrorTypeKind kind;
    private final String[] formatParams;
    private final String debugText;

    public ErrorTypeConstructor(ErrorTypeKind object, String ... objectArray) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        this.kind = object;
        this.formatParams = objectArray;
        object = ErrorEntity.ERROR_TYPE.getDebugText();
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        String string = this.kind.getDebugMessage();
        String[] stringArray = this.formatParams;
        stringArray = Arrays.copyOf(this.formatParams, stringArray.length);
        String string2 = String.format(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        objectArray2[0] = string2;
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        this.debugText = string3;
    }

    public final ErrorTypeKind getKind() {
        return this.kind;
    }

    public final String getParam(int n) {
        return this.formatParams[n];
    }

    @Override
    public final List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public final Collection<KotlinType> getSupertypes() {
        return CollectionsKt.emptyList();
    }

    @Override
    public final boolean isDenotable() {
        return false;
    }

    @Override
    public final ClassifierDescriptor getDeclarationDescriptor() {
        return ErrorUtils.INSTANCE.getErrorClass();
    }

    @Override
    public final KotlinBuiltIns getBuiltIns() {
        return DefaultBuiltIns.Companion.getInstance();
    }

    public final String toString() {
        return this.debugText;
    }

    @Override
    public final TypeConstructor refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        return this;
    }
}

