/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.ConnectionStateEvent;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.tcp.TcpHostEvent;
import org.jivesoftware.smack.tcp.XmppTcpTransportModule;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionException;

public final class ConnectionAttemptState {
    private final ModularXmppClientToServerConnectionInternal connectionInternal;
    private final XmppTcpTransportModule.XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredEndpoints;
    private final XmppTcpTransportModule.EstablishingTcpConnectionState establishingTcpConnectionState;
    final SocketChannel socketChannel;
    final List<RemoteConnectionException<?>> connectionExceptions;
    SmackException.EndpointConnectionException connectionException;
    boolean connected;
    long deadline;
    final Iterator<Rfc6120TcpRemoteConnectionEndpoint> connectionEndpointIterator;
    Rfc6120TcpRemoteConnectionEndpoint connectionEndpoint;
    Iterator<? extends InetAddress> inetAddressIterator;

    ConnectionAttemptState(ModularXmppClientToServerConnectionInternal object, XmppTcpTransportModule.XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredTcpEndpoints, XmppTcpTransportModule.EstablishingTcpConnectionState establishingTcpConnectionState) {
        this.connectionInternal = object;
        this.discoveredEndpoints = discoveredTcpEndpoints;
        this.establishingTcpConnectionState = establishingTcpConnectionState;
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        object = discoveredTcpEndpoints.result.discoveredRemoteConnectionEndpoints;
        this.connectionEndpointIterator = object.iterator();
        this.connectionExceptions = new ArrayList(object.size());
    }

    final StateTransitionResult.Failure establishTcpConnection() {
        Object object = this.nextAddress();
        this.establishTcpConnection((RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>)object);
        object = this;
        synchronized (object) {
            while (!this.connected && this.connectionException == null) {
                long l = System.currentTimeMillis();
                if (l >= this.deadline) {
                    return new StateTransitionResult.FailureCausedByTimeout("Timeout waiting to establish connection");
                }
                ConnectionAttemptState connectionAttemptState = this;
                connectionAttemptState.wait(connectionAttemptState.deadline - l);
            }
        }
        if (this.connected) {
            assert (this.connectionException == null);
            return null;
        }
        return new StateTransitionResult.FailureCausedByException((Exception)this.connectionException);
    }

    private void establishTcpConnection(RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> object) {
        Object object2 = new TcpHostEvent.ConnectingToHostEvent(this.establishingTcpConnectionState, (RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>)object);
        this.connectionInternal.invokeConnectionStateMachineListener((ConnectionStateEvent)object2);
        object2 = object.getInetSocketAddress();
        this.deadline = System.currentTimeMillis() + this.connectionInternal.connection.getReplyTimeout();
        try {
            this.connected = this.socketChannel.connect((SocketAddress)object2);
        }
        catch (IOException iOException) {
            this.onIOExceptionWhenEstablishingTcpConnection(iOException, (RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>)object);
            return;
        }
        if (this.connected) {
            object2 = new TcpHostEvent.ConnectedToHostEvent(this.establishingTcpConnectionState, (RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>)object, true);
            this.connectionInternal.invokeConnectionStateMachineListener((ConnectionStateEvent)object2);
            object = this;
            synchronized (object) {
                this.notifyAll();
                return;
            }
        }
        try {
            this.connectionInternal.registerWithSelector((SelectableChannel)this.socketChannel, 8, (selectableChannel, selectionKey) -> {
                boolean bl;
                selectableChannel = (SocketChannel)selectableChannel;
                try {
                    bl = ((SocketChannel)selectableChannel).finishConnect();
                }
                catch (IOException iOException) {
                    Async.go(() -> this.lambda$establishTcpConnection$0(iOException, (RemoteConnectionEndpoint.InetSocketAddressCoupling)object));
                    return;
                }
                if (!bl) {
                    Async.go(() -> this.lambda$establishTcpConnection$1((RemoteConnectionEndpoint.InetSocketAddressCoupling)object));
                    return;
                }
                TcpHostEvent.ConnectedToHostEvent connectedToHostEvent = new TcpHostEvent.ConnectedToHostEvent(this.establishingTcpConnectionState, (RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>)object, false);
                this.connectionInternal.invokeConnectionStateMachineListener((ConnectionStateEvent)connectedToHostEvent);
                this.connected = true;
                object = this;
                synchronized (object) {
                    this.notifyAll();
                    return;
                }
            });
            return;
        }
        catch (ClosedChannelException closedChannelException) {
            this.onIOExceptionWhenEstablishingTcpConnection(closedChannelException, (RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>)object);
            return;
        }
    }

    private void onIOExceptionWhenEstablishingTcpConnection(IOException object, RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> object2) {
        RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> inetSocketAddressCoupling = this.nextAddress();
        if (inetSocketAddressCoupling == null) {
            this.connectionException = SmackException.EndpointConnectionException.from(this.discoveredEndpoints.result.lookupFailures, this.connectionExceptions);
            object2 = this;
            synchronized (object2) {
                this.notifyAll();
                return;
            }
        }
        object2 = new RemoteConnectionException(object2, (Exception)object);
        this.connectionExceptions.add((RemoteConnectionException<?>)object2);
        object = new TcpHostEvent.ConnectionToHostFailedEvent(this.establishingTcpConnectionState, inetSocketAddressCoupling, (IOException)object);
        this.connectionInternal.invokeConnectionStateMachineListener((ConnectionStateEvent)object);
        this.establishTcpConnection(inetSocketAddressCoupling);
    }

    private RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint> nextAddress() {
        if (this.inetAddressIterator == null || !this.inetAddressIterator.hasNext()) {
            if (!this.connectionEndpointIterator.hasNext()) {
                return null;
            }
            this.connectionEndpoint = this.connectionEndpointIterator.next();
            this.inetAddressIterator = this.connectionEndpoint.getInetAddresses().iterator();
            assert (this.inetAddressIterator.hasNext());
        }
        InetAddress inetAddress = this.inetAddressIterator.next();
        return new RemoteConnectionEndpoint.InetSocketAddressCoupling((RemoteConnectionEndpoint)this.connectionEndpoint, inetAddress);
    }

    private /* synthetic */ void lambda$establishTcpConnection$1(RemoteConnectionEndpoint.InetSocketAddressCoupling inetSocketAddressCoupling) {
        this.onIOExceptionWhenEstablishingTcpConnection(new IOException("finishConnect() failed"), (RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>)inetSocketAddressCoupling);
    }

    private /* synthetic */ void lambda$establishTcpConnection$0(IOException iOException, RemoteConnectionEndpoint.InetSocketAddressCoupling inetSocketAddressCoupling) {
        this.onIOExceptionWhenEstablishingTcpConnection(iOException, (RemoteConnectionEndpoint.InetSocketAddressCoupling<Rfc6120TcpRemoteConnectionEndpoint>)inetSocketAddressCoupling);
    }
}

