/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import jogamp.common.util.Int32ArrayBitfield;
import jogamp.common.util.Int32Bitfield;
import jogamp.common.util.SyncedBitfield;

public interface Bitfield {
    public static final int UNSIGNED_INT_MAX_VALUE = -1;

    public int size();

    public void clearField(boolean var1);

    public int get32(int var1, int var2);

    public void put32(int var1, int var2, int var3);

    public int copy32(int var1, int var2, int var3);

    public boolean get(int var1);

    public boolean put(int var1, boolean var2);

    public void set(int var1);

    public void clear(int var1);

    public boolean copy(int var1, int var2);

    public int bitCount();

    public static class Factory {
        public static Bitfield create(int n) {
            if (32 >= n) {
                return new Int32Bitfield();
            }
            return new Int32ArrayBitfield(n);
        }

        public static Bitfield synchronize(Bitfield bitfield) {
            return new SyncedBitfield(bitfield);
        }
    }

    public static class Util {
        public static final int MAX_POWER_OF_2 = 0x40000000;

        public static int getBitMask(int n) {
            if (32 > n) {
                return (1 << n) - 1;
            }
            if (32 == n) {
                return -1;
            }
            throw new IndexOutOfBoundsException("n <= 32 expected, is " + n);
        }

        public static final int bitCount(int n) {
            int n2 = n;
            n = n2 - (n2 >>> 1 & 0x55555555);
            n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
            n = n + (n >>> 4) & 0xF0F0F0F;
            n += n >>> 8;
            n += n >>> 16;
            return n & 0x3F;
        }

        public static final boolean isPowerOf2(int n) {
            if (n > 0) {
                int n2 = n;
                if (0 == (n2 & n2 - 1)) {
                    return true;
                }
            }
            return false;
        }

        public static final int nextPowerOf2(int n) {
            int n2 = --n;
            n = n2 | n2 >>> 1;
            n |= n >>> 2;
            n |= n >>> 4;
            n |= n >>> 8;
            if ((n |= n >>> 16) < 0) {
                return 1;
            }
            return n + 1;
        }

        public static final int roundToPowerOf2(int n) {
            if (Util.isPowerOf2(n)) {
                return n;
            }
            return Util.nextPowerOf2(n);
        }
    }
}

