/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.net.AssetURLContext;
import com.jogamp.common.net.Uri;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.CustomCompress;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.SyncFailedException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import jogamp.common.Debug;
import jogamp.common.os.AndroidUtils;
import jogamp.common.os.PlatformPropsImpl;

public class IOUtil {
    public static final boolean DEBUG;
    private static final boolean DEBUG_EXE;
    private static final boolean DEBUG_EXE_NOSTREAM;
    private static final boolean DEBUG_EXE_EXISTING_FILE;
    private static final boolean testTempDirExec;
    private static final Method fileToPathGetter;
    private static final Method isExecutableQuery;
    private static final boolean useNativeExeFile;
    private static final String java_io_tmpdir_propkey = "java.io.tmpdir";
    private static final String user_home_propkey = "user.home";
    private static final String XDG_CACHE_HOME_envkey = "XDG_CACHE_HOME";
    public static final String tmpSubDir = "jogamp";
    private static final Pattern patternSingleBS;
    public static final Pattern patternSpaceEnc;
    private static final Object exeTestLock;
    private static WeakReference<byte[]> exeTestCodeRef;
    private static File tempRootExec;
    private static File tempRootNoexec;
    private static volatile boolean tempRootSet;

    private IOUtil() {
    }

    private static final Constructor<?> getFOSCtor() {
        Throwable throwable;
        Constructor<?> constructor;
        try {
            constructor = ReflectionUtil.getConstructor("java.io.FileOutputStream", new Class[]{File.class}, true, IOUtil.class.getClassLoader());
            throwable = null;
        }
        catch (Throwable throwable2) {
            constructor = null;
            throwable = throwable2;
        }
        if (DEBUG) {
            System.err.println("IOUtil: java.io.FileOutputStream available: " + (constructor != null));
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
        return constructor;
    }

    public static int copyURLConn2File(URLConnection uRLConnection, File file) {
        int n;
        uRLConnection.connect();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());){
            n = IOUtil.copyStream2File(bufferedInputStream, file);
        }
        return n;
    }

    public static int copyStream2File(InputStream inputStream, File object) {
        object = new BufferedOutputStream(new FileOutputStream((File)object));
        try {
            int n = IOUtil.copyStream2Stream(inputStream, (OutputStream)object);
            return n;
        }
        finally {
            ((OutputStream)object).close();
        }
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream) {
        return IOUtil.copyStream2Stream(Platform.getMachineDataInfo().pageSizeInBytes(), inputStream, outputStream);
    }

    public static int copyStream2Stream(int n, InputStream inputStream, OutputStream outputStream) {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public static StringBuilder appendCharStream(StringBuilder stringBuilder, Reader reader) {
        int n;
        char[] cArray = new char[1024];
        while (0 < (n = reader.read(cArray))) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n2 = 0;
        int n3 = inputStream.available();
        byte[] byArray = new byte[n3];
        do {
            if (n2 + n3 > byArray.length) {
                byte[] byArray2 = new byte[n2 + n3];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
            }
            if ((n = inputStream.read(byArray, n2, n3)) < 0) continue;
            n2 += n;
        } while ((n3 = inputStream.available()) > 0 && n >= 0);
        if (n2 != byArray.length) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, n2);
            byArray = byArray3;
        }
        return byArray;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) {
        return IOUtil.copyStream2ByteBuffer(inputStream, -1);
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream, int n) {
        int n2;
        int n3;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (n < (n3 = inputStream.available())) {
            n = n3;
        }
        MachineDataInfo machineDataInfo = Platform.getMachineDataInfo();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(n));
        byte[] byArray = new byte[machineDataInfo.pageSizeInBytes()];
        int n4 = Math.min(machineDataInfo.pageSizeInBytes(), n3);
        do {
            if (n3 > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(byteBuffer.position() + n3));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n2 = inputStream.read(byArray, 0, n4)) > 0) {
                byteBuffer.put(byArray, 0, n2);
            }
            n3 = inputStream.available();
            n4 = Math.min(machineDataInfo.pageSizeInBytes(), n3);
        } while (n2 > 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static ByteBuffer copyStreamChunk2ByteBuffer(InputStream inputStream, int n, int n2) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        MachineDataInfo machineDataInfo = Platform.getMachineDataInfo();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(n2));
        byte[] byArray = new byte[machineDataInfo.pageSizeInBytes()];
        int n3 = 1;
        while (n3 > 0 && n > 0) {
            n3 = Math.min(machineDataInfo.pageSizeInBytes(), n);
            n3 = inputStream.read(byArray, 0, n3);
            n -= n3;
        }
        while (n3 > 0 && n2 > 0) {
            n3 = Math.min(machineDataInfo.pageSizeInBytes(), n2);
            if ((n3 = inputStream.read(byArray, 0, n3)) > 0) {
                byteBuffer.put(byArray, 0, n3);
            }
            n2 -= n3;
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) {
        string = patternSingleBS.matcher(string).replaceAll("/");
        if (bl && !string.startsWith("/")) {
            string = "/" + string;
        }
        if (bl2 && !string.endsWith("/")) {
            string = string + "/";
        }
        return IOUtil.cleanPathString(string);
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static FileOutputStream getFileOutputStream(File file, boolean bl) {
        Constructor<?> constructor = IOUtil.getFOSCtor();
        if (constructor == null) {
            throw new IOException("Cannot open file (" + file + ") for writing, FileOutputStream feature not available.");
        }
        if (file.exists() && !bl) {
            throw new IOException("File already exists (" + file + ") and overwrite=false");
        }
        try {
            return (FileOutputStream)constructor.newInstance(file);
        }
        catch (Exception exception) {
            throw new IOException("error opening " + file + " for write. ", exception);
        }
    }

    public static String getClassFileName(String string) {
        return string.replace('.', '/') + ".class";
    }

    public static URL getClassURL(String string, ClassLoader object) {
        if ((object = ((ClassLoader)object).getResource(IOUtil.getClassFileName(string))) == null) {
            throw new IOException("Cannot not find: " + string);
        }
        return object;
    }

    public static String getBasename(String string) {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader, Class<?> clazz) {
        if (string == null) {
            return null;
        }
        URLConnection uRLConnection = null;
        if (clazz != null) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                string2 = string2.substring(0, n + 1);
                uRLConnection = IOUtil.getResource(string2 + string, classLoader);
                if (DEBUG) {
                    System.err.println("IOUtil: found <" + string + "> within class package <" + string2 + "> of given class <" + clazz.getName() + ">: " + (uRLConnection != null));
                }
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context, skip rel. lookup");
        }
        if (uRLConnection == null) {
            uRLConnection = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> by classloader: " + (uRLConnection != null));
            }
        }
        return uRLConnection;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader) {
        if (string == null) {
            return null;
        }
        if (DEBUG) {
            System.err.println("IOUtil: locating <" + string + ">, has cl: " + (classLoader != null));
        }
        if (string.startsWith("asset:")) {
            try {
                return AssetURLContext.createURL(string, classLoader).openConnection();
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    ExceptionUtils.dumpThrowable("IOUtil", iOException);
                }
                return null;
            }
        }
        try {
            return AssetURLContext.resolve(string, classLoader);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                ExceptionUtils.dumpThrowable("IOUtil", iOException);
            }
            return null;
        }
    }

    public static String getRelativeOf(File file, String string) {
        if (string == null) {
            return null;
        }
        if (file != null) {
            file = new File(file, string);
            return IOUtil.slashify(file.getPath(), false, false);
        }
        return null;
    }

    public static String getParentOf(String string) {
        int n = string != null ? string.length() : 0;
        if (n == 0) {
            throw new IllegalArgumentException("path is empty <" + string + ">");
        }
        int n2 = string.lastIndexOf("/");
        if (n2 < 0) {
            throw new URISyntaxException(string, "path contains no '/': <" + string + ">");
        }
        if (n2 == 0) {
            throw new URISyntaxException(string, "path has no parents: <" + string + ">");
        }
        if (n2 < n - 1) {
            return string.substring(0, n2 + 1);
        }
        n = string.lastIndexOf("!") + 1;
        int n3 = string.lastIndexOf("/", n2 - 1);
        if (n3 >= n) {
            return string.substring(0, n3 + 1);
        }
        String string2 = string.substring(n, n2);
        if (string2.equals("..")) {
            throw new URISyntaxException(string, "parent is unresolved: <" + string + ">");
        }
        return string.substring(0, n);
    }

    public static String cleanPathString(String string) {
        int n = string.length() - 1;
        while (n > 0 && (n = string.lastIndexOf("./", n)) >= 0) {
            if (n > 0 && string.charAt(n - 1) == '.') {
                n -= 2;
                continue;
            }
            string = string.substring(0, n) + string.substring(n + 2);
            --n;
        }
        block1: while (true) {
            n = 0;
            while ((n = string.indexOf("../", n)) >= 0) {
                if (n == 0) {
                    n += 3;
                    continue;
                }
                string = IOUtil.getParentOf(string.substring(0, n)) + string.substring(n + 3);
                continue block1;
            }
            break;
        }
        return string;
    }

    public static String getUriFilePathOrASCII(Uri uri) {
        if (uri.isFileScheme()) {
            return uri.toFile().getPath();
        }
        return uri.toASCIIString().get();
    }

    public static URLConnection openURL(URL uRL) {
        return IOUtil.openURL(uRL, ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URLConnection openURL(URL uRL, String string) {
        if (uRL != null) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                if (!DEBUG) return uRLConnection;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - true");
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (!DEBUG) return null;
                ExceptionUtils.dumpThrowable("IOUtil: urlExists(" + uRL + ") [" + string + "] - false -", iOException);
                return null;
            }
        } else {
            if (!DEBUG) return null;
            System.err.println("IOUtil: no url - urlExists(null) [" + string + "]");
        }
        return null;
    }

    private static String getExeTestFileSuffix() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                if (useNativeExeFile && Platform.CPUFamily.X86 == PlatformPropsImpl.CPU_ARCH.family) {
                    return ".exe";
                }
                return ".bat";
            }
        }
        return ".sh";
    }

    private static String getExeTestShellCode() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return "echo off" + PlatformPropsImpl.NEWLINE;
            }
        }
        return "#!/bin/true" + PlatformPropsImpl.NEWLINE;
    }

    private static String[] getExeTestCommandArgs(String string) {
        switch (PlatformPropsImpl.OS_TYPE) {
            // Empty switch
        }
        return new String[]{string};
    }

    private static final byte[] readCode(String object) {
        byte[] byArray;
        object = IOUtil.getResource((String)object, IOUtil.class.getClassLoader(), IOUtil.class);
        object = ((URLConnection)object).getInputStream();
        try {
            byArray = CustomCompress.inflateFromStream((InputStream)object);
        }
        finally {
            ((InputStream)object).close();
        }
        return byArray;
    }

    private static void fillExeTestFile(File file) {
        block17: {
            Object object;
            Object object2;
            block19: {
                if (!useNativeExeFile || Platform.OSType.WINDOWS != PlatformPropsImpl.OS_TYPE || Platform.CPUFamily.X86 != PlatformPropsImpl.CPU_ARCH.family) break block17;
                object2 = exeTestLock;
                synchronized (object2) {
                    block18: {
                        if (exeTestCodeRef == null) break block18;
                        byte[] byArray = (byte[])exeTestCodeRef.get();
                        object = byArray;
                        if (null != byArray) break block19;
                    }
                    object = Platform.CPUType.X86_64 == PlatformPropsImpl.CPU_ARCH ? "bin/exe-windows-x86_64.defl" : "bin/exe-windows-i386.defl";
                    object = IOUtil.readCode((String)object);
                    exeTestCodeRef = new WeakReference<Object>(object);
                }
            }
            object2 = new FileOutputStream(file);
            try {
                ((FileOutputStream)object2).write((byte[])object, 0, ((Object)object).length);
                try {
                    ((FileOutputStream)object2).getFD().sync();
                }
                catch (SyncFailedException syncFailedException) {
                    ExceptionUtils.dumpThrowable("", syncFailedException);
                }
            }
            finally {
                ((FileOutputStream)object2).close();
            }
        }
        String string = IOUtil.getExeTestShellCode();
        if (IOUtil.isStringSet(string)) {
            try (FileWriter fileWriter = new FileWriter(file);){
                fileWriter.write(string);
                try {
                    fileWriter.flush();
                }
                catch (IOException iOException) {
                    ExceptionUtils.dumpThrowable("", iOException);
                }
                return;
            }
        }
    }

    private static boolean getOSHasNoexecFS() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case OPENKODE: {
                return false;
            }
        }
        return true;
    }

    private static boolean getOSHasFreeDesktopXDG() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: 
            case ANDROID: 
            case MACOS: 
            case IOS: {
                return false;
            }
        }
        return true;
    }

    public static boolean testFile(File file, boolean bl, boolean bl2) {
        if (!file.exists()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: does not exist");
            }
            return false;
        }
        if (bl && !file.isDirectory()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not a directory");
            }
            return false;
        }
        if (bl2 && !file.canWrite()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not writable");
            }
            return false;
        }
        return true;
    }

    private static final Boolean isNioExecutableFile(File file) {
        if (fileToPathGetter != null && isExecutableQuery != null) {
            try {
                return (Boolean)isExecutableQuery.invoke(null, fileToPathGetter.invoke((Object)file, new Object[0]));
            }
            catch (Throwable throwable) {
                throw new JogampRuntimeException("error invoking Files.isExecutable(file.toPath())", throwable);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean testDirExec(File var0) {
        v0 = var1_2 = IOUtil.DEBUG_EXE != false || IOUtil.DEBUG != false;
        if (!IOUtil.testTempDirExec) {
            if (IOUtil.DEBUG) {
                System.err.println("IOUtil.testDirExec: <" + var0.getAbsolutePath() + ">: Disabled TestTempDirExec");
            }
            return false;
        }
        if (!IOUtil.testFile(var0, true, true)) {
            if (var1_2) {
                System.err.println("IOUtil.testDirExec: <" + var0.getAbsolutePath() + ">: Not writeable dir");
            }
            return false;
        }
        if (!IOUtil.getOSHasNoexecFS()) {
            if (var1_2) {
                System.err.println("IOUtil.testDirExec: <" + var0.getAbsolutePath() + ">: Always executable");
            }
            return true;
        }
        var2_3 = var1_2 != false ? System.currentTimeMillis() : 0L;
        try {
            v1 = var6_4 = IOUtil.DEBUG_EXE_EXISTING_FILE != false ? new File(var0, "jogamp_exe_tst" + IOUtil.getExeTestFileSuffix()) : null;
            if (var6_4 != null && var6_4.exists()) {
                var4_8 = var6_4;
                var5_9 = true;
            } else {
                var4_8 = File.createTempFile("jogamp_exe_tst", IOUtil.getExeTestFileSuffix(), var0);
                var5_9 = false;
                IOUtil.fillExeTestFile(var4_8);
            }
        }
        catch (SecurityException v2) {
            var6_5 = v2;
            throw v2;
        }
        catch (IOException var6_6) {
            if (var1_2) {
                var6_6.printStackTrace();
            }
            return false;
        }
        var6_7 = var1_2 != false ? System.currentTimeMillis() : 0L;
        var10_10 = -1;
        var11_11 = -1;
        var12_12 = null;
        if (var5_9 || var4_8.setExecutable(true, true)) {
            var8_13 = var1_2 != false ? System.currentTimeMillis() : 0L;
            var12_12 = IOUtil.isNioExecutableFile(var4_8);
            if (var12_12 != null) {
                v3 = var10_10 = var12_12 != false ? 0 : -1;
            }
            if (var12_12 == null || var10_10 >= 0) {
                var13_14 = null;
                try {
                    var13_14 = Runtime.getRuntime().exec(IOUtil.getExeTestCommandArgs(var4_8.getCanonicalPath()), null, null);
                    if (IOUtil.DEBUG_EXE && !IOUtil.DEBUG_EXE_NOSTREAM) {
                        new StreamMonitor(new InputStream[]{var13_14.getInputStream(), var13_14.getErrorStream()}, System.err, "Exe-Tst: ");
                    }
                    var13_14.waitFor();
                    var11_11 = var13_14.exitValue();
                    if (var11_11 == 0) {
                        ++var10_10;
                    }
                    var10_10 = -2;
                }
                catch (SecurityException v4) {
                    var14_17 = v4;
                    throw v4;
                }
                catch (Throwable var14_18) {
                    var8_13 = var1_2 != false ? System.currentTimeMillis() : 0L;
                    var10_10 = -3;
                    if (!var1_2) ** GOTO lbl75
                    System.err.println("IOUtil.testDirExec: <" + var4_8.getAbsolutePath() + ">: Caught " + var14_18.getClass().getSimpleName() + ": " + var14_18.getMessage());
                    var14_18.printStackTrace();
                }
                finally {
                    if (var13_14 != null) {
                        try {
                            var13_14.destroy();
                        }
                        catch (Throwable var14_19) {
                            ExceptionUtils.dumpThrowable("", var14_19);
                        }
                    }
                }
            }
        } else {
            var8_13 = var1_2 != false ? System.currentTimeMillis() : 0L;
        }
lbl75:
        // 6 sources

        v5 = var13_15 = var10_10 >= 0;
        if (!IOUtil.DEBUG_EXE && !var5_9) {
            var4_8.delete();
        }
        if (var1_2) {
            var14_21 = System.currentTimeMillis();
            System.err.println("IOUtil.testDirExec(): test-exe <" + var4_8.getAbsolutePath() + ">, existingFile " + var5_9 + ", isNioExec " + var12_12 + ", returned " + var11_11);
            System.err.println("IOUtil.testDirExec(): abs-path <" + var0.getAbsolutePath() + ">: res " + var10_10 + " -> " + var13_15);
            System.err.println("IOUtil.testDirExec(): total " + (var14_21 - var2_3) + "ms, create " + (var6_7 - var2_3) + "ms, fill " + (var8_13 - var6_7) + "ms, execute " + (var14_21 - var8_13) + "ms");
        }
        return var13_15;
    }

    private static File testDirImpl(File file, boolean bl, boolean bl2, String string) {
        File file2;
        if (bl && !file.exists()) {
            file.mkdirs();
        }
        if (bl2) {
            file2 = IOUtil.testDirExec(file) ? file : null;
        } else {
            File file3 = file2 = IOUtil.testFile(file, true, true) ? file : null;
        }
        if (DEBUG) {
            System.err.println("IOUtil.testDirImpl(" + string + "): <" + file.getAbsolutePath() + ">, create " + bl + ", exec " + bl2 + ": " + (file2 != null));
        }
        return file2;
    }

    public static File testDir(File file, boolean bl, boolean bl2) {
        return IOUtil.testDirImpl(file, bl, bl2, "testDir");
    }

    private static boolean isStringSet(String string) {
        return string != null && 0 < string.length();
    }

    private static File getSubTempDir(File file, String string, boolean bl, String string2) {
        Object object = null;
        if (null != IOUtil.testDirImpl(file, true, bl, string2)) {
            for (int i = 0; object == null && i <= 9999; ++i) {
                object = String.format(null, "_%04d", i);
                object = IOUtil.testDirImpl(new File(file, string + (String)object), true, bl, string2);
            }
        }
        return object;
    }

    private static File getFile(String string) {
        if (IOUtil.isStringSet(string)) {
            return new File(string);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File getTempDir(boolean bl) {
        Object object;
        Object object2;
        if (!tempRootSet) {
            object2 = IOUtil.class;
            // MONITORENTER : com.jogamp.common.util.IOUtil.class
            if (!tempRootSet) {
                Object object3;
                Object object4;
                Object object5;
                tempRootSet = true;
                object = AndroidUtils.getTempRoot();
                if (object != null) {
                    tempRootExec = tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "Android.ctxTemp");
                    // MONITOREXIT : object2
                    return tempRootNoexec;
                }
                object = IOUtil.getFile(PropertyAccess.getProperty(java_io_tmpdir_propkey, false));
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX1 <" + object + ">, used " + (object != null));
                }
                if (!IOUtil.isStringSet((String)(object5 = System.getenv("TMPDIR")))) {
                    object5 = System.getenv("TEMP");
                }
                Object object6 = (object4 = IOUtil.getFile((String)object5)) != null && !((File)object4).equals(object) ? object4 : null;
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX3 <" + object4 + ">, used " + (object6 != null));
                }
                object5 = IOUtil.getFile(PropertyAccess.getProperty(user_home_propkey, false));
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX4 <" + object5 + ">, used " + (object5 != null));
                }
                if (IOUtil.getOSHasFreeDesktopXDG()) {
                    object4 = System.getenv(XDG_CACHE_HOME_envkey);
                    if (!IOUtil.isStringSet((String)object4) && object5 != null) {
                        object4 = ((File)object5).getAbsolutePath() + File.separator + ".cache";
                    }
                } else {
                    object4 = null;
                }
                object4 = (object3 = IOUtil.getFile((String)object4)) != null && !((File)object3).equals(object) ? object3 : null;
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX2 <" + object3 + ">, used " + (object4 != null));
                }
                if (tempRootExec == null && object != null) {
                    tempRootExec = Platform.OSType.MACOS == PlatformPropsImpl.OS_TYPE || Platform.OSType.IOS == PlatformPropsImpl.OS_TYPE ? IOUtil.getSubTempDir((File)object, tmpSubDir, false, "tempX1") : IOUtil.getSubTempDir((File)object, tmpSubDir, true, "tempX1");
                }
                if (tempRootExec == null && object4 != null) {
                    tempRootExec = IOUtil.getSubTempDir((File)object4, tmpSubDir, true, "tempX2");
                }
                if (tempRootExec == null && object6 != null) {
                    tempRootExec = IOUtil.getSubTempDir((File)object6, tmpSubDir, true, "tempX3");
                }
                if (tempRootExec == null && object5 != null) {
                    tempRootExec = IOUtil.getSubTempDir((File)object5, ".jogamp", true, "tempX4");
                }
                if (tempRootExec != null) {
                    tempRootNoexec = tempRootExec;
                } else {
                    if (tempRootNoexec == null && object != null) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "temp01");
                    }
                    if (tempRootNoexec == null && object4 != null) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object4, tmpSubDir, false, "temp02");
                    }
                    if (tempRootNoexec == null && object6 != null) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object6, tmpSubDir, false, "temp03");
                    }
                    if (tempRootNoexec == null && object5 != null) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object5, ".jogamp", false, "temp04");
                    }
                }
                if (DEBUG) {
                    object4 = tempRootExec != null ? tempRootExec.getAbsolutePath() : null;
                    object3 = tempRootNoexec != null ? tempRootNoexec.getAbsolutePath() : null;
                    System.err.println("IOUtil.getTempRoot(): temp dirs: exec: " + (String)object4 + ", noexec: " + (String)object3);
                }
            }
            // MONITOREXIT : object2
        }
        Object object7 = object2 = bl ? tempRootExec : tempRootNoexec;
        if (object2 != null) {
            object = new FilePermission(((File)object2).getAbsolutePath(), "read,write,delete");
            SecurityUtil.checkPermission((Permission)object);
            return object2;
        }
        object = bl ? "executable " : "";
        throw new IOException("Could not determine a temporary " + (String)object + "directory");
    }

    public static File createTempFile(String string, String string2, boolean bl) {
        return File.createTempFile(string, string2, IOUtil.getTempDir(bl));
    }

    public static void close(Closeable closeable, boolean bl) {
        block4: {
            if (closeable != null) {
                try {
                    closeable.close();
                    return;
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw new RuntimeException(iOException);
                    }
                    if (!DEBUG) break block4;
                    System.err.println("Caught Exception: ");
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static IOException close(Closeable closeable, IOException[] iOExceptionArray, PrintStream printStream) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            if (null == iOExceptionArray[0]) {
                iOExceptionArray[0] = iOException;
            }
            if (printStream != null) {
                printStream.println("Caught " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                iOException.printStackTrace(printStream);
            }
            return iOException;
        }
        return null;
    }

    public static ArrayList<String> filesOf(List<String> list, List<Pattern> list2, List<Pattern> list3) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size() << 5);
        list = new ArrayList<String>(list);
        while (((ArrayList)list).size() > 0) {
            File file;
            int n;
            String string = (String)((ArrayList)list).remove(0);
            if (list2 != null && list2.size() > 0) {
                boolean bl = false;
                for (n = 0; !bl && n < list2.size(); ++n) {
                    bl = list2.get(n).matcher(string).matches();
                    if (!DEBUG || !bl) continue;
                    System.err.println("IOUtil.filesOf(): excluding <" + string + "> (exclude[" + n + "]: " + list2.get(n) + ")");
                }
                if (bl) continue;
            }
            if (!(file = new File(string)).exists()) {
                if (!DEBUG) continue;
                System.err.println("IOUtil.filesOf(): not existing: " + file);
                continue;
            }
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                if (stringArray == null) {
                    if (!DEBUG) continue;
                    System.err.println("IOUtil.filesOf(): null list of directory: " + file);
                    continue;
                }
                if (0 == stringArray.length) {
                    if (!DEBUG) continue;
                    System.err.println("IOUtil.filesOf(): empty list of directory: " + file);
                    continue;
                }
                int n2 = 0;
                string = string.endsWith("/") ? string : string + "/";
                for (int i = 0; i < stringArray.length; ++i) {
                    ((ArrayList)list).add(n2++, string + stringArray[i]);
                }
                continue;
            }
            if (list3 != null && list3.size() > 0) {
                n = 0;
                for (int i = 0; n == 0 && i < list3.size(); ++i) {
                    n = list3.get(i).matcher(string).matches() ? 1 : 0;
                    if (!DEBUG || n == 0) continue;
                    System.err.println("IOUtil.filesOf(): including <" + string + "> (including[" + i + "]: " + list3.get(i) + ")");
                }
                if (n == 0) continue;
                arrayList.add(string);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    static {
        final boolean[] blArray = new boolean[]{false, false, false, false, false, false};
        Method[] methodArray = SecurityUtil.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                Method[] methodArray;
                block2: {
                    methodArray = new Method[]{null, null};
                    try {
                        blArray[0] = Debug.debug("IOUtil");
                        blArray[1] = PropertyAccess.isPropertyDefined("jogamp.debug.IOUtil.Exe", true);
                        blArray[2] = PropertyAccess.isPropertyDefined("jogamp.debug.IOUtil.Exe.NoStream", true);
                        blArray[3] = false;
                        blArray[4] = PropertyAccess.getBooleanProperty("jogamp.gluegen.TestTempDirExec", true, true);
                        blArray[5] = PropertyAccess.getBooleanProperty("jogamp.gluegen.UseNativeExeFile", true, false);
                        methodArray[0] = File.class.getDeclaredMethod("toPath", new Class[0]);
                        methodArray[0].setAccessible(true);
                        Class<?> clazz = ReflectionUtil.getClass("java.nio.file.Path", false, IOUtil.class.getClassLoader());
                        Class<?> clazz2 = ReflectionUtil.getClass("java.nio.file.Files", false, IOUtil.class.getClassLoader());
                        methodArray[1] = clazz2.getDeclaredMethod("isExecutable", clazz);
                        methodArray[1].setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        if (!blArray[0]) break block2;
                        ExceptionUtils.dumpThrowable("ioutil-init", throwable);
                    }
                }
                return methodArray;
            }
        });
        DEBUG = blArray[0];
        DEBUG_EXE = blArray[1];
        DEBUG_EXE_NOSTREAM = blArray[2];
        DEBUG_EXE_EXISTING_FILE = blArray[3];
        testTempDirExec = blArray[4];
        useNativeExeFile = blArray[5];
        fileToPathGetter = methodArray[0];
        isExecutableQuery = methodArray[1];
        patternSingleBS = Pattern.compile("\\\\{1}");
        patternSpaceEnc = Pattern.compile("%20");
        exeTestLock = new Object();
        exeTestCodeRef = null;
        tempRootExec = null;
        tempRootNoexec = null;
        tempRootSet = false;
    }

    public static class StreamMonitor
    implements Runnable {
        private final InputStream[] istreams;
        private final boolean[] eos;
        private final PrintStream ostream;
        private final String prefix;

        public StreamMonitor(InputStream[] object, PrintStream printStream, String string) {
            this.istreams = object;
            this.eos = new boolean[((InputStream[])object).length];
            this.ostream = printStream;
            this.prefix = string;
            object = new InterruptSource.Thread(null, this, "StreamMonitor-" + Thread.currentThread().getName());
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }

        @Override
        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n = this.istreams.length;
                int n2 = 0;
                do {
                    for (int i = 0; i < this.istreams.length; ++i) {
                        if (this.eos[i]) continue;
                        int n3 = this.istreams[i].read(byArray);
                        if (n3 > 0) {
                            if (this.ostream == null) continue;
                            if (this.prefix != null) {
                                this.ostream.write(this.prefix.getBytes());
                            }
                            this.ostream.write(byArray, 0, n3);
                            continue;
                        }
                        ++n2;
                        this.eos[i] = true;
                    }
                    if (this.ostream == null) continue;
                    this.ostream.flush();
                } while (n2 < n);
                if (this.ostream != null) {
                    this.ostream.flush();
                    return;
                }
            }
            catch (IOException iOException) {
                if (this.ostream != null) {
                    this.ostream.flush();
                    return;
                }
            }
            catch (Throwable throwable) {
                if (this.ostream != null) {
                    this.ostream.flush();
                }
                throw throwable;
            }
        }
    }

    public static class ClassResources {
        public final ClassLoader classLoader;
        public final Class<?> contextCL;
        public final String[] resourcePaths;

        public final int resourceCount() {
            return this.resourcePaths.length;
        }

        public ClassResources(String[] stringArray, ClassLoader classLoader, Class<?> clazz) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (null != stringArray[i]) continue;
                throw new IllegalArgumentException("resourcePath[" + i + "] is null");
            }
            this.classLoader = classLoader;
            this.contextCL = clazz;
            this.resourcePaths = stringArray;
        }

        public URLConnection resolve(int n) {
            return IOUtil.getResource(this.resourcePaths[n], this.classLoader, this.contextCL);
        }
    }
}

