/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlin.time.InstantParseResult;
import kotlin.time.UnboundLocalDateTime;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0006\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0003\u001a'\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0082\b\u001a'\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0082\b\u001a\u0010\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0015H\u0000\u001a\u0014\u0010'\u001a\u00020\u0015*\u00020\u00152\u0006\u0010%\u001a\u00020\u0001H\u0002\u001a\u0014\u0010-\u001a\u00020\u0012*\u00020\u00102\u0006\u0010.\u001a\u00020\u0015H\u0002\"\u001f\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0005\"\u001f\u0010\u0006\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\u0006\u0010\u0005\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0015X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010*\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010,\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"isDistantPast", "", "Lkotlin/time/Instant;", "isDistantPast$annotations", "(Lkotlin/time/Instant;)V", "(Lkotlin/time/Instant;)Z", "isDistantFuture", "isDistantFuture$annotations", "DISTANT_PAST_SECONDS", "", "DISTANT_FUTURE_SECONDS", "MIN_SECOND", "MAX_SECOND", "parseIso", "Lkotlin/time/InstantParseResult;", "isoString", "", "formatIso", "", "instant", "DAYS_PER_CYCLE", "", "DAYS_0000_TO_1970", "safeAddOrElse", "a", "b", "action", "Lkotlin/Function0;", "", "safeMultiplyOrElse", "SECONDS_PER_HOUR", "SECONDS_PER_MINUTE", "HOURS_PER_DAY", "SECONDS_PER_DAY", "NANOS_PER_SECOND", "NANOS_PER_MILLI", "MILLIS_PER_SECOND", "isLeapYear", "year", "monthLength", "POWERS_OF_TEN", "", "asciiDigitPositionsInIsoStringAfterYear", "colonsInIsoOffsetString", "asciiDigitsInIsoOffsetString", "truncateForErrorMessage", "maxLength", "kotlin-stdlib"})
public final class InstantKt {
    private static final long DISTANT_PAST_SECONDS = -3217862419201L;
    private static final long DISTANT_FUTURE_SECONDS = 3093527980800L;
    private static final long MIN_SECOND = -31557014167219200L;
    private static final long MAX_SECOND = 31556889864403199L;
    private static final int DAYS_PER_CYCLE = 146097;
    private static final int DAYS_0000_TO_1970 = 719528;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    public static final int NANOS_PER_SECOND = 1000000000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int[] POWERS_OF_TEN;
    private static final int[] asciiDigitPositionsInIsoStringAfterYear;
    private static final int[] colonsInIsoOffsetString;
    private static final int[] asciiDigitsInIsoOffsetString;

    private static final boolean isDistantPast(Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "");
        return instant.compareTo(Instant.Companion.getDISTANT_PAST()) <= 0;
    }

    public static /* synthetic */ void isDistantPast$annotations(Instant instant) {
    }

    private static final boolean isDistantFuture(Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "");
        return instant.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0;
    }

    public static /* synthetic */ void isDistantFuture$annotations(Instant instant) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final InstantParseResult parseIso(CharSequence charSequence) {
        UnboundLocalDateTime unboundLocalDateTime;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        CharSequence charSequence2 = charSequence;
        int n9 = 0;
        if (charSequence2.length() == 0) {
            return new InstantParseResult.Failure("An empty string is not a valid Instant", charSequence);
        }
        int n10 = charSequence2.charAt(0);
        switch (n10) {
            case 43: 
            case 45: {
                ++n9;
                n8 = n10;
                break;
            }
            default: {
                n8 = 32;
            }
        }
        int n11 = n8;
        n10 = n9;
        int n12 = 0;
        while (n9 < charSequence2.length()) {
            n7 = charSequence2.charAt(n9);
            boolean bl = 48 <= n7 ? n7 < 58 : false;
            if (!bl) break;
            n12 = n12 * 10 + (charSequence2.charAt(n9) - 48);
            ++n9;
        }
        if ((n7 = n9 - n10) > 10) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected at most 10 digits for the year number, got " + n7 + " digits");
        }
        if (n7 == 10 && Intrinsics.compare(charSequence2.charAt(n10), 50) >= 0) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected at most 9 digits for the year number or year 1000000000, got " + n7 + " digits");
        }
        if (n7 < 4) {
            return InstantKt.parseIso$parseFailure(charSequence, "The year number must be padded to 4 digits, got " + n7 + " digits");
        }
        if (n11 == 43 && n7 == 4) {
            return InstantKt.parseIso$parseFailure(charSequence, "The '+' sign at the start is only valid for year numbers longer than 4 digits");
        }
        if (n11 == 32 && n7 != 4) {
            return InstantKt.parseIso$parseFailure(charSequence, "A '+' or '-' sign is required for year numbers longer than 4 digits");
        }
        int n13 = n11 = n11 == 45 ? -n12 : n12;
        if (charSequence2.length() < n9 + 16) {
            return InstantKt.parseIso$parseFailure(charSequence, "The input string is too short");
        }
        Object object = InstantKt.parseIso$expect(charSequence, "'-'", n9, InstantKt::parseIso$lambda$0);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        object = InstantKt.parseIso$expect(charSequence, "'-'", n9 + 3, InstantKt::parseIso$lambda$2);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        object = InstantKt.parseIso$expect(charSequence, "'T' or 't'", n9 + 6, InstantKt::parseIso$lambda$4);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        object = InstantKt.parseIso$expect(charSequence, "':'", n9 + 9, InstantKt::parseIso$lambda$6);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        object = InstantKt.parseIso$expect(charSequence, "':'", n9 + 12, InstantKt::parseIso$lambda$8);
        if (object != null) {
            InstantParseResult.Failure failure = object;
            return failure;
        }
        for (Object object2 : (Object)asciiDigitPositionsInIsoStringAfterYear) {
            InstantParseResult.Failure failure = InstantKt.parseIso$expect(charSequence, "an ASCII digit", n9 + object2, InstantKt::parseIso$lambda$10);
            if (failure == null) continue;
            InstantParseResult.Failure failure2 = failure;
            return failure2;
        }
        int n14 = InstantKt.parseIso$twoDigitNumber(charSequence2, n9 + 1);
        n12 = InstantKt.parseIso$twoDigitNumber(charSequence2, n9 + 4);
        n7 = InstantKt.parseIso$twoDigitNumber(charSequence2, n9 + 7);
        int n15 = InstantKt.parseIso$twoDigitNumber(charSequence2, n9 + 10);
        int n16 = InstantKt.parseIso$twoDigitNumber(charSequence2, n9 + 13);
        if (charSequence2.charAt(n9 + 15) == '.') {
            n6 = 0;
            for (n9 = n5 = n9 + 16; n9 < charSequence2.length(); ++n9) {
                n4 = charSequence2.charAt(n9);
                boolean bl = 48 <= n4 ? n4 < 58 : false;
                if (!bl) break;
                n6 = n6 * 10 + (charSequence2.charAt(n9) - 48);
            }
            boolean bl = (n4 = n9 - n5) > 0 ? n4 < 10 : false;
            if (!bl) return InstantKt.parseIso$parseFailure(charSequence, "1..9 digits are supported for the fraction of the second, got " + n4 + " digits");
            n3 = n6 * POWERS_OF_TEN[9 - n4];
        } else {
            n9 += 15;
            n3 = n2 = 0;
        }
        if (n9 >= charSequence2.length()) {
            return InstantKt.parseIso$parseFailure(charSequence, "The UTC offset at the end of the string is missing");
        }
        n6 = charSequence2.charAt(n9);
        switch (n6) {
            case 90: 
            case 122: {
                if (charSequence2.length() != n9 + 1) return InstantKt.parseIso$parseFailure(charSequence, "Extra text after the instant at position " + (n9 + 1));
                n = 0;
                break;
            }
            case 43: 
            case 45: {
                int n17;
                int n18;
                n4 = charSequence2.length() - n9;
                if (n4 > 9) {
                    CharSequence charSequence3 = charSequence2;
                    n5 = charSequence3.length();
                    return InstantKt.parseIso$parseFailure(charSequence, "The UTC offset string \"" + InstantKt.truncateForErrorMessage(((Object)charSequence3.subSequence(n9, n5)).toString(), 16) + "\" is too long");
                }
                if (n4 % 3 != 0) {
                    CharSequence charSequence4 = charSequence2;
                    n5 = charSequence4.length();
                    return InstantKt.parseIso$parseFailure(charSequence, "Invalid UTC offset string \"" + ((Object)charSequence4.subSequence(n9, n5)).toString() + '\"');
                }
                for (int n19 : colonsInIsoOffsetString) {
                    if (n9 + n19 >= charSequence2.length()) break;
                    if (charSequence2.charAt(n9 + n19) == ':') continue;
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected ':' at index " + (n9 + n19) + ", got '" + charSequence2.charAt(n9 + n19) + '\'');
                }
                for (int n19 : asciiDigitsInIsoOffsetString) {
                    if (n9 + n19 >= charSequence2.length()) break;
                    n18 = charSequence2.charAt(n9 + n19);
                    if (48 <= n18 ? n18 < 58 : false) continue;
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected an ASCII digit at index " + (n9 + n19) + ", got '" + charSequence2.charAt(n9 + n19) + '\'');
                }
                int n20 = InstantKt.parseIso$twoDigitNumber(charSequence2, n9 + 1);
                n5 = n4 > 3 ? InstantKt.parseIso$twoDigitNumber(charSequence2, n9 + 4) : 0;
                int n21 = n17 = n4 > 6 ? InstantKt.parseIso$twoDigitNumber(charSequence2, n9 + 7) : 0;
                if (n5 > 59) {
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected offset-minute-of-hour in 0..59, got " + n5);
                }
                if (n17 > 59) {
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected offset-second-of-minute in 0..59, got " + n17);
                }
                if (n20 > 17 && (n20 != 18 || n5 != 0 || n17 != 0)) {
                    CharSequence charSequence5 = charSequence2;
                    n18 = charSequence5.length();
                    return InstantKt.parseIso$parseFailure(charSequence, "Expected an offset in -18:00..+18:00, got " + ((Object)charSequence5.subSequence(n9, n18)).toString());
                }
                n = (n20 * 3600 + n5 * 60 + n17) * (n6 == 45 ? -1 : 1);
                break;
            }
            default: {
                return InstantKt.parseIso$parseFailure(charSequence, "Expected the UTC offset at position " + n9 + ", got '" + (char)n6 + '\'');
            }
        }
        n5 = n;
        if (!(n14 > 0 ? n14 < 13 : false)) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected a month number in 1..12, got " + n14);
        }
        if (!(n12 > 0 ? n12 <= InstantKt.monthLength(n14, InstantKt.isLeapYear(n11)) : false)) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected a valid day-of-month for month " + n14 + " of year " + n11 + ", got " + n12);
        }
        if (n7 > 23) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected hour in 0..23, got " + n7);
        }
        if (n15 > 59) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected minute-of-hour in 0..59, got " + n15);
        }
        if (n16 > 59) {
            return InstantKt.parseIso$parseFailure(charSequence, "Expected second-of-minute in 0..59, got " + n16);
        }
        UnboundLocalDateTime unboundLocalDateTime2 = unboundLocalDateTime = new UnboundLocalDateTime(n11, n14, n12, n7, n15, n16, n2);
        UnboundLocalDateTime unboundLocalDateTime3 = unboundLocalDateTime;
        long l = unboundLocalDateTime.getYear();
        long l2 = 365L * l;
        l2 = l >= 0L ? (l2 += (l + 3L) / 4L - (l + 99L) / 100L + (l + 399L) / 400L) : (l2 -= l / -4L - l / -100L + l / -400L);
        l2 += (long)((367 * unboundLocalDateTime3.getMonth() - 362) / 12);
        l2 += (long)(unboundLocalDateTime3.getDay() - 1);
        if (unboundLocalDateTime3.getMonth() > 2) {
            l2 += -1L;
            if (!InstantKt.isLeapYear(unboundLocalDateTime3.getYear())) {
                l2 += -1L;
            }
        }
        long l3 = l2 - 719528L;
        int n22 = unboundLocalDateTime2.getHour() * 3600 + unboundLocalDateTime2.getMinute() * 60 + unboundLocalDateTime2.getSecond();
        long l4 = l3 * 86400L + (long)n22 - (long)n5;
        n22 = unboundLocalDateTime.getNanosecond();
        long l5 = l4;
        return new InstantParseResult.Success(l5, n22);
    }

    private static final String formatIso(Instant object) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        object = UnboundLocalDateTime.Companion.fromInstant((Instant)object);
        StringBuilder stringBuilder3 = stringBuilder2;
        int n = ((UnboundLocalDateTime)object).getYear();
        if (Math.abs(n) < 1000) {
            StringBuilder stringBuilder4 = new StringBuilder();
            if (n >= 0) {
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append(n + 10000).deleteCharAt(0), "");
            } else {
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append(n - 10000).deleteCharAt(1), "");
            }
            stringBuilder3.append((CharSequence)stringBuilder4);
        } else {
            if (n >= 10000) {
                stringBuilder3.append('+');
            }
            stringBuilder3.append(n);
        }
        stringBuilder2.append('-');
        InstantKt.formatIso$lambda$13$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getMonth());
        stringBuilder2.append('-');
        InstantKt.formatIso$lambda$13$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getDay());
        stringBuilder2.append('T');
        InstantKt.formatIso$lambda$13$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getHour());
        stringBuilder2.append(':');
        InstantKt.formatIso$lambda$13$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getMinute());
        stringBuilder2.append(':');
        InstantKt.formatIso$lambda$13$appendTwoDigits(stringBuilder2, stringBuilder2, ((UnboundLocalDateTime)object).getSecond());
        if (((UnboundLocalDateTime)object).getNanosecond() != 0) {
            stringBuilder2.append('.');
            n = 0;
            while (((UnboundLocalDateTime)object).getNanosecond() % POWERS_OF_TEN[n + 1] == 0) {
                ++n;
            }
            int n2 = n;
            n = n2 - n2 % 3;
            int n3 = ((UnboundLocalDateTime)object).getNanosecond() / POWERS_OF_TEN[n];
            object = String.valueOf(n3 + POWERS_OF_TEN[9 - n]);
            Intrinsics.checkNotNull(object);
            String string = ((String)object).substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "");
            stringBuilder2.append(string);
        }
        stringBuilder2.append('Z');
        return stringBuilder.toString();
    }

    private static final long safeAddOrElse(long l, long l2, Function0 function0) {
        long l3 = l + l2;
        if ((l ^ l3) < 0L && (l ^ l2) >= 0L) {
            function0.invoke();
            throw new KotlinNothingValueException();
        }
        return l3;
    }

    private static final long safeMultiplyOrElse(long l, long l2, Function0 function0) {
        if (l2 == 1L) {
            return l;
        }
        if (l == 1L) {
            return l2;
        }
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        long l3 = l * l2;
        if (l3 / l2 != l || l == Long.MIN_VALUE && l2 == -1L || l2 == Long.MIN_VALUE && l == -1L) {
            function0.invoke();
            throw new KotlinNothingValueException();
        }
        return l3;
    }

    public static final boolean isLeapYear(int n) {
        return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    private static final int monthLength(int n, boolean bl) {
        switch (n) {
            case 2: {
                if (bl) {
                    return 29;
                }
                return 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    private static final String truncateForErrorMessage(CharSequence charSequence, int n) {
        if (charSequence.length() <= n) {
            return ((Object)charSequence).toString();
        }
        return ((Object)charSequence.subSequence(0, n)).toString() + "...";
    }

    private static final InstantParseResult.Failure parseIso$parseFailure(CharSequence charSequence, String string) {
        return new InstantParseResult.Failure(string + " when parsing an Instant from \"" + InstantKt.truncateForErrorMessage(charSequence, 64) + '\"', charSequence);
    }

    private static final InstantParseResult.Failure parseIso$expect(CharSequence charSequence, String string, int n, Function1<? super Character, Boolean> function1) {
        char c = charSequence.charAt(n);
        if (function1.invoke(Character.valueOf(c)).booleanValue()) {
            return null;
        }
        return InstantKt.parseIso$parseFailure(charSequence, "Expected " + string + ", but got '" + c + "' at position " + n);
    }

    private static final boolean parseIso$lambda$0(char c) {
        return c == '-';
    }

    private static final boolean parseIso$lambda$2(char c) {
        return c == '-';
    }

    private static final boolean parseIso$lambda$4(char c) {
        return c == 'T' || c == 't';
    }

    private static final boolean parseIso$lambda$6(char c) {
        return c == ':';
    }

    private static final boolean parseIso$lambda$8(char c) {
        return c == ':';
    }

    private static final boolean parseIso$lambda$10(char c) {
        if ('0' <= c) {
            return c < ':';
        }
        return false;
    }

    private static final int parseIso$twoDigitNumber(CharSequence charSequence, int n) {
        return (charSequence.charAt(n) - 48) * 10 + (charSequence.charAt(n + 1) - 48);
    }

    private static final void formatIso$lambda$13$appendTwoDigits(Appendable appendable, StringBuilder stringBuilder, int n) {
        if (n < 10) {
            appendable.append('0');
        }
        stringBuilder.append(n);
    }

    public static final /* synthetic */ String access$formatIso(Instant instant) {
        return InstantKt.formatIso(instant);
    }

    public static final /* synthetic */ InstantParseResult access$parseIso(CharSequence charSequence) {
        return InstantKt.parseIso(charSequence);
    }

    public static final /* synthetic */ String access$truncateForErrorMessage(CharSequence charSequence, int n) {
        return InstantKt.truncateForErrorMessage(charSequence, n);
    }

    static {
        int[] nArray = new int[10];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        nArray2[1] = 10;
        nArray2[2] = 100;
        nArray2[3] = 1000;
        nArray2[4] = 10000;
        nArray2[5] = 100000;
        nArray2[6] = 1000000;
        nArray2[7] = 10000000;
        nArray2[8] = 100000000;
        nArray2[9] = 1000000000;
        POWERS_OF_TEN = nArray2;
        int[] nArray3 = new int[10];
        nArray2 = nArray3;
        nArray3[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 8;
        nArray2[6] = 10;
        nArray2[7] = 11;
        nArray2[8] = 13;
        nArray2[9] = 14;
        asciiDigitPositionsInIsoStringAfterYear = nArray2;
        int[] nArray4 = new int[2];
        nArray2 = nArray4;
        nArray4[0] = 3;
        nArray2[1] = 6;
        colonsInIsoOffsetString = nArray2;
        int[] nArray5 = new int[6];
        nArray2 = nArray5;
        nArray5[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 8;
        asciiDigitsInIsoOffsetString = nArray2;
    }
}

