/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidKt__UuidJVMKt;

@Metadata(mv={2, 2, 0}, k=5, xi=49, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a,\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0001\u001a\u0014\u0010\u000e\u001a\u00020\t*\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\u0010\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000fH\u0001\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000fH\u0001\u001a\u0019\u0010\u0016\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\b\u0018\u001a\u0019\u0010\u0016\u001a\u00020\u000f*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\b\u0018\u00a8\u0006\u001a"}, d2={"uuidFromRandomBytes", "Lkotlin/uuid/Uuid;", "randomBytes", "", "getLongAtCommonImpl", "", "index", "", "formatBytesIntoCommonImpl", "", "dst", "dstOffset", "startIndex", "endIndex", "checkHyphenAt", "", "setLongAtCommonImpl", "value", "uuidParseHexDashCommonImpl", "hexDashString", "uuidParseHexCommonImpl", "hexString", "truncateForErrorMessage", "maxLength", "truncateForErrorMessage$UuidKt__UuidKt", "maxSize", "kotlin-stdlib"}, xs="kotlin/uuid/UuidKt")
class UuidKt__UuidKt
extends UuidKt__UuidJVMKt {
    public static final Uuid uuidFromRandomBytes(byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "");
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        return Uuid.Companion.fromByteArray(byArray);
    }

    public static final long getLongAtCommonImpl(byte[] byArray, int n) {
        Intrinsics.checkNotNullParameter(byArray, "");
        return ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
    }

    public static final void formatBytesIntoCommonImpl(long l, byte[] byArray, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "");
        n2 = 7 - n2;
        n3 = 8 - n3;
        if (n3 <= n2) {
            while (true) {
                int n4 = n2 << 3;
                n4 = (int)(l >> n4 & 0xFFL);
                n4 = HexExtensionsKt.getBYTE_TO_LOWER_CASE_HEX_DIGITS()[n4];
                byArray[n++] = (byte)(n4 >> 8);
                byArray[n++] = (byte)n4;
                if (n2 == n3) break;
                --n2;
            }
        }
    }

    public static final void checkHyphenAt(String string, int n) {
        Intrinsics.checkNotNullParameter(string, "");
        if (!(string.charAt(n) == '-')) {
            string = "Expected '-' (hyphen) at index " + n + ", but was '" + string.charAt(n) + '\'';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void setLongAtCommonImpl(byte[] byArray, int n, long l) {
        Intrinsics.checkNotNullParameter(byArray, "");
        for (int i = 7; i >= 0; --i) {
            int n2 = i << 3;
            byArray[n++] = (byte)(l >> n2);
        }
    }

    public static final Uuid uuidParseHexDashCommonImpl(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        long l = HexExtensionsKt.hexToLong$default(string, 0, 8, null, 4, null);
        UuidKt.checkHyphenAt(string, 8);
        long l2 = HexExtensionsKt.hexToLong$default(string, 9, 13, null, 4, null);
        UuidKt.checkHyphenAt(string, 13);
        long l3 = HexExtensionsKt.hexToLong$default(string, 14, 18, null, 4, null);
        UuidKt.checkHyphenAt(string, 18);
        long l4 = HexExtensionsKt.hexToLong$default(string, 19, 23, null, 4, null);
        UuidKt.checkHyphenAt(string, 23);
        long l5 = HexExtensionsKt.hexToLong$default(string, 24, 36, null, 4, null);
        long l6 = l << 32 | l2 << 16 | l3;
        long l7 = l4 << 48 | l5;
        return Uuid.Companion.fromLongs(l6, l7);
    }

    public static final Uuid uuidParseHexCommonImpl(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        long l = HexExtensionsKt.hexToLong$default(string, 0, 16, null, 4, null);
        long l2 = HexExtensionsKt.hexToLong$default(string, 16, 32, null, 4, null);
        return Uuid.Companion.fromLongs(l, l2);
    }

    private static final String truncateForErrorMessage$UuidKt__UuidKt(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Intrinsics.checkNotNull(string);
        String string2 = string.substring(0, n);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return stringBuilder.append(string2).append("...").toString();
    }

    private static final String truncateForErrorMessage$UuidKt__UuidKt(byte[] byArray, int n) {
        return ArraysKt.joinToString$default(byArray, null, (CharSequence)"[", (CharSequence)"]", n, null, null, 49, null);
    }

    public static final /* synthetic */ String access$truncateForErrorMessage(String string, int n) {
        return UuidKt__UuidKt.truncateForErrorMessage$UuidKt__UuidKt(string, n);
    }

    public static final /* synthetic */ String access$truncateForErrorMessage(byte[] byArray, int n) {
        return UuidKt__UuidKt.truncateForErrorMessage$UuidKt__UuidKt(byArray, n);
    }
}

