/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.ComposedLastHttpContent;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<HttpObject> {
    static final String IDENTITY = HttpHeaderValues.IDENTITY.toString();
    protected ChannelHandlerContext ctx;
    private EmbeddedChannel decoder;
    private boolean continueResponse;
    private boolean needRead = true;

    protected void decode(ChannelHandlerContext object, HttpObject httpObject, List<Object> list) {
        try {
            if (httpObject instanceof HttpResponse && ((HttpResponse)httpObject).status().code() == 100) {
                if (!(httpObject instanceof LastHttpContent)) {
                    this.continueResponse = true;
                }
                list.add(ReferenceCountUtil.retain((Object)httpObject));
                return;
            }
            if (this.continueResponse) {
                if (httpObject instanceof LastHttpContent) {
                    this.continueResponse = false;
                }
                list.add(ReferenceCountUtil.retain((Object)httpObject));
                return;
            }
            if (httpObject instanceof HttpMessage) {
                int n;
                this.cleanup();
                object = (HttpMessage)httpObject;
                Object object2 = object.headers();
                String string = ((HttpHeaders)object2).get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
                string = string != null ? string.trim() : ((string = ((HttpHeaders)object2).get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) != null ? ((n = string.indexOf(",")) != -1 ? string.substring(0, n).trim() : string.trim()) : IDENTITY);
                this.decoder = this.newContentDecoder(string);
                if (this.decoder == null) {
                    if (object instanceof HttpContent) {
                        ((HttpContent)object).retain();
                    }
                    list.add(object);
                    return;
                }
                if (((HttpHeaders)object2).contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                    ((HttpHeaders)object2).remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    ((HttpHeaders)object2).set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
                if (HttpHeaderValues.IDENTITY.contentEquals((CharSequence)(string = this.getTargetContentEncoding(string)))) {
                    ((HttpHeaders)object2).remove((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    ((HttpHeaders)object2).set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)string);
                }
                if (object instanceof HttpContent) {
                    DefaultHttpMessage defaultHttpMessage;
                    if (object instanceof HttpRequest) {
                        object2 = (HttpRequest)object;
                        defaultHttpMessage = new DefaultHttpRequest(object2.protocolVersion(), object2.method(), object2.uri());
                    } else if (object instanceof HttpResponse) {
                        object2 = (HttpResponse)object;
                        defaultHttpMessage = new DefaultHttpResponse(object2.protocolVersion(), object2.status());
                    } else {
                        throw new CodecException("Object of class " + object.getClass().getName() + " is not an HttpRequest or HttpResponse");
                    }
                    defaultHttpMessage.headers().set(object.headers());
                    defaultHttpMessage.setDecoderResult(object.decoderResult());
                    list.add(defaultHttpMessage);
                } else {
                    list.add(object);
                }
            }
            if (httpObject instanceof HttpContent) {
                object = (HttpContent)httpObject;
                if (this.decoder == null) {
                    list.add(object.retain());
                } else {
                    this.decodeContent((HttpContent)object, list);
                }
            }
            return;
        }
        finally {
            this.needRead = list.isEmpty();
        }
    }

    private void decodeContent(HttpContent object, List<Object> list) {
        ByteBuf byteBuf = object.content();
        this.decode(byteBuf, list);
        if (object instanceof LastHttpContent) {
            this.finishDecode(list);
            object = (LastHttpContent)object;
            object = object.trailingHeaders();
            if (((HttpHeaders)object).isEmpty()) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                return;
            }
            list.add(new ComposedLastHttpContent((HttpHeaders)object, DecoderResult.SUCCESS));
        }
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        boolean bl = this.needRead;
        this.needRead = true;
        try {
            channelHandlerContext.fireChannelReadComplete();
        }
        catch (Throwable throwable) {
            if (bl && !channelHandlerContext.channel().config().isAutoRead()) {
                channelHandlerContext.read();
            }
            throw throwable;
        }
        if (bl && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
            return;
        }
    }

    protected abstract EmbeddedChannel newContentDecoder(String var1);

    protected String getTargetContentEncoding(String string) {
        return IDENTITY;
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanupSafely(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanupSafely(channelHandlerContext);
        super.channelInactive(channelHandlerContext);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.decoder.finishAndReleaseAll();
            this.decoder = null;
        }
    }

    private void cleanupSafely(ChannelHandlerContext channelHandlerContext) {
        try {
            this.cleanup();
            return;
        }
        catch (Throwable throwable) {
            channelHandlerContext.fireExceptionCaught(throwable);
            return;
        }
    }

    private void decode(ByteBuf byteBuf, List<Object> list) {
        this.decoder.writeInbound(new Object[]{byteBuf.retain()});
        this.fetchDecoderOutput(list);
    }

    private void finishDecode(List<Object> list) {
        if (this.decoder.finish()) {
            this.fetchDecoderOutput(list);
        }
        this.decoder = null;
    }

    private void fetchDecoderOutput(List<Object> list) {
        ByteBuf byteBuf;
        while ((byteBuf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            list.add(new DefaultHttpContent(byteBuf));
        }
    }
}

