/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMessageDecoderResult;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.handler.codec.http.TooLongHttpLineException;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final boolean DEFAULT_CHUNKED_SUPPORTED = true;
    public static final boolean DEFAULT_ALLOW_PARTIAL_CHUNKS = true;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final boolean DEFAULT_VALIDATE_HEADERS = true;
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    public static final boolean DEFAULT_ALLOW_DUPLICATE_CONTENT_LENGTHS = false;
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    private final boolean allowPartialChunks;
    @Deprecated
    protected final boolean validateHeaders;
    protected final HttpHeadersFactory headersFactory;
    protected final HttpHeadersFactory trailersFactory;
    private final boolean allowDuplicateContentLengths;
    private final ByteBuf parserScratchBuffer;
    private final HeaderParser headerParser;
    private final LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private boolean chunked;
    private boolean isSwitchingToNonHttp1Protocol;
    private final AtomicBoolean resetRequested = new AtomicBoolean();
    private AsciiString name;
    private String value;
    private LastHttpContent trailer;
    private State currentState = State.SKIP_CONTROL_CHARS;
    private static final boolean[] SP_LENIENT_BYTES;
    private static final boolean[] LATIN_WHITESPACE;
    private static final boolean[] ISO_CONTROL_OR_WHITESPACE;
    private static final ByteProcessor SKIP_CONTROL_CHARS_BYTES;

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        try {
            this.parserScratchBuffer.release();
            return;
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    protected HttpObjectDecoder() {
        this(new HttpDecoderConfig());
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl));
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl).setValidateHeaders(bl2));
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl).setValidateHeaders(bl2).setInitialBufferSize(n4));
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl).setValidateHeaders(bl2).setInitialBufferSize(n4).setAllowDuplicateContentLengths(bl3));
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3, boolean bl4) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl).setValidateHeaders(bl2).setInitialBufferSize(n4).setAllowDuplicateContentLengths(bl3).setAllowPartialChunks(bl4));
    }

    protected HttpObjectDecoder(HttpDecoderConfig httpDecoderConfig) {
        ObjectUtil.checkNotNull((Object)httpDecoderConfig, (String)"config");
        this.parserScratchBuffer = Unpooled.buffer((int)httpDecoderConfig.getInitialBufferSize());
        HttpObjectDecoder httpObjectDecoder = this;
        this.lineParser = httpObjectDecoder.new LineParser(httpObjectDecoder.parserScratchBuffer, httpDecoderConfig.getMaxInitialLineLength());
        this.headerParser = new HeaderParser(this.parserScratchBuffer, httpDecoderConfig.getMaxHeaderSize());
        this.maxChunkSize = httpDecoderConfig.getMaxChunkSize();
        this.chunkedSupported = httpDecoderConfig.isChunkedSupported();
        this.headersFactory = httpDecoderConfig.getHeadersFactory();
        this.trailersFactory = httpDecoderConfig.getTrailersFactory();
        this.validateHeaders = this.isValidating(this.headersFactory);
        this.allowDuplicateContentLengths = httpDecoderConfig.isAllowDuplicateContentLengths();
        this.allowPartialChunks = httpDecoderConfig.isAllowPartialChunks();
    }

    protected boolean isValidating(HttpHeadersFactory httpHeadersFactory) {
        if (httpHeadersFactory instanceof DefaultHttpHeadersFactory) {
            return ((DefaultHttpHeadersFactory)(httpHeadersFactory = (DefaultHttpHeadersFactory)httpHeadersFactory)).isValidatingHeaderNames() || ((DefaultHttpHeadersFactory)httpHeadersFactory).isValidatingHeaderValues();
        }
        return true;
    }

    protected void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if (this.resetRequested.get()) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: {
                try {
                    object = this.lineParser.parse(byteBuf);
                    if (object == null) {
                        return;
                    }
                    String[] stringArray = this.splitInitialLine((ByteBuf)object);
                    assert (stringArray.length == 3) : "initialLine::length must be 3";
                    this.message = this.createMessage(stringArray);
                    this.currentState = State.READ_HEADER;
                }
                catch (Exception exception) {
                    HttpObjectDecoder httpObjectDecoder = this;
                    list.add(httpObjectDecoder.invalidMessage(httpObjectDecoder.message, byteBuf, exception));
                    return;
                }
            }
            case READ_HEADER: {
                try {
                    object = this.readHeaders(byteBuf);
                    if (object == null) {
                        return;
                    }
                    this.currentState = object;
                    switch (2.$SwitchMap$io$netty$handler$codec$http$HttpObjectDecoder$State[((Enum)object).ordinal()]) {
                        case 1: {
                            this.addCurrentMessage(list);
                            list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                            this.resetNow();
                            return;
                        }
                        case 2: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            this.addCurrentMessage(list);
                            return;
                        }
                    }
                    if (this.contentLength == 0L || this.contentLength == -1L && this.isDecodingRequest()) {
                        this.addCurrentMessage(list);
                        list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                        this.resetNow();
                        return;
                    }
                    assert (object == State.READ_FIXED_LENGTH_CONTENT || object == State.READ_VARIABLE_LENGTH_CONTENT);
                    this.addCurrentMessage(list);
                    if (object == State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = this.contentLength;
                    }
                    return;
                }
                catch (Exception exception) {
                    HttpObjectDecoder httpObjectDecoder = this;
                    list.add(httpObjectDecoder.invalidMessage(httpObjectDecoder.message, byteBuf, exception));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int n = Math.min(byteBuf.readableBytes(), this.maxChunkSize);
                if (n > 0) {
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n);
                    list.add(new DefaultHttpContent(byteBuf2));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int n = byteBuf.readableBytes();
                if (n == 0) {
                    return;
                }
                int n2 = Math.min(n, this.maxChunkSize);
                if ((long)n2 > this.chunkSize) {
                    n2 = (int)this.chunkSize;
                }
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n2);
                this.chunkSize -= (long)n2;
                if (this.chunkSize == 0L) {
                    list.add(new DefaultLastHttpContent(byteBuf3, this.trailersFactory));
                    this.resetNow();
                    return;
                }
                list.add(new DefaultHttpContent(byteBuf3));
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    object = this.lineParser.parse(byteBuf);
                    if (object == null) {
                        return;
                    }
                    int n = HttpObjectDecoder.getChunkSize(object.array(), object.arrayOffset() + object.readerIndex(), object.readableBytes());
                    this.chunkSize = n;
                    if (n == 0) {
                        this.currentState = State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = State.READ_CHUNKED_CONTENT;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int n = Math.min((int)this.chunkSize, this.maxChunkSize);
                if (!this.allowPartialChunks && byteBuf.readableBytes() < n) {
                    return;
                }
                if ((n = Math.min(n, byteBuf.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent defaultHttpContent = new DefaultHttpContent(byteBuf.readRetainedSlice(n));
                this.chunkSize -= (long)n;
                list.add(defaultHttpContent);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int n = byteBuf.writerIndex();
                int n3 = byteBuf.readerIndex();
                while (n > n3) {
                    byte by;
                    if ((by = byteBuf.getByte(n3++)) != 10) continue;
                    this.currentState = State.READ_CHUNK_SIZE;
                    break;
                }
                byteBuf.readerIndex(n3);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    object = this.readTrailingHeaders(byteBuf);
                    if (object == null) {
                        return;
                    }
                    list.add(object);
                    this.resetNow();
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                ByteBuf byteBuf4 = byteBuf;
                byteBuf4.skipBytes(byteBuf4.readableBytes());
                return;
            }
            case UPGRADED: {
                int n = byteBuf.readableBytes();
                if (n <= 0) break;
                list.add(byteBuf.readBytes(n));
            }
        }
    }

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        super.decodeLast(channelHandlerContext, byteBuf, list);
        if (this.resetRequested.get()) {
            this.resetNow();
        }
        switch (this.currentState) {
            case READ_VARIABLE_LENGTH_CONTENT: {
                if (!this.chunked && !byteBuf.isReadable()) {
                    list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                    this.resetNow();
                }
                return;
            }
            case READ_HEADER: {
                HttpObjectDecoder httpObjectDecoder = this;
                list.add(httpObjectDecoder.invalidMessage(httpObjectDecoder.message, Unpooled.EMPTY_BUFFER, (Exception)new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            case READ_CHUNK_SIZE: 
            case READ_FIXED_LENGTH_CONTENT: 
            case READ_CHUNKED_CONTENT: 
            case READ_CHUNK_DELIMITER: 
            case READ_CHUNK_FOOTER: {
                boolean bl;
                if (!(this.isDecodingRequest() || this.chunked ? true : (bl = this.contentLength > 0L))) {
                    list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                }
                this.resetNow();
                return;
            }
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: 
            case BAD_MESSAGE: 
            case UPGRADED: {
                return;
            }
        }
        throw new IllegalStateException("Unhandled state " + (Object)((Object)this.currentState));
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                }
            }
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    private void addCurrentMessage(List<Object> list) {
        HttpMessage httpMessage = this.message;
        assert (httpMessage != null);
        this.message = null;
        list.add(httpMessage);
    }

    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        if (httpMessage instanceof HttpResponse) {
            httpMessage = (HttpResponse)httpMessage;
            Object object = httpMessage.status();
            int n = object.code();
            if ((object = object.codeClass()) == HttpStatusClass.INFORMATIONAL) {
                return n != 101 || httpMessage.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !httpMessage.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
            }
            switch (n) {
                case 204: 
                case 304: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse object) {
        if (object.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        return (object = object.headers().get((CharSequence)HttpHeaderNames.UPGRADE)) == null || !((String)object).contains(HttpVersion.HTTP_1_0.text()) && !((String)object).contains(HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested.lazySet(true);
    }

    private void resetNow() {
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.chunked = false;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (this.isSwitchingToNonHttp1Protocol) {
            this.isSwitchingToNonHttp1Protocol = false;
            this.currentState = State.UPGRADED;
            return;
        }
        this.resetRequested.lazySet(false);
        this.currentState = State.SKIP_CONTROL_CHARS;
    }

    private HttpMessage invalidMessage(HttpMessage httpMessage, ByteBuf byteBuf, Exception exception) {
        this.currentState = State.BAD_MESSAGE;
        this.message = null;
        this.trailer = null;
        ByteBuf byteBuf2 = byteBuf;
        byteBuf2.skipBytes(byteBuf2.readableBytes());
        if (httpMessage == null) {
            httpMessage = this.createInvalidMessage();
        }
        httpMessage.setDecoderResult(DecoderResult.failure((Throwable)exception));
        return httpMessage;
    }

    private HttpContent invalidChunk(ByteBuf object, Exception exception) {
        this.currentState = State.BAD_MESSAGE;
        this.message = null;
        this.trailer = null;
        ByteBuf byteBuf = object;
        byteBuf.skipBytes(byteBuf.readableBytes());
        object = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        object.setDecoderResult(DecoderResult.failure((Throwable)exception));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private State readHeaders(ByteBuf byteBuf) {
        Object object;
        void string;
        HttpMessage httpMessage = this.message;
        HttpHeaders httpHeaders = httpMessage.headers();
        HeaderParser headerParser = this.headerParser;
        Object object2 = headerParser.parse(byteBuf);
        if (object2 == null) {
            return null;
        }
        int bl = object2.readableBytes();
        while (string > 0) {
            object = object2.array();
            int n = object2.arrayOffset() + object2.readerIndex();
            byte by = object[n];
            if (this.name != null && (by == 32 || by == 9)) {
                String string2 = HttpObjectDecoder.langAsciiString((byte[])object, n, (int)string).trim();
                object = this.value;
                this.value = (String)object + ' ' + string2;
            } else {
                if (this.name != null) {
                    httpHeaders.add((CharSequence)this.name, (Object)this.value);
                }
                this.splitHeader((byte[])object, n, (int)string);
            }
            object2 = headerParser.parse(byteBuf);
            if (object2 == null) {
                return null;
            }
            int n2 = object2.readableBytes();
        }
        if (this.name != null) {
            httpHeaders.add((CharSequence)this.name, (Object)this.value);
        }
        this.name = null;
        this.value = null;
        object = (Object)new HttpMessageDecoderResult(this.lineParser.size, headerParser.size);
        httpMessage.setDecoderResult((DecoderResult)object);
        object2 = httpHeaders.getAll((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (!object2.isEmpty()) {
            HttpVersion httpVersion = httpMessage.protocolVersion();
            boolean bl2 = httpVersion.majorVersion() <= 0 || httpVersion.majorVersion() == 1 && httpVersion.minorVersion() == 0;
            this.contentLength = HttpUtil.normalizeAndGetContentLength((List<? extends CharSequence>)object2, bl2, this.allowDuplicateContentLengths);
            if (this.contentLength != -1L) {
                object = ((String)object2.get(0)).trim();
                if (object2.size() > 1 || !((String)object).equals(Long.toString(this.contentLength))) {
                    httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.contentLength);
                }
            }
        } else {
            this.contentLength = HttpUtil.getWebSocketContentLength(httpMessage);
        }
        if (!this.isDecodingRequest() && httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            this.isSwitchingToNonHttp1Protocol = this.isSwitchingToNonHttp1Protocol(httpResponse);
        }
        if (this.isContentAlwaysEmpty(httpMessage)) {
            HttpUtil.setTransferEncodingChunked(httpMessage, false);
            return State.SKIP_CONTROL_CHARS;
        }
        if (HttpUtil.isTransferEncodingChunked(httpMessage)) {
            this.chunked = true;
            if (!object2.isEmpty() && httpMessage.protocolVersion() == HttpVersion.HTTP_1_1) {
                this.handleTransferEncodingChunkedWithContentLength(httpMessage);
            }
            return State.READ_CHUNK_SIZE;
        }
        if (this.contentLength >= 0L) {
            return State.READ_FIXED_LENGTH_CONTENT;
        }
        return State.READ_VARIABLE_LENGTH_CONTENT;
    }

    protected void handleTransferEncodingChunkedWithContentLength(HttpMessage httpMessage) {
        httpMessage.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        this.contentLength = Long.MIN_VALUE;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf byteBuf) {
        HeaderParser headerParser = this.headerParser;
        Object object = headerParser.parse(byteBuf);
        if (object == null) {
            return null;
        }
        LastHttpContent lastHttpContent = this.trailer;
        int n = object.readableBytes();
        if (n == 0 && lastHttpContent == null) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        AsciiString asciiString = null;
        if (lastHttpContent == null) {
            lastHttpContent = this.trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.trailersFactory);
        }
        while (n > 0) {
            Object object2;
            Object object3 = object.array();
            int n2 = object.arrayOffset() + object.readerIndex();
            int n3 = object3[n2];
            if (asciiString != null && (n3 == 32 || n3 == 9)) {
                object2 = lastHttpContent.trailingHeaders().getAll((CharSequence)asciiString);
                if (!object2.isEmpty()) {
                    n3 = object2.size() - 1;
                    object = HttpObjectDecoder.langAsciiString(object3, n2, object.readableBytes()).trim();
                    object3 = (String)object2.get(n3);
                    object2.set(n3, (String)object3 + (String)object);
                }
            } else {
                this.splitHeader((byte[])object3, n2, n);
                object2 = this.name;
                if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)object2) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)object2) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase((CharSequence)object2))) {
                    lastHttpContent.trailingHeaders().add((CharSequence)object2, (Object)this.value);
                }
                asciiString = this.name;
                this.name = null;
                this.value = null;
            }
            object = headerParser.parse(byteBuf);
            if (object == null) {
                return null;
            }
            n = object.readableBytes();
        }
        this.trailer = null;
        return lastHttpContent;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1);

    protected abstract HttpMessage createInvalidMessage();

    private static int skipWhiteSpaces(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (HttpObjectDecoder.isWhitespace(byArray[n + i])) continue;
            return i;
        }
        return n2;
    }

    private static int getChunkSize(byte[] byArray, int n, int n2) {
        int n3 = HttpObjectDecoder.skipWhiteSpaces(byArray, n, n2);
        if (n3 == n2) {
            throw new NumberFormatException();
        }
        n += n3;
        n2 -= n3;
        n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = StringUtil.decodeHexNibble((byte)byArray[n + i]);
            if (n4 == -1) {
                byte by = byArray[n + i];
                if (by == 59 || HttpObjectDecoder.isControlOrWhitespaceAsciiChar(by)) {
                    if (i == 0) {
                        throw new NumberFormatException("Empty chunk size");
                    }
                    return n3;
                }
                throw new NumberFormatException("Invalid character in chunk size");
            }
            n3 <<= 4;
            if ((n3 += n4) >= 0) continue;
            throw new NumberFormatException("Chunk size overflow: " + n3);
        }
        return n3;
    }

    private String[] splitInitialLine(ByteBuf byteBuf) {
        byte[] byArray = byteBuf.array();
        int n = byteBuf.arrayOffset();
        int n2 = (n += byteBuf.readerIndex()) + byteBuf.readableBytes();
        int n3 = byArray[n2 - 1];
        if (HttpObjectDecoder.isControlOrWhitespaceAsciiChar((byte)n3) && (this.isDecodingRequest() || !HttpObjectDecoder.isOWS((byte)n3))) {
            throw new IllegalArgumentException("Illegal character in request line: 0x" + Integer.toHexString(n3));
        }
        n3 = HttpObjectDecoder.findNonSPLenient(byArray, n, n2);
        int n4 = HttpObjectDecoder.findSPLenient(byArray, n3, n2);
        int n5 = HttpObjectDecoder.findNonSPLenient(byArray, n4, n2);
        int n6 = HttpObjectDecoder.findSPLenient(byArray, n5, n2);
        int n7 = HttpObjectDecoder.findNonSPLenient(byArray, n6, n2);
        n2 = HttpObjectDecoder.findEndOfString(byArray, Math.max(n7 - 1, n), n2);
        return new String[]{this.splitFirstWordInitialLine(byArray, n3, n4 - n3), this.splitSecondWordInitialLine(byArray, n5, n6 - n5), n7 < n2 ? this.splitThirdWordInitialLine(byArray, n7, n2 - n7) : ""};
    }

    protected String splitFirstWordInitialLine(byte[] byArray, int n, int n2) {
        return HttpObjectDecoder.langAsciiString(byArray, n, n2);
    }

    protected String splitSecondWordInitialLine(byte[] byArray, int n, int n2) {
        return HttpObjectDecoder.langAsciiString(byArray, n, n2);
    }

    protected String splitThirdWordInitialLine(byte[] byArray, int n, int n2) {
        return HttpObjectDecoder.langAsciiString(byArray, n, n2);
    }

    private static String langAsciiString(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        if (n == 0) {
            if (n2 == byArray.length) {
                return new String(byArray, 0, 0, byArray.length);
            }
            return new String(byArray, 0, 0, n2);
        }
        return new String(byArray, 0, n, n2);
    }

    private void splitHeader(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        n2 = n + n2;
        boolean bl = this.isDecodingRequest();
        for (n4 = n; n4 < n2 && (n3 = byArray[n4]) != 58 && (bl || !HttpObjectDecoder.isOWS((byte)n3)); ++n4) {
        }
        if (n4 == n2) {
            throw new IllegalArgumentException("No colon found");
        }
        for (n3 = n4; n3 < n2; ++n3) {
            if (byArray[n3] != 58) continue;
            ++n3;
            break;
        }
        this.name = this.splitHeaderName(byArray, n, n4 - n);
        n4 = HttpObjectDecoder.findNonWhitespace(byArray, n3, n2);
        if (n4 == n2) {
            this.value = "";
            return;
        }
        n = HttpObjectDecoder.findEndOfString(byArray, n, n2);
        this.value = HttpObjectDecoder.langAsciiString(byArray, n4, n - n4);
    }

    protected AsciiString splitHeaderName(byte[] byArray, int n, int n2) {
        return new AsciiString(byArray, n, n2, true);
    }

    private static int findNonSPLenient(byte[] byArray, int n, int n2) {
        while (n < n2) {
            byte by = byArray[n];
            if (!HttpObjectDecoder.isSPLenient(by)) {
                if (HttpObjectDecoder.isWhitespace(by)) {
                    throw new IllegalArgumentException("Invalid separator");
                }
                return n;
            }
            ++n;
        }
        return n2;
    }

    private static int findSPLenient(byte[] byArray, int n, int n2) {
        while (n < n2) {
            if (HttpObjectDecoder.isSPLenient(byArray[n])) {
                return n;
            }
            ++n;
        }
        return n2;
    }

    private static boolean isSPLenient(byte by) {
        return SP_LENIENT_BYTES[by + 128];
    }

    private static boolean isWhitespace(byte by) {
        return LATIN_WHITESPACE[by + 128];
    }

    private static int findNonWhitespace(byte[] byArray, int n, int n2) {
        while (n < n2) {
            byte by = byArray[n];
            if (!HttpObjectDecoder.isWhitespace(by)) {
                return n;
            }
            if (!HttpObjectDecoder.isOWS(by)) {
                throw new IllegalArgumentException("Invalid separator, only a single space or horizontal tab allowed, but received a '" + by + "' (0x" + Integer.toHexString(by) + ")");
            }
            ++n;
        }
        return n2;
    }

    private static int findEndOfString(byte[] byArray, int n, int n2) {
        --n2;
        while (n2 > n) {
            if (!HttpObjectDecoder.isOWS(byArray[n2])) {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    private static boolean isOWS(byte by) {
        return by == 32 || by == 9;
    }

    private static boolean isControlOrWhitespaceAsciiChar(byte by) {
        return ISO_CONTROL_OR_WHITESPACE[by + 128];
    }

    static {
        byte by;
        boolean[] blArray = new boolean[256];
        SP_LENIENT_BYTES = blArray;
        blArray[160] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[137] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[139] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[140] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[141] = true;
        LATIN_WHITESPACE = new boolean[256];
        for (by = -128; by < 127; by = (byte)((byte)(by + 1))) {
            HttpObjectDecoder.LATIN_WHITESPACE[by + 128] = Character.isWhitespace(by);
        }
        ISO_CONTROL_OR_WHITESPACE = new boolean[256];
        for (by = -128; by < 127; by = (byte)(by + 1)) {
            HttpObjectDecoder.ISO_CONTROL_OR_WHITESPACE[by + 128] = Character.isISOControl(by) || HttpObjectDecoder.isWhitespace(by);
        }
        SKIP_CONTROL_CHARS_BYTES = new ByteProcessor(){

            public final boolean process(byte by) {
                return ISO_CONTROL_OR_WHITESPACE[by + 128];
            }
        };
    }

    private final class LineParser
    extends HeaderParser {
        LineParser(ByteBuf byteBuf, int n) {
            super(byteBuf, n);
        }

        @Override
        public final ByteBuf parse(ByteBuf byteBuf) {
            this.reset();
            int n = byteBuf.readableBytes();
            if (n == 0) {
                return null;
            }
            int n2 = byteBuf.readerIndex();
            if (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS && this.skipControlChars(byteBuf, n, n2)) {
                return null;
            }
            return super.parse(byteBuf);
        }

        private boolean skipControlChars(ByteBuf byteBuf, int n, int n2) {
            assert (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS);
            int n3 = Math.min(this.maxLength, n);
            if ((n2 = byteBuf.forEachByte(n2, n3, SKIP_CONTROL_CHARS_BYTES)) == -1) {
                byteBuf.skipBytes(n3);
                if (n > this.maxLength) {
                    LineParser lineParser = this;
                    throw lineParser.newException(lineParser.maxLength);
                }
                return true;
            }
            byteBuf.readerIndex(n2);
            HttpObjectDecoder.this.currentState = State.READ_INITIAL;
            return false;
        }

        @Override
        protected final TooLongFrameException newException(int n) {
            return new TooLongHttpLineException("An HTTP line is larger than " + n + " bytes.");
        }
    }

    private static class HeaderParser {
        protected final ByteBuf seq;
        protected final int maxLength;
        int size;

        HeaderParser(ByteBuf byteBuf, int n) {
            this.seq = byteBuf;
            this.maxLength = n;
        }

        public ByteBuf parse(ByteBuf byteBuf) {
            int n = byteBuf.readableBytes();
            int n2 = byteBuf.readerIndex();
            int n3 = this.maxLength - this.size;
            assert (n3 >= 0);
            long l = (long)n3 + 2L;
            int n4 = (int)Math.min(l, (long)n);
            n4 = n2 + n4;
            assert (n4 >= n2);
            if ((n4 = byteBuf.indexOf(n2, n4, (byte)10)) == -1) {
                if (n > n3) {
                    HeaderParser headerParser = this;
                    throw headerParser.newException(headerParser.maxLength);
                }
                return null;
            }
            n = n4 > n2 && byteBuf.getByte(n4 - 1) == 13 ? n4 - 1 : n4;
            if ((n -= n2) == 0) {
                this.seq.clear();
                byteBuf.readerIndex(n4 + 1);
                return this.seq;
            }
            n3 = this.size + n;
            if (n3 > this.maxLength) {
                HeaderParser headerParser = this;
                throw headerParser.newException(headerParser.maxLength);
            }
            this.size = n3;
            this.seq.clear();
            this.seq.writeBytes(byteBuf, n2, n);
            byteBuf.readerIndex(n4 + 1);
            return this.seq;
        }

        public void reset() {
            this.size = 0;
        }

        protected TooLongFrameException newException(int n) {
            return new TooLongHttpHeaderException("HTTP header is larger than " + n + " bytes.");
        }
    }

    private static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE,
        UPGRADED;

    }
}

