/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.http.cookie.CookieUtil;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.CharBuffer;

public abstract class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final boolean strict;

    protected CookieDecoder(boolean bl) {
        this.strict = bl;
    }

    protected DefaultCookie initCookie(String object, int n, int n2, int n3, int n4) {
        if (n == -1 || n == n2) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (n3 == -1) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap((CharSequence)object, n3, n4);
        CharSequence charSequence = CookieUtil.unwrapValue(charBuffer);
        if (charSequence == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)charBuffer);
            return null;
        }
        object = ((String)object).substring(n, n2);
        if (this.strict && (n = CookieUtil.firstInvalidCookieNameOctet((CharSequence)object)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                String string = object;
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)string, (Object)Character.valueOf(string.charAt(n)));
            }
            return null;
        }
        int n5 = n2 = charSequence.length() != n4 - n3 ? 1 : 0;
        if (this.strict && (n = CookieUtil.firstInvalidCookieValueOctet(charSequence)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                CharSequence charSequence2 = charSequence;
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)charSequence2, (Object)Character.valueOf(charSequence2.charAt(n)));
            }
            return null;
        }
        object = new DefaultCookie((String)object, charSequence.toString());
        ((DefaultCookie)object).setWrap(n2 != 0);
        return object;
    }
}

