/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;

public final class WebSocketChunkedInput
implements ChunkedInput<WebSocketFrame> {
    private final ChunkedInput<ByteBuf> input;
    private final int rsv;

    public WebSocketChunkedInput(ChunkedInput<ByteBuf> chunkedInput) {
        this(chunkedInput, 0);
    }

    public WebSocketChunkedInput(ChunkedInput<ByteBuf> chunkedInput, int n) {
        this.input = (ChunkedInput)ObjectUtil.checkNotNull(chunkedInput, (String)"input");
        this.rsv = n;
    }

    public final boolean isEndOfInput() {
        return this.input.isEndOfInput();
    }

    public final void close() {
        this.input.close();
    }

    @Deprecated
    public final WebSocketFrame readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    public final WebSocketFrame readChunk(ByteBufAllocator byteBufAllocator) {
        if ((byteBufAllocator = (ByteBuf)this.input.readChunk(byteBufAllocator)) == null) {
            return null;
        }
        return new ContinuationWebSocketFrame(this.input.isEndOfInput(), this.rsv, (ByteBuf)byteBufAllocator);
    }

    public final long length() {
        return this.input.length();
    }

    public final long progress() {
        return this.input.progress();
    }
}

