/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class WebSocketClientHandshaker {
    private static final String HTTP_SCHEME_PREFIX = HttpScheme.HTTP + "://";
    private static final String HTTPS_SCHEME_PREFIX = HttpScheme.HTTPS + "://";
    protected static final int DEFAULT_FORCE_CLOSE_TIMEOUT_MILLIS = 10000;
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private volatile long forceCloseTimeoutMillis = 10000L;
    private volatile int forceCloseInit;
    private static final AtomicIntegerFieldUpdater<WebSocketClientHandshaker> FORCE_CLOSE_INIT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WebSocketClientHandshaker.class, "forceCloseInit");
    private volatile boolean forceCloseComplete;
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean absoluteUpgradeUrl;
    protected final boolean generateOriginHeader;

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n) {
        this(uRI, webSocketVersion, string, httpHeaders, n, 10000L);
    }

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l) {
        this(uRI, webSocketVersion, string, httpHeaders, n, l, false);
    }

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l, boolean bl) {
        this(uRI, webSocketVersion, string, httpHeaders, n, l, bl, true);
    }

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l, boolean bl, boolean bl2) {
        this.uri = uRI;
        this.version = webSocketVersion;
        this.expectedSubprotocol = string;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n;
        this.forceCloseTimeoutMillis = l;
        this.absoluteUpgradeUrl = bl;
        this.generateOriginHeader = bl2;
    }

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String actualSubprotocol() {
        return this.actualSubprotocol;
    }

    private void setActualSubprotocol(String string) {
        this.actualSubprotocol = string;
    }

    public long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    protected boolean isForceCloseComplete() {
        return this.forceCloseComplete;
    }

    public WebSocketClientHandshaker setForceCloseTimeoutMillis(long l) {
        this.forceCloseTimeoutMillis = l;
        return this;
    }

    public ChannelFuture handshake(Channel channel) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        Channel channel2 = channel;
        return this.handshake(channel2, channel2.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, final ChannelPromise channelPromise) {
        Object object = channel.pipeline();
        HttpResponseDecoder httpResponseDecoder = (HttpResponseDecoder)object.get(HttpResponseDecoder.class);
        if (httpResponseDecoder == null && (object = (HttpClientCodec)object.get(HttpClientCodec.class)) == null) {
            channelPromise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            return channelPromise;
        }
        if (this.uri.getHost() == null) {
            if (this.customHeaders == null || !this.customHeaders.contains((CharSequence)HttpHeaderNames.HOST)) {
                channelPromise.setFailure((Throwable)new IllegalArgumentException("Cannot generate the 'host' header value, webSocketURI should contain host or passed through customHeaders"));
                return channelPromise;
            }
            if (this.generateOriginHeader && !this.customHeaders.contains((CharSequence)HttpHeaderNames.ORIGIN)) {
                object = this.version == WebSocketVersion.V07 || this.version == WebSocketVersion.V08 ? HttpHeaderNames.SEC_WEBSOCKET_ORIGIN.toString() : HttpHeaderNames.ORIGIN.toString();
                channelPromise.setFailure((Throwable)new IllegalArgumentException("Cannot generate the '" + (String)object + "' header value, webSocketURI should contain host or disable generateOriginHeader or pass value through customHeaders"));
                return channelPromise;
            }
        }
        object = this.newHandshakeRequest();
        channel.writeAndFlush(object).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    ChannelHandlerContext channelHandlerContext = (channelFuture = channelFuture.channel().pipeline()).context(HttpRequestEncoder.class);
                    if (channelHandlerContext == null) {
                        channelHandlerContext = channelFuture.context(HttpClientCodec.class);
                    }
                    if (channelHandlerContext == null) {
                        channelPromise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec"));
                        return;
                    }
                    channelFuture.addAfter(channelHandlerContext.name(), "ws-encoder", (ChannelHandler)WebSocketClientHandshaker.this.newWebSocketEncoder());
                    channelPromise.setSuccess();
                    return;
                }
                channelPromise.setFailure(channelFuture.cause());
            }
        });
        return channelPromise;
    }

    protected abstract FullHttpRequest newHandshakeRequest();

    public final void finishHandshake(Channel channel, FullHttpResponse object) {
        HttpObjectAggregator httpObjectAggregator;
        String string3;
        this.verify((FullHttpResponse)object);
        String string2 = object.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        string2 = string2 != null ? string2.trim() : null;
        String[] stringArray = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean bl = false;
        if (stringArray.isEmpty() && string2 == null) {
            bl = true;
            WebSocketClientHandshaker webSocketClientHandshaker = this;
            webSocketClientHandshaker.setActualSubprotocol(webSocketClientHandshaker.expectedSubprotocol);
        } else if (!stringArray.isEmpty() && string2 != null && !string2.isEmpty()) {
            for (String string3 : stringArray.split(",")) {
                if (!string3.trim().equals(string2)) continue;
                bl = true;
                this.setActualSubprotocol(string2);
                break;
            }
        }
        if (!bl) {
            throw new WebSocketClientHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", string2, this.expectedSubprotocol), (HttpResponse)object);
        }
        this.setHandshakeComplete();
        stringArray = channel.pipeline();
        HttpContentDecompressor httpContentDecompressor = (HttpContentDecompressor)stringArray.get(HttpContentDecompressor.class);
        if (httpContentDecompressor != null) {
            stringArray.remove((ChannelHandler)httpContentDecompressor);
        }
        if ((httpObjectAggregator = (HttpObjectAggregator)stringArray.get(HttpObjectAggregator.class)) != null) {
            stringArray.remove((ChannelHandler)httpObjectAggregator);
        }
        if ((string3 = stringArray.context(HttpResponseDecoder.class)) == null) {
            string3 = stringArray.context(HttpClientCodec.class);
            if (string3 == null) {
                throw new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec");
            }
            object = (HttpClientCodec)string3.handler();
            object.removeOutboundHandler();
            stringArray.addAfter(string3.name(), "ws-decoder", (ChannelHandler)this.newWebsocketDecoder());
            channel.eventLoop().execute(new Runnable((ChannelPipeline)stringArray, (HttpClientCodec)object){
                final /* synthetic */ ChannelPipeline val$p;
                final /* synthetic */ HttpClientCodec val$codec;
                {
                    this.val$p = channelPipeline;
                    this.val$codec = httpClientCodec;
                }

                @Override
                public void run() {
                    this.val$p.remove((ChannelHandler)this.val$codec);
                }
            });
            return;
        }
        if (stringArray.get(HttpRequestEncoder.class) != null) {
            stringArray.remove(HttpRequestEncoder.class);
        }
        object = string3;
        stringArray.addAfter(object.name(), "ws-decoder", (ChannelHandler)this.newWebsocketDecoder());
        channel.eventLoop().execute(new Runnable((ChannelPipeline)stringArray, (ChannelHandlerContext)object){
            final /* synthetic */ ChannelPipeline val$p;
            final /* synthetic */ ChannelHandlerContext val$context;
            {
                this.val$p = channelPipeline;
                this.val$context = channelHandlerContext;
            }

            @Override
            public void run() {
                this.val$p.remove(this.val$context.handler());
            }
        });
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse) {
        return this.processHandshake(channel, httpResponse, channel.newPromise());
    }

    public final ChannelFuture processHandshake(final Channel channel, HttpResponse httpResponse, final ChannelPromise channelPromise) {
        if (httpResponse instanceof FullHttpResponse) {
            try {
                this.finishHandshake(channel, (FullHttpResponse)httpResponse);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            ChannelPipeline channelPipeline = channel.pipeline();
            ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpResponseDecoder.class);
            if (channelHandlerContext == null && (channelHandlerContext = channelPipeline.context(HttpClientCodec.class)) == null) {
                return channelPromise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            }
            String string = channelHandlerContext.name();
            if (this.version == WebSocketVersion.V00) {
                string = "httpAggregator";
                channelPipeline.addAfter(channelHandlerContext.name(), string, (ChannelHandler)new HttpObjectAggregator(8192));
            }
            channelPipeline.addAfter(string, "handshaker", (ChannelHandler)new ChannelInboundHandlerAdapter(){
                private FullHttpResponse fullHttpResponse;

                public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
                    if (object instanceof HttpObject) {
                        try {
                            this.handleHandshakeResponse(channelHandlerContext, (HttpObject)object);
                        }
                        finally {
                            ReferenceCountUtil.release((Object)object);
                        }
                    } else {
                        super.channelRead(channelHandlerContext, object);
                    }
                }

                public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
                    channelHandlerContext.pipeline().remove((ChannelHandler)this);
                    channelPromise.setFailure(throwable);
                }

                public void channelInactive(ChannelHandlerContext channelHandlerContext) {
                    try {
                        if (!channelPromise.isDone()) {
                            channelPromise.tryFailure((Throwable)new ClosedChannelException());
                        }
                        channelHandlerContext.fireChannelInactive();
                        return;
                    }
                    finally {
                        this.releaseFullHttpResponse();
                    }
                }

                public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
                    this.releaseFullHttpResponse();
                }

                private void handleHandshakeResponse(ChannelHandlerContext channelHandlerContext, HttpObject httpObject) {
                    if (httpObject instanceof FullHttpResponse) {
                        channelHandlerContext.pipeline().remove((ChannelHandler)this);
                        this.tryFinishHandshake((FullHttpResponse)httpObject);
                        return;
                    }
                    if (httpObject instanceof LastHttpContent) {
                        assert (this.fullHttpResponse != null);
                        httpObject = this.fullHttpResponse;
                        this.fullHttpResponse = null;
                        try {
                            channelHandlerContext.pipeline().remove((ChannelHandler)this);
                            this.tryFinishHandshake((FullHttpResponse)httpObject);
                            return;
                        }
                        finally {
                            httpObject.release();
                        }
                    }
                    if (httpObject instanceof HttpResponse) {
                        httpObject = (HttpResponse)httpObject;
                        this.fullHttpResponse = new DefaultFullHttpResponse(httpObject.protocolVersion(), httpObject.status(), Unpooled.EMPTY_BUFFER, httpObject.headers(), EmptyHttpHeaders.INSTANCE);
                        if (httpObject.decoderResult().isFailure()) {
                            this.fullHttpResponse.setDecoderResult(httpObject.decoderResult());
                        }
                    }
                }

                private void tryFinishHandshake(FullHttpResponse fullHttpResponse) {
                    try {
                        WebSocketClientHandshaker.this.finishHandshake(channel, fullHttpResponse);
                        channelPromise.setSuccess();
                        return;
                    }
                    catch (Throwable throwable) {
                        channelPromise.setFailure(throwable);
                        return;
                    }
                }

                private void releaseFullHttpResponse() {
                    if (this.fullHttpResponse != null) {
                        this.fullHttpResponse.release();
                        this.fullHttpResponse = null;
                    }
                }
            });
            try {
                channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain((Object)httpResponse));
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        }
        return channelPromise;
    }

    protected abstract void verify(FullHttpResponse var1);

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        Channel channel2 = channel;
        return this.close0((ChannelOutboundInvoker)channel2, channel2, closeWebSocketFrame, channelPromise);
    }

    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull((Object)channelHandlerContext, (String)"ctx");
        return this.close(channelHandlerContext, closeWebSocketFrame, channelHandlerContext.newPromise());
    }

    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)channelHandlerContext, (String)"ctx");
        ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
        return this.close0((ChannelOutboundInvoker)channelHandlerContext2, channelHandlerContext2.channel(), closeWebSocketFrame, channelPromise);
    }

    private ChannelFuture close0(ChannelOutboundInvoker channelOutboundInvoker, final Channel channel, CloseWebSocketFrame object, ChannelPromise channelPromise) {
        channelOutboundInvoker.writeAndFlush(object, channelPromise);
        long l = this.forceCloseTimeoutMillis;
        object = this;
        if (l <= 0L || !channel.isActive() || this.forceCloseInit != 0) {
            return channelPromise;
        }
        channelPromise.addListener((GenericFutureListener)new ChannelFutureListener((WebSocketClientHandshaker)object, channelOutboundInvoker, l){
            final /* synthetic */ WebSocketClientHandshaker val$handshaker;
            final /* synthetic */ ChannelOutboundInvoker val$invoker;
            final /* synthetic */ long val$forceCloseTimeoutMillis;
            {
                this.val$handshaker = webSocketClientHandshaker2;
                this.val$invoker = channelOutboundInvoker;
                this.val$forceCloseTimeoutMillis = l;
            }

            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess() && channel.isActive() && FORCE_CLOSE_INIT_UPDATER.compareAndSet(this.val$handshaker, 0, 1)) {
                    channelFuture = channel.eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (channel.isActive()) {
                                val$invoker.close();
                                WebSocketClientHandshaker.this.forceCloseComplete = true;
                            }
                        }
                    }, this.val$forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
                    channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener((Future)channelFuture){
                        final /* synthetic */ Future val$forceCloseFuture;
                        {
                            this.val$forceCloseFuture = future;
                        }

                        public void operationComplete(ChannelFuture channelFuture) {
                            this.val$forceCloseFuture.cancel(false);
                        }
                    });
                }
            }
        });
        return channelPromise;
    }

    protected String upgradeUrl(URI object) {
        if (this.absoluteUpgradeUrl) {
            return ((URI)object).toString();
        }
        String string = ((URI)object).getRawPath();
        string = string == null || string.isEmpty() ? "/" : string;
        if ((object = ((URI)object).getRawQuery()) != null && !((String)object).isEmpty()) {
            return string + '?' + (String)object;
        }
        return string;
    }

    static CharSequence websocketHostValue(URI object) {
        int n = ((URI)object).getPort();
        if (n == -1) {
            return ((URI)object).getHost();
        }
        String string = ((URI)object).getHost();
        object = ((URI)object).getScheme();
        if (n == HttpScheme.HTTP.port()) {
            if (HttpScheme.HTTP.name().contentEquals((CharSequence)object) || WebSocketScheme.WS.name().contentEquals((CharSequence)object)) {
                return string;
            }
            return NetUtil.toSocketAddressString((String)string, (int)n);
        }
        if (n == HttpScheme.HTTPS.port()) {
            if (HttpScheme.HTTPS.name().contentEquals((CharSequence)object) || WebSocketScheme.WSS.name().contentEquals((CharSequence)object)) {
                return string;
            }
            return NetUtil.toSocketAddressString((String)string, (int)n);
        }
        return NetUtil.toSocketAddressString((String)string, (int)n);
    }

    static CharSequence websocketOriginValue(URI object) {
        int n;
        String string = ((URI)object).getScheme();
        int n2 = ((URI)object).getPort();
        if (WebSocketScheme.WSS.name().contentEquals((CharSequence)string) || HttpScheme.HTTPS.name().contentEquals((CharSequence)string) || string == null && n2 == WebSocketScheme.WSS.port()) {
            string = HTTPS_SCHEME_PREFIX;
            n = WebSocketScheme.WSS.port();
        } else {
            string = HTTP_SCHEME_PREFIX;
            n = WebSocketScheme.WS.port();
        }
        object = ((URI)object).getHost().toLowerCase(Locale.US);
        if (n2 != n && n2 != -1) {
            return string + NetUtil.toSocketAddressString((String)object, (int)n2);
        }
        return string + (String)object;
    }
}

