/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;

public class WebSocketClientHandshaker08
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker08.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n) {
        this(uRI, webSocketVersion, string, bl, httpHeaders, n, true, false, 10000L);
    }

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3) {
        this(uRI, webSocketVersion, string, bl, httpHeaders, n, bl2, bl3, 10000L);
    }

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, long l) {
        this(uRI, webSocketVersion, string, bl, httpHeaders, n, bl2, bl3, l, false, true);
    }

    WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, long l, boolean bl4) {
        this(uRI, webSocketVersion, string, bl, httpHeaders, n, bl2, bl3, l, bl4, true);
    }

    WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, long l, boolean bl4, boolean bl5) {
        super(uRI, webSocketVersion, string, httpHeaders, n, l, bl4, bl5);
        this.allowExtensions = bl;
        this.performMasking = bl2;
        this.allowMaskMismatch = bl3;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        Object object = this.uri();
        Object object2 = WebSocketUtil.randomBytes(16);
        object2 = WebSocketUtil.base64(object2);
        Object object3 = (String)object2 + MAGIC_GUID;
        object3 = WebSocketUtil.sha1(((String)object3).getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64((byte[])object3);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 08 client handshake key: {}, expected response: {}", object2, (Object)this.expectedChallengeResponseString);
        }
        object3 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl((URI)object), Unpooled.EMPTY_BUFFER);
        HttpHeaders httpHeaders = object3.headers();
        if (this.customHeaders != null) {
            httpHeaders.add(this.customHeaders);
            if (!httpHeaders.contains((CharSequence)HttpHeaderNames.HOST)) {
                httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker08.websocketHostValue((URI)object));
            }
        } else {
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker08.websocketHostValue((URI)object));
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, object2);
        if (this.generateOriginHeader && !httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN)) {
            httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)WebSocketClientHandshaker08.websocketOriginValue((URI)object));
        }
        if ((object = this.expectedSubprotocol()) != null && !((String)object).isEmpty()) {
            httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, object);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)this.version().toAsciiString());
        return object3;
    }

    @Override
    protected void verify(FullHttpResponse fullHttpResponse) {
        Object object = fullHttpResponse.status();
        if (!HttpResponseStatus.SWITCHING_PROTOCOLS.equals(object)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response getStatus: " + object, fullHttpResponse);
        }
        object = fullHttpResponse.headers();
        String string = ((HttpHeaders)object).get((CharSequence)HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase((CharSequence)string)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response upgrade: " + string, fullHttpResponse);
        }
        if (!((HttpHeaders)object).containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response connection: " + ((HttpHeaders)object).get((CharSequence)HttpHeaderNames.CONNECTION), fullHttpResponse);
        }
        if ((object = ((HttpHeaders)object).get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT)) == null || !object.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketClientHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", object, this.expectedChallengeResponseString), fullHttpResponse);
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket08FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength(), this.allowMaskMismatch);
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket08FrameEncoder(this.performMasking);
    }

    @Override
    public WebSocketClientHandshaker08 setForceCloseTimeoutMillis(long l) {
        super.setForceCloseTimeoutMillis(l);
        return this;
    }
}

