/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion spdyVersion) {
        this.version = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)((Object)spdyVersion), (String)"version"))).version();
    }

    private static void setLengthField(ByteBuf byteBuf, int n, int n2) {
        byteBuf.setInt(n, n2);
    }

    private static void writeLengthField(ByteBuf byteBuf, int n) {
        byteBuf.writeInt(n);
    }

    @Override
    public ByteBuf encode(ByteBufAllocator byteBufAllocator, SpdyHeadersFrame spdyHeadersFrame) {
        Object object = spdyHeadersFrame.headers().names();
        int n = object.size();
        if (n == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (n > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        byteBufAllocator = byteBufAllocator.heapBuffer();
        SpdyHeaderBlockRawEncoder.writeLengthField((ByteBuf)byteBufAllocator, n);
        object = object.iterator();
        while (object.hasNext()) {
            CharSequence charSequence = (CharSequence)object.next();
            SpdyHeaderBlockRawEncoder.writeLengthField((ByteBuf)byteBufAllocator, charSequence.length());
            ByteBufUtil.writeAscii((ByteBuf)byteBufAllocator, (CharSequence)charSequence);
            int n2 = byteBufAllocator.writerIndex();
            int n3 = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField((ByteBuf)byteBufAllocator, 0);
            for (CharSequence charSequence2 : spdyHeadersFrame.headers().getAll(charSequence)) {
                int n4 = charSequence2.length();
                if (n4 <= 0) continue;
                ByteBufUtil.writeAscii((ByteBuf)byteBufAllocator, (CharSequence)charSequence2);
                byteBufAllocator.writeByte(0);
                n3 += n4 + 1;
            }
            if (n3 != 0) {
                --n3;
            }
            if (n3 > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + charSequence);
            }
            if (n3 <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField((ByteBuf)byteBufAllocator, n2, n3);
            ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
            byteBufAllocator2.writerIndex(byteBufAllocator2.writerIndex() - 1);
        }
        return byteBufAllocator;
    }

    @Override
    void end() {
    }
}

