/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.zip.Deflater;

class SpdyHeaderBlockZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater compressor;
    private boolean finished;

    SpdyHeaderBlockZlibEncoder(SpdyVersion spdyVersion, int n) {
        super(spdyVersion);
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n + " (expected: 0-9)");
        }
        this.compressor = new Deflater(n);
        this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
    }

    private int setInput(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            this.compressor.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n);
        } else {
            byte[] byArray = new byte[n];
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.getBytes(byteBuf2.readerIndex(), byArray);
            this.compressor.setInput(byArray, 0, byArray.length);
        }
        return n;
    }

    private ByteBuf encode(ByteBufAllocator byteBufAllocator, int n) {
        byteBufAllocator = byteBufAllocator.heapBuffer(n);
        n = 1;
        try {
            while (this.compressInto((ByteBuf)byteBufAllocator)) {
                ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
                byteBufAllocator2.ensureWritable(byteBufAllocator2.capacity() << 1);
            }
            n = 0;
            ByteBufAllocator byteBufAllocator3 = byteBufAllocator;
            return byteBufAllocator3;
        }
        catch (Throwable throwable) {
            if (n != 0) {
                byteBufAllocator.release();
            }
            throw throwable;
        }
    }

    private boolean compressInto(ByteBuf byteBuf) {
        byte[] byArray = byteBuf.array();
        int n = byteBuf.arrayOffset() + byteBuf.writerIndex();
        int n2 = byteBuf.writableBytes();
        int n3 = PlatformDependent.javaVersion() >= 7 ? this.compressor.deflate(byArray, n, n2, 2) : this.compressor.deflate(byArray, n, n2);
        ByteBuf byteBuf2 = byteBuf;
        byteBuf2.writerIndex(byteBuf2.writerIndex() + n3);
        return n3 == n2;
    }

    @Override
    public ByteBuf encode(ByteBufAllocator byteBufAllocator, SpdyHeadersFrame spdyHeadersFrame) {
        ObjectUtil.checkNotNullWithIAE((Object)byteBufAllocator, (String)"alloc");
        ObjectUtil.checkNotNullWithIAE((Object)spdyHeadersFrame, (String)"frame");
        if (this.finished) {
            return Unpooled.EMPTY_BUFFER;
        }
        spdyHeadersFrame = super.encode(byteBufAllocator, spdyHeadersFrame);
        try {
            if (!spdyHeadersFrame.isReadable()) {
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            int n = this.setInput((ByteBuf)spdyHeadersFrame);
            byteBufAllocator = this.encode(byteBufAllocator, n);
            return byteBufAllocator;
        }
        finally {
            spdyHeadersFrame.release();
        }
    }

    @Override
    public void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.compressor.end();
        super.end();
    }
}

