/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMenuItemRenderer;
import com.formdev.flatlaf.ui.FlatMenuItemUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

@FlatStylingSupport.StyleableFields(value={@FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="selectionBackground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="selectionForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="disabledForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="acceleratorForeground"), @FlatStylingSupport.StyleableField(cls=BasicMenuItemUI.class, key="acceleratorSelectionForeground")})
public class FlatCheckBoxMenuItemUI
extends BasicCheckBoxMenuItemUI
implements FlatStylingSupport.StyleableLookupProvider,
FlatStylingSupport.StyleableUI {
    private FlatMenuItemRenderer renderer;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatCheckBoxMenuItemUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", FlatUIUtils.getUIInt("MenuItem.iconTextGap", 4));
        this.renderer = this.createRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        FlatMenuItemRenderer.clearClientProperties(this.menuItem.getParent());
        this.renderer = null;
        this.oldStyleValues = null;
    }

    protected FlatMenuItemRenderer createRenderer() {
        return new FlatMenuItemRenderer(this.menuItem, this.checkIcon, this.arrowIcon, this.acceleratorFont, this.acceleratorDelimiter);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return FlatStylingSupport.createPropertyChangeListener(jComponent, this::installStyle, super.createPropertyChangeListener(jComponent));
    }

    protected void installStyle() {
        try {
            FlatCheckBoxMenuItemUI flatCheckBoxMenuItemUI = this;
            flatCheckBoxMenuItemUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatCheckBoxMenuItemUI.menuItem, "CheckBoxMenuItem"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        FlatCheckBoxMenuItemUI flatCheckBoxMenuItemUI = this;
        return FlatMenuItemUI.applyStyleProperty(this.menuItem, flatCheckBoxMenuItemUI, flatCheckBoxMenuItemUI.renderer, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        FlatCheckBoxMenuItemUI flatCheckBoxMenuItemUI = this;
        return FlatMenuItemUI.getStyleableInfos(flatCheckBoxMenuItemUI, flatCheckBoxMenuItemUI.renderer);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        FlatCheckBoxMenuItemUI flatCheckBoxMenuItemUI = this;
        return FlatMenuItemUI.getStyleableValue(flatCheckBoxMenuItemUI, flatCheckBoxMenuItemUI.renderer, string);
    }

    @Override
    public MethodHandles.Lookup getLookupForStyling() {
        return MethodHandles.lookup();
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        return this.renderer.getPreferredMenuItemSize();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.renderer.paintMenuItem(graphics, this.selectionBackground, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
    }
}

