/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonBorder;
import com.formdev.flatlaf.ui.FlatScrollPaneBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class FlatScrollPaneUI
extends BasicScrollPaneUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Boolean showButtons;
    private Handler handler;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatScrollPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
            return;
        }
        this.installUIImpl(jComponent);
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        int n = UIManager.getInt("Component.focusWidth");
        int n2 = UIManager.getInt("ScrollPane.arc");
        LookAndFeel.installProperty(jComponent, "opaque", n == 0 && n2 == 0);
        LayoutManager layoutManager = jComponent.getLayout();
        if (layoutManager != null && layoutManager.getClass() == ScrollPaneLayout.UIResource.class) {
            jComponent.setLayout(this.createScrollPaneLayout());
        }
        this.installStyle();
        MigLayoutVisualPadding.install(this.scrollpane);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        MigLayoutVisualPadding.uninstall(this.scrollpane);
        if (jComponent.getLayout() instanceof FlatScrollPaneLayout) {
            jComponent.setLayout(new ScrollPaneLayout.UIResource());
        }
        super.uninstallUI(jComponent);
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    protected void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        FlatScrollPaneUI flatScrollPaneUI = this;
        flatScrollPaneUI.addViewportListeners(flatScrollPaneUI.scrollpane.getViewport());
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        FlatScrollPaneUI flatScrollPaneUI = this;
        flatScrollPaneUI.removeViewportListeners(flatScrollPaneUI.scrollpane.getViewport());
        this.handler = null;
    }

    protected FlatScrollPaneLayout createScrollPaneLayout() {
        return new FlatScrollPaneLayout();
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        MouseWheelListener mouseWheelListener = super.createMouseWheelListener();
        return mouseWheelEvent -> {
            if (this.isSmoothScrollingEnabled() && this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollType() == 0 && mouseWheelEvent.getPreciseWheelRotation() != 0.0 && mouseWheelEvent.getPreciseWheelRotation() != (double)mouseWheelEvent.getWheelRotation()) {
                this.mouseWheelMovedSmooth(mouseWheelEvent);
                return;
            }
            mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
        };
    }

    protected boolean isSmoothScrollingEnabled() {
        Object object = this.scrollpane.getClientProperty("JScrollPane.smoothScrolling");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return UIManager.getBoolean("ScrollPane.smoothScrolling");
    }

    private void mouseWheelMovedSmooth(MouseWheelEvent mouseWheelEvent) {
        int n;
        int n2;
        JViewport jViewport = this.scrollpane.getViewport();
        if (jViewport == null) {
            return;
        }
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        if (!(jScrollBar != null && jScrollBar.isVisible() && !mouseWheelEvent.isShiftDown() || (jScrollBar = this.scrollpane.getHorizontalScrollBar()) != null && jScrollBar.isVisible())) {
            return;
        }
        mouseWheelEvent.consume();
        double d = mouseWheelEvent.getPreciseWheelRotation();
        int n3 = jScrollBar.getOrientation();
        Component component = jViewport.getView();
        if (component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            Rectangle rectangle = new Rectangle(jViewport.getViewSize());
            n2 = scrollable.getScrollableUnitIncrement(rectangle, n3, 1);
            if (n2 > 0) {
                if (n3 == 1) {
                    rectangle.y += n2;
                    rectangle.height -= n2;
                } else {
                    rectangle.x += n2;
                    rectangle.width -= n2;
                }
                int n4 = scrollable.getScrollableUnitIncrement(rectangle, n3, 1);
                if (n4 > 0) {
                    n2 = Math.min(n2, n4);
                }
            }
        } else {
            int n5 = d < 0.0 ? -1 : 1;
            n2 = jScrollBar.getUnitIncrement(n5);
        }
        int n6 = n3 == 1 ? jViewport.getHeight() : jViewport.getWidth();
        int n7 = Math.min(n2 * mouseWheelEvent.getScrollAmount(), n6);
        double d2 = d * (double)n7;
        int n8 = (int)Math.round(d2);
        if (n8 == 0) {
            if (d > 0.0) {
                n8 = 1;
            } else if (d < 0.0) {
                n8 = -1;
            }
        }
        int n9 = jScrollBar.getValue();
        int n10 = jScrollBar.getMinimum();
        n8 = Math.max(n10, Math.min(n9 + n8, n = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent()));
        if (n8 != n9) {
            jScrollBar.setValue(n8);
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return serializable -> {
            propertyChangeListener.propertyChange(serializable);
            switch (((PropertyChangeEvent)serializable).getPropertyName()) {
                case "JScrollBar.showButtons": {
                    propertyChangeListener = this.scrollpane.getVerticalScrollBar();
                    serializable = this.scrollpane.getHorizontalScrollBar();
                    if (propertyChangeListener != null) {
                        ((JComponent)((Object)propertyChangeListener)).revalidate();
                        ((Component)((Object)propertyChangeListener)).repaint();
                    }
                    if (serializable == null) break;
                    ((JComponent)((Object)serializable)).revalidate();
                    ((Component)((Object)serializable)).repaint();
                    return;
                }
                case "LOWER_LEFT_CORNER": 
                case "LOWER_RIGHT_CORNER": 
                case "UPPER_LEFT_CORNER": 
                case "UPPER_RIGHT_CORNER": {
                    propertyChangeListener = ((PropertyChangeEvent)serializable).getNewValue();
                    if (!(propertyChangeListener instanceof JButton) || !(((JButton)((Object)propertyChangeListener)).getBorder() instanceof FlatButtonBorder) || !(FlatScrollPaneUI.getView(this.scrollpane) instanceof JTable)) break;
                    ((JButton)((Object)propertyChangeListener)).setBorder(BorderFactory.createEmptyBorder());
                    ((JButton)((Object)propertyChangeListener)).setFocusable(false);
                    return;
                }
                case "JComponent.outline": {
                    this.scrollpane.repaint();
                    return;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.scrollpane.revalidate();
                    this.scrollpane.repaint();
                    return;
                }
                case "border": {
                    propertyChangeListener = ((PropertyChangeEvent)serializable).getNewValue();
                    if (propertyChangeListener == null || propertyChangeListener != UIManager.getBorder("Table.scrollPaneBorder")) break;
                    this.borderShared = null;
                    this.installStyle();
                    this.scrollpane.revalidate();
                    this.scrollpane.repaint();
                }
            }
        };
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installStyle() {
        try {
            FlatScrollPaneUI flatScrollPaneUI = this;
            flatScrollPaneUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatScrollPaneUI.scrollpane, "ScrollPane"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.equals("focusWidth") || string.equals("arc")) {
            int n = object instanceof Integer ? (Integer)object : UIManager.getInt("Component.focusWidth");
            int n2 = object instanceof Integer ? (Integer)object : UIManager.getInt("ScrollPane.arc");
            LookAndFeel.installProperty(this.scrollpane, "opaque", n == 0 && n2 == 0);
        }
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.scrollpane, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        FlatScrollPaneUI flatScrollPaneUI = this;
        return FlatStylingSupport.getAnnotatedStyleableInfos(flatScrollPaneUI, flatScrollPaneUI.scrollpane.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        FlatScrollPaneUI flatScrollPaneUI = this;
        return FlatStylingSupport.getAnnotatedStyleableValue(flatScrollPaneUI, flatScrollPaneUI.scrollpane.getBorder(), string);
    }

    @Override
    protected void updateViewport(PropertyChangeEvent serializable) {
        super.updateViewport((PropertyChangeEvent)serializable);
        JViewport jViewport = (JViewport)serializable.getOldValue();
        serializable = (JViewport)serializable.getNewValue();
        this.removeViewportListeners(jViewport);
        this.addViewportListeners((JViewport)serializable);
    }

    private void addViewportListeners(JViewport component) {
        if (component == null) {
            return;
        }
        ((Container)component).addContainerListener(this.getHandler());
        component = ((JViewport)component).getView();
        if (component != null) {
            component.addFocusListener(this.getHandler());
        }
    }

    private void removeViewportListeners(JViewport component) {
        if (component == null) {
            return;
        }
        ((Container)component).removeContainerListener(this.getHandler());
        component = ((JViewport)component).getView();
        if (component != null) {
            component.removeFocusListener(this.getHandler());
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        float f;
        Serializable serializable;
        if (jComponent.isOpaque()) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
            serializable = jComponent.getInsets();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(((Insets)serializable).left, ((Insets)serializable).top, jComponent.getWidth() - ((Insets)serializable).left - ((Insets)serializable).right, jComponent.getHeight() - ((Insets)serializable).top - ((Insets)serializable).bottom);
        }
        float f2 = FlatScrollPaneUI.getBorderArc(this.scrollpane);
        if (f > 0.0f && (serializable = FlatScrollPaneUI.getView(this.scrollpane)) != null) {
            float f3 = FlatUIUtils.getBorderFocusWidth(jComponent);
            graphics.setColor(((Component)serializable).getBackground());
            serializable = FlatUIUtils.setRenderingHints(graphics);
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), f3, f2);
            FlatUIUtils.resetRenderingHints(graphics, (Object[])serializable);
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent object) {
        object = this.scrollpane.getViewportBorder();
        if (object != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            int n = FlatScrollPaneUI.getBorderLeftRightPadding(this.scrollpane);
            JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
            if (n > 0 && jScrollBar != null && jScrollBar.isVisible() && this.scrollpane.getLayout() instanceof FlatScrollPaneLayout && ((FlatScrollPaneLayout)this.scrollpane.getLayout()).canIncreaseViewportWidth(this.scrollpane)) {
                boolean bl = this.scrollpane.getComponentOrientation().isLeftToRight();
                n = Math.min(n, jScrollBar.getWidth());
                object.paintBorder(this.scrollpane, graphics, rectangle.x - (bl ? 0 : n), rectangle.y, rectangle.width + n, rectangle.height);
                return;
            }
            object.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static boolean isPermanentFocusOwner(JScrollPane component) {
        Component component2;
        if ((component = FlatScrollPaneUI.getView(component)) == null) {
            return false;
        }
        if (FlatUIUtils.isPermanentFocusOwner(component)) {
            return true;
        }
        if ((component instanceof JTable && ((JTable)component).isEditing() || component instanceof JTree && ((JTree)component).isEditing()) && (component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null) {
            return SwingUtilities.isDescendingFrom(component2, component);
        }
        return false;
    }

    static Component getView(JScrollPane jComponent) {
        if ((jComponent = ((JScrollPane)jComponent).getViewport()) != null) {
            return ((JViewport)jComponent).getView();
        }
        return null;
    }

    private static float getBorderArc(JScrollPane jScrollPane) {
        Border border = jScrollPane.getBorder();
        if (border instanceof FlatScrollPaneBorder) {
            return UIScale.scale((float)((FlatScrollPaneBorder)border).getArc(jScrollPane));
        }
        return 0.0f;
    }

    private static int getBorderLeftRightPadding(JScrollPane jScrollPane) {
        Border border = jScrollPane.getBorder();
        if (border instanceof FlatScrollPaneBorder) {
            return ((FlatScrollPaneBorder)border).getLeftRightPadding(jScrollPane);
        }
        return 0;
    }

    protected static class FlatScrollPaneLayout
    extends ScrollPaneLayout.UIResource {
        protected FlatScrollPaneLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            container = (JScrollPane)container;
            int n = FlatScrollPaneUI.getBorderLeftRightPadding((JScrollPane)container);
            if (n > 0 && this.vsb != null && this.vsb.isVisible()) {
                Insets insets = ((JComponent)container).getInsets();
                Rectangle rectangle = this.vsb.getBounds();
                int n2 = Math.max(rectangle.y, insets.top + n);
                int n3 = Math.min(rectangle.y + rectangle.height, ((JComponent)container).getHeight() - insets.bottom - n);
                boolean bl = container.getComponentOrientation().isLeftToRight();
                this.vsb.setBounds(rectangle.x + (bl ? n : -n), n2, rectangle.width, n3 - n2);
                if (this.canIncreaseViewportWidth((JScrollPane)container)) {
                    int n4 = Math.min(n, this.vsb.getWidth());
                    FlatScrollPaneLayout.resizeViewport(this.viewport, n4, bl);
                    FlatScrollPaneLayout.resizeViewport(this.colHead, n4, bl);
                    FlatScrollPaneLayout.resizeViewport(this.hsb, n4, bl);
                }
            }
        }

        boolean canIncreaseViewportWidth(JScrollPane jScrollPane) {
            if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                return !FlatScrollPaneLayout.isCornerVisible(this.upperRight) && !FlatScrollPaneLayout.isCornerVisible(this.lowerRight);
            }
            return !FlatScrollPaneLayout.isCornerVisible(this.upperLeft) && !FlatScrollPaneLayout.isCornerVisible(this.lowerLeft);
        }

        private static boolean isCornerVisible(Component component) {
            return component != null && component.getWidth() > 0 && component.getHeight() > 0 && component.isVisible();
        }

        private static void resizeViewport(Component component, int n, boolean bl) {
            if (component == null) {
                return;
            }
            Rectangle rectangle = component.getBounds();
            component.setBounds(rectangle.x - (bl ? 0 : n), rectangle.y, rectangle.width + n, rectangle.height);
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener {
        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            containerEvent.getChild().addFocusListener(this);
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            containerEvent.getChild().removeFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (FlatScrollPaneUI.this.scrollpane.getBorder() instanceof FlatBorder) {
                FlatScrollPaneUI.this.scrollpane.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (FlatScrollPaneUI.this.scrollpane.getBorder() instanceof FlatBorder) {
                FlatScrollPaneUI.this.scrollpane.repaint();
            }
        }
    }
}

