/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010 \u001a\u00020\u0005*\u00020\u0005J\n\u0010!\u001a\u00020\u0005*\u00020\u0005J\n\u0010\"\u001a\u00020\u0005*\u00020\u0005J\n\u0010#\u001a\u00020\u0005*\u00020\u0005J\n\u0010$\u001a\u00020\n*\u00020\nJ\n\u0010%\u001a\u00020\n*\u00020\nJ\u0011\u0010&\u001a\u00020'*\u00020'\u00a2\u0006\u0004\b(\u0010)J\n\u0010*\u001a\u00020+*\u00020+J\n\u0010&\u001a\u00020+*\u00020+J\n\u0010*\u001a\u00020,*\u00020,J\u001b\u0010*\u001a\u00020-*\u00020-2\b\b\u0002\u0010.\u001a\u00020/\u00a2\u0006\u0004\b0\u00101J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0005H\u00c6\u0003J\t\u00104\u001a\u00020\u0005H\u00c6\u0003J\t\u00105\u001a\u00020\u0005H\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\nH\u00c6\u0003J\t\u00108\u001a\u00020\nH\u00c6\u0003JO\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010:\u001a\u00020/2\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010<\u001a\u00020\u0005H\u00d6\u0001J\t\u0010=\u001a\u00020>H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006?"}, d2={"Landroidx/compose/ui/text/ParagraphInfo;", "", "paragraph", "Landroidx/compose/ui/text/Paragraph;", "startIndex", "", "endIndex", "startLineIndex", "endLineIndex", "top", "", "bottom", "<init>", "(Landroidx/compose/ui/text/Paragraph;IIIIFF)V", "getParagraph", "()Landroidx/compose/ui/text/Paragraph;", "getStartIndex", "()I", "getEndIndex", "getStartLineIndex", "setStartLineIndex", "(I)V", "getEndLineIndex", "setEndLineIndex", "getTop", "()F", "setTop", "(F)V", "getBottom", "setBottom", "length", "getLength", "toLocalIndex", "toGlobalIndex", "toLocalLineIndex", "toGlobalLineIndex", "toGlobalYPosition", "toLocalYPosition", "toLocal", "Landroidx/compose/ui/geometry/Offset;", "toLocal-MK-Hz9U", "(J)J", "toGlobal", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/ui/graphics/Path;", "Landroidx/compose/ui/text/TextRange;", "treatZeroAsNull", "", "toGlobal-xdX6-G0", "(JZ)J", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "ui-text"})
public final class ParagraphInfo {
    private final Paragraph paragraph;
    private final int startIndex;
    private final int endIndex;
    private int startLineIndex;
    private int endLineIndex;
    private float top;
    private float bottom;
    public static final int $stable = 8;

    public ParagraphInfo(Paragraph paragraph, int n, int n2, int n3, int n4, float f, float f2) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"");
        this.paragraph = paragraph;
        this.startIndex = n;
        this.endIndex = n2;
        this.startLineIndex = n3;
        this.endLineIndex = n4;
        this.top = f;
        this.bottom = f2;
    }

    public /* synthetic */ ParagraphInfo(Paragraph paragraph, int n, int n2, int n3, int n4, float f, float f2, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n3 = -1;
        }
        if ((n5 & 0x10) != 0) {
            n4 = -1;
        }
        if ((n5 & 0x20) != 0) {
            f = -1.0f;
        }
        if ((n5 & 0x40) != 0) {
            f2 = -1.0f;
        }
        this(paragraph, n, n2, n3, n4, f, f2);
    }

    public final Paragraph getParagraph() {
        return this.paragraph;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    public final int getStartLineIndex() {
        return this.startLineIndex;
    }

    public final void setStartLineIndex(int n) {
        this.startLineIndex = n;
    }

    public final int getEndLineIndex() {
        return this.endLineIndex;
    }

    public final void setEndLineIndex(int n) {
        this.endLineIndex = n;
    }

    public final float getTop() {
        return this.top;
    }

    public final void setTop(float f) {
        this.top = f;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final void setBottom(float f) {
        this.bottom = f;
    }

    public final int getLength() {
        return this.endIndex - this.startIndex;
    }

    public final int toLocalIndex(int n) {
        return RangesKt.coerceIn((int)n, (int)this.startIndex, (int)this.endIndex) - this.startIndex;
    }

    public final int toGlobalIndex(int n) {
        return n + this.startIndex;
    }

    public final int toLocalLineIndex(int n) {
        return n - this.startLineIndex;
    }

    public final int toGlobalLineIndex(int n) {
        return n + this.startLineIndex;
    }

    public final float toGlobalYPosition(float f) {
        return f + this.top;
    }

    public final float toLocalYPosition(float f) {
        return f - this.top;
    }

    public final long toLocal-MK-Hz9U(long l) {
        int n = (int)(l >> 32);
        float f = Float.intBitsToFloat(n);
        int n2 = (int)l;
        float f2 = Float.intBitsToFloat(n2) - this.top;
        long l2 = Float.floatToRawIntBits(f);
        long l3 = Float.floatToRawIntBits(f2);
        return Offset.constructor-impl((long)(l2 << 32 | l3 & 0xFFFFFFFFL));
    }

    public final Rect toGlobal(Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        float f = this.top;
        long l = Float.floatToRawIntBits(0.0f);
        long l2 = Float.floatToRawIntBits(f);
        return rect.translate-k-4lQ0M(Offset.constructor-impl((long)(l << 32 | l2 & 0xFFFFFFFFL)));
    }

    public final Rect toLocal(Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        float f = -this.top;
        long l = Float.floatToRawIntBits(0.0f);
        long l2 = Float.floatToRawIntBits(f);
        return rect.translate-k-4lQ0M(Offset.constructor-impl((long)(l << 32 | l2 & 0xFFFFFFFFL)));
    }

    public final Path toGlobal(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        float f = this.top;
        long l = Float.floatToRawIntBits(0.0f);
        long l2 = Float.floatToRawIntBits(f);
        path.translate-k-4lQ0M(Offset.constructor-impl((long)(l << 32 | l2 & 0xFFFFFFFFL)));
        return path;
    }

    public final long toGlobal-xdX6-G0(long l, boolean bl) {
        if (bl && TextRange.equals-impl0(l, TextRange.Companion.getZero-d9O1mEE())) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        return TextRangeKt.TextRange(this.toGlobalIndex(TextRange.getStart-impl(l)), this.toGlobalIndex(TextRange.getEnd-impl(l)));
    }

    public static /* synthetic */ long toGlobal-xdX6-G0$default(ParagraphInfo paragraphInfo, long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return paragraphInfo.toGlobal-xdX6-G0(l, bl);
    }

    public final Paragraph component1() {
        return this.paragraph;
    }

    public final int component2() {
        return this.startIndex;
    }

    public final int component3() {
        return this.endIndex;
    }

    public final int component4() {
        return this.startLineIndex;
    }

    public final int component5() {
        return this.endLineIndex;
    }

    public final float component6() {
        return this.top;
    }

    public final float component7() {
        return this.bottom;
    }

    public final ParagraphInfo copy(Paragraph paragraph, int n, int n2, int n3, int n4, float f, float f2) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"");
        return new ParagraphInfo(paragraph, n, n2, n3, n4, f, f2);
    }

    public static /* synthetic */ ParagraphInfo copy$default(ParagraphInfo paragraphInfo, Paragraph paragraph, int n, int n2, int n3, int n4, float f, float f2, int n5, Object object) {
        if ((n5 & 1) != 0) {
            paragraph = paragraphInfo.paragraph;
        }
        if ((n5 & 2) != 0) {
            n = paragraphInfo.startIndex;
        }
        if ((n5 & 4) != 0) {
            n2 = paragraphInfo.endIndex;
        }
        if ((n5 & 8) != 0) {
            n3 = paragraphInfo.startLineIndex;
        }
        if ((n5 & 0x10) != 0) {
            n4 = paragraphInfo.endLineIndex;
        }
        if ((n5 & 0x20) != 0) {
            f = paragraphInfo.top;
        }
        if ((n5 & 0x40) != 0) {
            f2 = paragraphInfo.bottom;
        }
        return paragraphInfo.copy(paragraph, n, n2, n3, n4, f, f2);
    }

    public final String toString() {
        return "ParagraphInfo(paragraph=" + this.paragraph + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", startLineIndex=" + this.startLineIndex + ", endLineIndex=" + this.endLineIndex + ", top=" + this.top + ", bottom=" + this.bottom + ")";
    }

    public final int hashCode() {
        int n = this.paragraph.hashCode();
        n = n * 31 + Integer.hashCode(this.startIndex);
        n = n * 31 + Integer.hashCode(this.endIndex);
        n = n * 31 + Integer.hashCode(this.startLineIndex);
        n = n * 31 + Integer.hashCode(this.endLineIndex);
        n = n * 31 + Float.hashCode(this.top);
        n = n * 31 + Float.hashCode(this.bottom);
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ParagraphInfo)) {
            return false;
        }
        object = (ParagraphInfo)object;
        if (!Intrinsics.areEqual((Object)this.paragraph, (Object)((ParagraphInfo)object).paragraph)) {
            return false;
        }
        if (this.startIndex != ((ParagraphInfo)object).startIndex) {
            return false;
        }
        if (this.endIndex != ((ParagraphInfo)object).endIndex) {
            return false;
        }
        if (this.startLineIndex != ((ParagraphInfo)object).startLineIndex) {
            return false;
        }
        if (this.endLineIndex != ((ParagraphInfo)object).endLineIndex) {
            return false;
        }
        if (Float.compare(this.top, ((ParagraphInfo)object).top) != 0) {
            return false;
        }
        return Float.compare(this.bottom, ((ParagraphInfo)object).bottom) == 0;
    }
}

