/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/input/DeleteSurroundingTextCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "lengthBeforeCursor", "", "lengthAfterCursor", "<init>", "(II)V", "getLengthBeforeCursor", "()I", "getLengthAfterCursor", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
public final class DeleteSurroundingTextCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;
    public static final int $stable;

    public DeleteSurroundingTextCommand(int n, int n2) {
        this.lengthBeforeCursor = n;
        this.lengthAfterCursor = n2;
        n = this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0 ? 1 : 0;
        if (n == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.");
        }
    }

    public final int getLengthBeforeCursor() {
        return this.lengthBeforeCursor;
    }

    public final int getLengthAfterCursor() {
        return this.lengthAfterCursor;
    }

    @Override
    public final void applyTo(EditingBuffer editingBuffer) {
        Intrinsics.checkNotNullParameter((Object)editingBuffer, (String)"");
        int n = editingBuffer.getSelectionEnd$ui_text();
        int n2 = this.lengthAfterCursor;
        int n3 = n + n2;
        n = ((n ^ n3) & (n2 ^ n3)) < 0 ? editingBuffer.getLength$ui_text() : n3;
        EditingBuffer editingBuffer2 = editingBuffer;
        editingBuffer2.delete$ui_text(editingBuffer2.getSelectionEnd$ui_text(), Math.min(n, editingBuffer.getLength$ui_text()));
        n2 = editingBuffer.getSelectionStart$ui_text();
        n = this.lengthBeforeCursor;
        n3 = n2 - n;
        n = ((n2 ^ n) & (n2 ^ n3)) < 0 ? 0 : n3;
        editingBuffer.delete$ui_text(Math.max(0, n), editingBuffer.getSelectionStart$ui_text());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DeleteSurroundingTextCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextCommand)object).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextCommand)object).lengthAfterCursor;
    }

    public final int hashCode() {
        int n = this.lengthBeforeCursor;
        n = n * 31 + this.lengthAfterCursor;
        return n;
    }

    public final String toString() {
        return "DeleteSurroundingTextCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ")";
    }
}

