/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.cache.disk;

import e.C;
import e.I;
import e.K;
import e.f;
import e.k;
import e.l;
import e.x;
import io.kamel.core.cache.disk.DiskLruCache;
import io.kamel.core.cache.disk.FaultHidingSink;
import io.kamel.core.utils.FileSystemKt;
import io.ktor.util.collections.ConcurrentMap;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.G;
import kotlinx.coroutines.aO;
import kotlinx.coroutines.as;
import kotlinx.coroutines.g;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001%\b\u0001\u0018\u0000 G2\u00060\u0001j\u0002`\u00022\u00060\u0003j\u0002`\u0004:\u0004DEFGB;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020\u001eH\u0002J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u0017H\u0002J\b\u0010-\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020(H\u0002J\u0014\u0010/\u001a\b\u0018\u000100R\u00020\u00002\u0006\u00101\u001a\u00020\u0017J\u0014\u00102\u001a\b\u0018\u000103R\u00020\u00002\u0006\u00101\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\fJ\u001c\u00104\u001a\u00020(2\n\u00105\u001a\u000603R\u00020\u00002\u0006\u00106\u001a\u00020 H\u0002J\b\u00107\u001a\u00020 H\u0002J\u000e\u00108\u001a\u00020 2\u0006\u00101\u001a\u00020\u0017J\u0014\u00109\u001a\u00020 2\n\u0010:\u001a\u00060\u0018R\u00020\u0000H\u0002J\b\u0010;\u001a\u00020(H\u0002J\b\u0010<\u001a\u00020(H\u0016J\b\u0010=\u001a\u00020(H\u0002J\b\u0010>\u001a\u00020 H\u0002J\b\u0010?\u001a\u00020(H\u0002J\u0006\u0010@\u001a\u00020(J\b\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020(2\u0006\u00101\u001a\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\u0018R\u00020\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&\u00a8\u0006H"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "maxSize", "", "appVersion", "", "valueCount", "<init>", "(Lokio/FileSystem;Lokio/Path;Lkotlinx/coroutines/CoroutineDispatcher;JII)V", "journalFile", "journalFileTmp", "journalFileBackup", "lruEntries", "Lio/ktor/util/collections/ConcurrentMap;", "", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "size", "operationsSinceRewrite", "journalWriter", "Lokio/BufferedSink;", "hasJournalErrors", "", "initialized", "closed", "mostRecentTrimFailed", "mostRecentRebuildFailed", "io/kamel/core/cache/disk/DiskLruCache$fileSystem$1", "Lio/kamel/core/cache/disk/DiskLruCache$fileSystem$1;", "initialize", "", "readJournal", "newJournalWriter", "readJournalLine", "line", "processJournal", "writeJournal", "get", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "key", "edit", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "completeEdit", "editor", "success", "journalRewriteRequired", "remove", "removeEntry", "entry", "checkNotClosed", "close", "trimToSize", "removeOldestEntry", "delete", "evictAll", "launchCleanup", "Lkotlinx/coroutines/Job;", "validateKey", "Snapshot", "Editor", "Entry", "Companion", "kamel-core"})
public final class DiskLruCache
implements AutoCloseable {
    public static final Companion Companion = new Companion(null);
    private final C directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    private final C journalFile;
    private final C journalFileTmp;
    private final C journalFileBackup;
    private final ConcurrentMap<String, Entry> lruEntries;
    private final CoroutineScope cleanupScope;
    private long size;
    private int operationsSinceRewrite;
    private f journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private final fileSystem.1 fileSystem;
    public static final int $stable = 8;
    public static final String JOURNAL_FILE = "journal";
    public static final String JOURNAL_FILE_TMP = "journal.tmp";
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    public static final String MAGIC = "libcore.io.DiskLruCache";
    public static final String VERSION = "1";
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");

    public DiskLruCache(k object, C c, CoroutineDispatcher coroutineDispatcher, long l2, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)c, (String)"");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"");
        this.directory = c;
        this.maxSize = l2;
        this.appVersion = n;
        this.valueCount = n2;
        if (!(this.maxSize > 0L)) {
            object = "maxSize <= 0";
            throw new IllegalArgumentException(object.toString());
        }
        if (!(this.valueCount > 0)) {
            object = "valueCount <= 0";
            throw new IllegalArgumentException(object.toString());
        }
        this.journalFile = this.directory.a(JOURNAL_FILE);
        this.journalFileTmp = this.directory.a(JOURNAL_FILE_TMP);
        this.journalFileBackup = this.directory.a(JOURNAL_FILE_BACKUP);
        this.lruEntries = new ConcurrentMap(0, 1, null);
        this.cleanupScope = G.a((CoroutineContext)aO.a(null, (int)1).plus((CoroutineContext)coroutineDispatcher));
        this.fileSystem = new l((k)object){

            public final I sink(C c, boolean bl) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)c, (String)"");
                    C c2 = c.d();
                    if (c2 == null) break block0;
                    C c3 = c2;
                    this.createDirectories(c3);
                }
                return super.sink(c, bl);
            }
        };
    }

    public /* synthetic */ DiskLruCache(k k2, C c, CoroutineDispatcher coroutineDispatcher, long l2, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n = 1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 1;
        }
        this(k2, c, coroutineDispatcher, l2, n, n2);
    }

    private final void initialize() {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            if (this.initialized) {
                return;
            }
            this.fileSystem.delete(this.journalFileTmp);
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                }
            }
            if (this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    return;
                }
                catch (IOException iOException) {
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.writeJournal();
            this.initialized = true;
            return;
        }
    }

    private final void readJournal() {
        Object object = (k)this.fileSystem;
        Object object2 = this.journalFile;
        object = (Closeable)x.a((K)object.source(object2));
        object2 = null;
        try {
            e.g g2 = (e.g)object;
            e.g g3 = g2;
            g3 = g2;
            String string = g2.r();
            String string2 = g3.r();
            String string3 = g3.r();
            String string4 = g3.r();
            String string5 = g3.r();
            if (!(Intrinsics.areEqual((Object)MAGIC, (Object)string) && Intrinsics.areEqual((Object)VERSION, (Object)string2) && Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)string3) && Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)string4) && !(((CharSequence)string5).length() > 0))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ']');
            }
            int n = 0;
            try {
                while (true) {
                    this.readJournalLine(g3.r());
                    ++n;
                }
            }
            catch (EOFException eOFException) {
                this.operationsSinceRewrite = n - this.lruEntries.size();
                if (!g3.c()) {
                    this.writeJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                try {
                    Object object3 = object;
                    if (object3 != null) {
                        object3.close();
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    object2 = throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            object2 = throwable;
            try {
                Object object4 = object;
                if (object4 != null) {
                    object4.close();
                }
            }
            catch (Throwable throwable3) {
                ExceptionsKt.addSuppressed((Throwable)object2, (Throwable)throwable3);
            }
        }
        catch (Throwable throwable) {
            try {
                Object object5 = object;
                if (object5 != null) {
                    object5.close();
                }
            }
            catch (Throwable throwable4) {}
            throw throwable;
        }
        Object object6 = object2;
        if (object6 != null) {
            throw object6;
        }
    }

    private final f newJournalWriter() {
        I i = this.fileSystem.appendingSink(this.journalFile);
        i = new FaultHidingSink(i, (Function1<? super IOException, Unit>)((Function1)arg_0 -> DiskLruCache.newJournalWriter$lambda$4(this, arg_0)));
        return x.a((I)i);
    }

    private final void readJournalLine(String object) {
        Object v2;
        Object object2;
        Object object3;
        Object object4;
        int n = StringsKt.indexOf$default((CharSequence)((CharSequence)object), (char)' ', (int)0, (boolean)false, (int)6, null);
        if (n == -1) {
            throw new IOException("unexpected journal line: " + (String)object);
        }
        int n2 = n + 1;
        int n3 = StringsKt.indexOf$default((CharSequence)((CharSequence)object), (char)' ', (int)n2, (boolean)false, (int)4, null);
        if (n3 == -1) {
            String string = ((String)object).substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            object4 = string;
            if (n == 6 && StringsKt.startsWith$default((String)object, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(object4);
                return;
            }
        } else {
            String string = ((String)object).substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            object4 = string;
        }
        if ((object3 = (object2 = (Map)this.lruEntries).get(object4)) == null) {
            object3 = new Entry((String)object4);
            object2.put(object4, object3);
            v2 = object3;
        } else {
            v2 = object3;
        }
        object4 = (Entry)v2;
        if (n3 != -1 && n == 5 && StringsKt.startsWith$default((String)object, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string = ((String)object).substring(n3 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            char[] cArray = new char[1];
            object = cArray;
            cArray[0] = 32;
            object2 = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
            ((Entry)object4).setReadable(true);
            ((Entry)object4).setCurrentEditor(null);
            ((Entry)object4).setLengths((List<String>)object2);
            return;
        }
        if (n3 == -1 && n == 5 && StringsKt.startsWith$default((String)object, (String)DIRTY, (boolean)false, (int)2, null)) {
            ((Entry)object4).setCurrentEditor(new Editor((Entry)object4));
            return;
        }
        if (n3 != -1 || n != 4 || !StringsKt.startsWith$default((String)object, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException("unexpected journal line: " + (String)object);
        }
    }

    private final void processJournal() {
        long l2 = 0L;
        Iterator iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            Entry entry = (Entry)iterator.next();
            if (entry.getCurrentEditor() == null) {
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    l2 += entry.getLengths()[n];
                }
                continue;
            }
            entry.setCurrentEditor(null);
            n2 = this.valueCount;
            for (n = 0; n < n2; ++n) {
                C c = entry.getCleanFiles().get(n);
                Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                this.fileSystem.delete(c);
                C c2 = entry.getDirtyFiles().get(n);
                Intrinsics.checkNotNullExpressionValue((Object)c2, (String)"");
                this.fileSystem.delete(c2);
            }
            iterator.remove();
        }
        this.size = l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeJournal() {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            Object object;
            block19: {
                f f2 = this.journalWriter;
                if (f2 != null) {
                    f2.close();
                }
                Object object2 = (k)this.fileSystem;
                object = this.journalFileTmp;
                object2 = (Closeable)x.a((I)object2.sink(object, false));
                object = null;
                try {
                    f f3 = (f)object2;
                    f f4 = f3;
                    f4 = f3;
                    f3.b(MAGIC).f(10);
                    f4.b(VERSION).f(10);
                    f4.m((long)this.appVersion).f(10);
                    f4.m((long)this.valueCount).f(10);
                    f4.f(10);
                    for (Entry entry : this.lruEntries.values()) {
                        if (entry.getCurrentEditor() != null) {
                            f4.b(DIRTY);
                            f4.f(32);
                            f4.b(entry.getKey());
                            f4.f(10);
                            continue;
                        }
                        f4.b(CLEAN);
                        f4.f(32);
                        f4.b(entry.getKey());
                        entry.writeLengths(f4);
                        f4.f(10);
                    }
                }
                catch (Throwable throwable) {
                    Throwable f4 = throwable;
                    object = throwable;
                    try {
                        Object object3 = object2;
                        if (object3 != null) {
                            object3.close();
                        }
                        break block19;
                    }
                    catch (Throwable throwable3) {
                        ExceptionsKt.addSuppressed((Throwable)object, (Throwable)throwable3);
                    }
                    break block19;
                }
                catch (Throwable throwable2) {
                    try {
                        Object object4 = object2;
                        if (object4 == null) throw throwable2;
                        object4.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable) {}
                    throw throwable2;
                }
                try {
                    Object object5 = object2;
                    if (object5 != null) {
                        object5.close();
                    }
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    object = throwable;
                }
            }
            Object object6 = object;
            if (object6 != null) {
                throw object6;
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            }
            this.journalWriter = this.newJournalWriter();
            this.operationsSinceRewrite = 0;
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            return;
        }
    }

    public final Snapshot get(String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            Object object2;
            block5: {
                this.checkNotClosed();
                this.validateKey((String)object);
                this.initialize();
                object2 = (Entry)this.lruEntries.get(object);
                if (object2 != null && (object2 = ((Entry)object2).snapshot()) != null) break block5;
                return null;
            }
            Object object3 = object2;
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            f f2 = this.journalWriter;
            Intrinsics.checkNotNull((Object)f2);
            f f3 = f2;
            f3 = f2;
            f2.b(READ);
            f3.f(32);
            f3.b((String)object);
            f3.f(10);
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            object = object3;
            return object;
        }
    }

    public final Editor edit(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            Object object;
            Entry entry;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            this.checkNotClosed();
                            this.validateKey(string);
                            this.initialize();
                            entry = (Entry)this.lruEntries.get((Object)string);
                            if ((entry != null ? entry.getCurrentEditor() : null) == null) break block8;
                            return null;
                        }
                        if (entry == null || entry.getLockingSnapshotCount() == 0) break block9;
                        return null;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block10;
                    this.launchCleanup();
                    return null;
                }
                f f2 = this.journalWriter;
                Intrinsics.checkNotNull((Object)f2);
                object = f2;
                object = f2;
                f2.b(DIRTY);
                object.f(32);
                object.b(string);
                object.f(10);
                object.flush();
                if (!this.hasJournalErrors) break block11;
                return null;
            }
            if (entry == null) {
                entry = new Entry(string);
                ((Map)this.lruEntries).put(string, entry);
            }
            object = new Editor(entry);
            entry.setCurrentEditor((Editor)object);
            string = object;
            return string;
        }
    }

    public final long size() {
        this.initialize();
        return this.size;
    }

    private final void completeEdit(Editor editor, boolean bl) {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            int n;
            int n2;
            Entry entry = editor.getEntry();
            if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor)) {
                throw new IllegalStateException("Check failed.");
            }
            if (bl && !entry.getZombie()) {
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    if (!editor.getWritten()[n]) continue;
                    C c = entry.getDirtyFiles().get(n);
                    Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                    if (this.fileSystem.exists(c)) continue;
                    editor.abort();
                    return;
                }
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    long l2;
                    C c;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getDirtyFiles().get(n), (String)"");
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getCleanFiles().get(n), (String)"");
                    if (this.fileSystem.exists((C)editor)) {
                        this.fileSystem.atomicMove((C)editor, c);
                    } else {
                        k k2 = (k)this.fileSystem;
                        C c2 = entry.getCleanFiles().get(n);
                        Intrinsics.checkNotNullExpressionValue((Object)c2, (String)"");
                        FileSystemKt.createFile(k2, c2);
                    }
                    long l3 = entry.getLengths()[n];
                    Long l4 = this.fileSystem.metadata(c).c();
                    entry.getLengths()[n] = l2 = l4 != null ? l4 : 0L;
                    this.size = this.size - l3 + l2;
                }
            } else {
                n2 = this.valueCount;
                for (n = 0; n < n2; ++n) {
                    C c = entry.getDirtyFiles().get(n);
                    Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                    this.fileSystem.delete(c);
                }
            }
            entry.setCurrentEditor(null);
            if (entry.getZombie()) {
                this.removeEntry(entry);
                return;
            }
            n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            f f2 = this.journalWriter;
            Intrinsics.checkNotNull((Object)f2);
            f f3 = f2;
            f f4 = f2;
            if (bl || entry.getReadable()) {
                entry.setReadable(true);
                f4.b(CLEAN);
                f4.f(32);
                f4.b(entry.getKey());
                entry.writeLengths(f4);
                f4.f(10);
            } else {
                this.lruEntries.remove((Object)entry.getKey());
                f4.b(REMOVE);
                f4.f(32);
                f4.b(entry.getKey());
                f4.f(10);
            }
            f4.flush();
            if (this.size > this.maxSize || this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            return;
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    public final boolean remove(String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.checkNotClosed();
        this.validateKey((String)object);
        this.initialize();
        Entry entry = (Entry)this.lruEntries.get(object);
        if (entry == null) {
            return false;
        }
        object = entry;
        boolean bl = this.removeEntry((Entry)object);
        if (bl && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return bl;
    }

    private final boolean removeEntry(Entry entry) {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            int n;
            block9: {
                if (entry.getLockingSnapshotCount() > 0) {
                    f f2 = this.journalWriter;
                    if (f2 != null) {
                        f f3 = f2;
                        f3 = f2;
                        f2.b(DIRTY);
                        f3.f(32);
                        f3.b(entry.getKey());
                        f3.f(10);
                        f3.flush();
                    }
                }
                if (entry.getLockingSnapshotCount() <= 0 && entry.getCurrentEditor() == null) break block9;
                entry.setZombie(true);
                return true;
            }
            int n2 = this.valueCount;
            for (n = 0; n < n2; ++n) {
                C c = entry.getCleanFiles().get(n);
                Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                this.fileSystem.delete(c);
                this.size -= entry.getLengths()[n];
                entry.getLengths()[n] = 0L;
            }
            n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            f f4 = this.journalWriter;
            if (f4 != null) {
                f f5 = f4;
                f5 = f4;
                f4.b(REMOVE);
                f5.f(32);
                f5.b(entry.getKey());
                f5.f(10);
            }
            this.lruEntries.remove((Object)entry.getKey());
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            return true;
        }
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public final void close() {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            if (!this.initialized || this.closed) {
                this.closed = true;
            } else {
                Collection collection;
                Collection object2 = collection = this.lruEntries.values();
                for (Entry entry : collection.toArray(new Entry[0])) {
                    Editor editor = entry.getCurrentEditor();
                    if (editor == null) continue;
                    editor.detach();
                }
                this.trimToSize();
                int n = 1;
                CoroutineScope coroutineScope = null;
                coroutineScope = this.cleanupScope;
                G.a((CoroutineScope)coroutineScope, null);
                f f2 = this.journalWriter;
                Intrinsics.checkNotNull((Object)f2);
                f2.close();
                this.journalWriter = null;
                this.closed = true;
            }
            return;
        }
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (Entry entry : this.lruEntries.values()) {
            if (entry.getZombie()) continue;
            this.removeEntry(entry);
            return true;
        }
        return false;
    }

    private final void delete() {
        this.close();
        FileSystemKt.deleteContents((k)this.fileSystem, this.directory);
    }

    public final void evictAll() {
        Collection collection;
        this.initialize();
        Collection object2 = collection = this.lruEntries.values();
        for (Entry entry : collection.toArray(new Entry[0])) {
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private final as launchCleanup() {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            as as2 = g.a((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DiskLruCache this$0;
                {
                    this.this$0 = diskLruCache;
                    super(2, continuation);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (!DiskLruCache.access$getInitialized$p(this.this$0) || DiskLruCache.access$getClosed$p(this.this$0)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(this.this$0);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(this.this$0, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRewriteRequired(this.this$0)) {
                                    DiskLruCache.access$writeJournal(this.this$0);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(this.this$0, true);
                                DiskLruCache.access$setJournalWriter$p(this.this$0, x.a((I)x.a()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return as2;
        }
    }

    private final void validateKey(String string) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)string)) {
            string = "keys must match regex [a-z0-9_-]{1,120}: \"" + string + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final Unit newJournalWriter$lambda$4(DiskLruCache diskLruCache, IOException iOException) {
        Intrinsics.checkNotNullParameter((Object)iOException, (String)"");
        diskLruCache.hasJournalErrors = true;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache diskLruCache) {
        return diskLruCache.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache diskLruCache) {
        return diskLruCache.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache diskLruCache) {
        diskLruCache.trimToSize();
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache diskLruCache, boolean bl) {
        diskLruCache.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache diskLruCache) {
        return diskLruCache.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache diskLruCache) {
        diskLruCache.writeJournal();
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache diskLruCache, boolean bl) {
        diskLruCache.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache diskLruCache, f f2) {
        diskLruCache.journalWriter = f2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Companion;", "", "<init>", "()V", "JOURNAL_FILE", "", "JOURNAL_FILE_TMP", "JOURNAL_FILE_BACKUP", "MAGIC", "VERSION", "CLEAN", "DIRTY", "REMOVE", "READ", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "kamel-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\f\u0010\u0017\u001a\b\u0018\u00010\u0018R\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "entry", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "Lio/kamel/core/cache/disk/DiskLruCache;", "<init>", "(Lio/kamel/core/cache/disk/DiskLruCache;Lio/kamel/core/cache/disk/DiskLruCache$Entry;)V", "getEntry", "()Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "closed", "", "written", "", "getWritten", "()[Z", "file", "Lokio/Path;", "index", "", "detach", "", "commit", "commitAndGet", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "abort", "complete", "success", "kamel-core"})
    public final class Editor {
        private final Entry entry;
        private boolean closed;
        private final boolean[] written;

        public Editor(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            this.entry = entry;
            this.written = new boolean[DiskLruCache.this.valueCount];
        }

        public final Entry getEntry() {
            return this.entry;
        }

        public final boolean[] getWritten() {
            return this.written;
        }

        private final C file(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            Editor editor = this;
            synchronized (editor) {
                if (!(!this.closed)) {
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                this.written[n] = true;
                C c = this.entry.getDirtyFiles().get(n);
                Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
                C c2 = c;
                fileSystem.1 var1_3 = diskLruCache.fileSystem;
                diskLruCache = c2;
                FileSystemKt.createFile((k)var1_3, (C)diskLruCache);
                var1_3 = c2;
                return var1_3;
            }
        }

        public final C file() {
            return this.file(0);
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        public final Snapshot commitAndGet() {
            AutoCloseable autoCloseable = DiskLruCache.this;
            Editor editor = this;
            synchronized (editor) {
                this.commit();
                autoCloseable = autoCloseable.get(this.entry.getKey());
                return autoCloseable;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        private final void complete(boolean bl) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            Editor editor = this;
            synchronized (editor) {
                if (!(!this.closed)) {
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    diskLruCache.completeEdit(this, bl);
                }
                this.closed = true;
                return;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-J\u000e\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200J\f\u00101\u001a\b\u0018\u000102R\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R \u0010\u001d\u001a\b\u0018\u00010\u001eR\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00063"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "", "key", "", "<init>", "(Lio/kamel/core/cache/disk/DiskLruCache;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "cleanFiles", "Ljava/util/ArrayList;", "Lokio/Path;", "Lkotlin/collections/ArrayList;", "getCleanFiles", "()Ljava/util/ArrayList;", "dirtyFiles", "getDirtyFiles", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "currentEditor", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "Lio/kamel/core/cache/disk/DiskLruCache;", "getCurrentEditor", "()Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lio/kamel/core/cache/disk/DiskLruCache$Editor;)V", "lockingSnapshotCount", "", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V", "setLengths", "", "strings", "", "writeLengths", "writer", "Lokio/BufferedSink;", "snapshot", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "kamel-core"})
    public final class Entry {
        private final String key;
        private final long[] lengths;
        private final ArrayList<C> cleanFiles;
        private final ArrayList<C> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            this.key = string;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            DiskLruCache.this = new StringBuilder(this.key).append('.');
            int n = ((StringBuilder)DiskLruCache.this).length();
            int n2 = DiskLruCache.this.valueCount;
            for (int i = 0; i < n2; ++i) {
                ((StringBuilder)DiskLruCache.this).append(i);
                Collection collection = this.cleanFiles;
                C c = DiskLruCache.this.directory;
                String string2 = ((StringBuilder)DiskLruCache.this).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                collection.add(c.a(string2));
                ((StringBuilder)DiskLruCache.this).append(".tmp");
                collection = this.dirtyFiles;
                C c2 = DiskLruCache.this.directory;
                String string3 = ((StringBuilder)DiskLruCache.this).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                collection.add(c2.a(string3));
                ((StringBuilder)DiskLruCache.this).setLength(n);
            }
        }

        public final String getKey() {
            return this.key;
        }

        public final long[] getLengths() {
            return this.lengths;
        }

        public final ArrayList<C> getCleanFiles() {
            return this.cleanFiles;
        }

        public final ArrayList<C> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        public final void setZombie(boolean bl) {
            this.zombie = bl;
        }

        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        public final void setLockingSnapshotCount(int n) {
            this.lockingSnapshotCount = n;
        }

        public final void setLengths(List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"");
            if (list.size() != DiskLruCache.this.valueCount) {
                throw new IOException("unexpected journal line: " + list);
            }
            try {
                int n = ((Collection)list).size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(list.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("unexpected journal line: " + list);
            }
        }

        public final void writeLengths(f f2) {
            Intrinsics.checkNotNullParameter((Object)f2, (String)"");
            for (long l2 : this.lengths) {
                f2.f(32).m(l2);
            }
        }

        public final Snapshot snapshot() {
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            Object object = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (C)object2;
                if (diskLruCache.fileSystem.exists((C)object2)) continue;
                try {
                    diskLruCache.removeEntry(this);
                }
                catch (IOException iOException) {}
                return null;
            }
            int n = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n + 1;
            return new Snapshot(this);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0005R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "Lio/ktor/utils/io/core/Closeable;", "entry", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "Lio/kamel/core/cache/disk/DiskLruCache;", "<init>", "(Lio/kamel/core/cache/disk/DiskLruCache;Lio/kamel/core/cache/disk/DiskLruCache$Entry;)V", "closed", "", "file", "Lokio/Path;", "index", "", "close", "", "closeAndEdit", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "kamel-core"})
    public final class Snapshot
    implements Closeable {
        private final Entry entry;
        private boolean closed;

        public Snapshot(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            this.entry = entry;
        }

        private final C file(int n) {
            if (!(!this.closed)) {
                String string = "snapshot is closed";
                throw new IllegalStateException(string.toString());
            }
            C c = this.entry.getCleanFiles().get(n);
            Intrinsics.checkNotNullExpressionValue((Object)c, (String)"");
            return c;
        }

        public final C file() {
            return this.file(0);
        }

        @Override
        public final void close() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (!this.closed) {
                    this.closed = true;
                    g.a((CoroutineScope)diskLruCache2.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, diskLruCache2, null){
                        int label;
                        final /* synthetic */ Snapshot this$0;
                        final /* synthetic */ DiskLruCache this$1;
                        {
                            this.this$0 = snapshot;
                            this.this$1 = diskLruCache;
                            super(2, continuation);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    object = Snapshot.access$getEntry$p(this.this$0);
                                    int n = ((Entry)object).getLockingSnapshotCount();
                                    ((Entry)object).setLockingSnapshotCount(n + -1);
                                    if (Snapshot.access$getEntry$p(this.this$0).getLockingSnapshotCount() == 0 && Snapshot.access$getEntry$p(this.this$0).getZombie()) {
                                        g.a((CoroutineScope)DiskLruCache.access$getCleanupScope$p(this.this$1), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, null){
                                            int label;
                                            final /* synthetic */ DiskLruCache this$0;
                                            final /* synthetic */ Snapshot this$1;
                                            {
                                                this.this$0 = diskLruCache;
                                                this.this$1 = snapshot;
                                                super(2, continuation);
                                            }

                                            public final Object invokeSuspend(Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        DiskLruCache.access$removeEntry(this.this$0, Snapshot.access$getEntry$p(this.this$1));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                                                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                            return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                return;
            }
        }

        public final Editor closeAndEdit() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            Object object = DiskLruCache.this;
            synchronized (diskLruCache) {
                this.close();
                object = ((DiskLruCache)object).edit(this.entry.getKey());
                return object;
            }
        }

        public static final /* synthetic */ Entry access$getEntry$p(Snapshot snapshot) {
            return snapshot.entry;
        }
    }
}

