/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.BinaryColumnType;
import org.jetbrains.exposed.sql.BlobColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.statements.StatementResult;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001eH\u0016J\b\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\u0019\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020%H\u0096\u0002J)\u0010&\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0016\u00a2\u0006\u0002\u0010+J \u0010,\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0016J\u001c\u00100\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\b2\n\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0016R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00063"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "statement", "Ljava/sql/PreparedStatement;", "wasGeneratedKeysRequested", "", "(Ljava/sql/PreparedStatement;Z)V", "value", "", "fetchSize", "getFetchSize", "()Ljava/lang/Integer;", "setFetchSize", "(Ljava/lang/Integer;)V", "resultSet", "Ljava/sql/ResultSet;", "getResultSet", "()Ljava/sql/ResultSet;", "getStatement", "()Ljava/sql/PreparedStatement;", "timeout", "getTimeout", "setTimeout", "getWasGeneratedKeysRequested", "()Z", "addBatch", "", "cancel", "closeIfPossible", "executeBatch", "", "executeMultiple", "Lorg/jetbrains/exposed/sql/statements/StatementResult;", "executeQuery", "executeUpdate", "set", "index", "", "setArray", "type", "", "array", "", "(ILjava/lang/String;[Ljava/lang/Object;)V", "setInputStream", "inputStream", "Ljava/io/InputStream;", "setAsBlobObject", "setNull", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "exposed-jdbc"})
public final class JdbcPreparedStatementImpl
implements PreparedStatementApi {
    private final PreparedStatement statement;
    private final boolean wasGeneratedKeysRequested;

    public JdbcPreparedStatementImpl(PreparedStatement preparedStatement, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"");
        this.statement = preparedStatement;
        this.wasGeneratedKeysRequested = bl;
    }

    public final PreparedStatement getStatement() {
        return this.statement;
    }

    public final boolean getWasGeneratedKeysRequested() {
        return this.wasGeneratedKeysRequested;
    }

    public final ResultSet getResultSet() {
        if (!this.wasGeneratedKeysRequested) {
            return this.statement.getResultSet();
        }
        if (DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect) {
            return this.statement.getConnection().prepareStatement("select last_insert_rowid();").executeQuery();
        }
        return this.statement.getGeneratedKeys();
    }

    public final Integer getFetchSize() {
        return this.statement.getFetchSize();
    }

    public final void setFetchSize(Integer n) {
        Integer n2 = n;
        if (n2 != null) {
            ((Number)n2).intValue();
            this.statement.setFetchSize(n);
            return;
        }
    }

    public final Integer getTimeout() {
        return this.statement.getQueryTimeout();
    }

    public final void setTimeout(Integer n) {
        Integer n2 = n;
        if (n2 != null) {
            int n3 = ((Number)n2).intValue();
            this.statement.setQueryTimeout(n3);
            return;
        }
    }

    public final void addBatch() {
        this.statement.addBatch();
    }

    public final ResultSet executeQuery() {
        ResultSet resultSet = this.statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
        return resultSet;
    }

    public final int executeUpdate() {
        return this.statement.executeUpdate();
    }

    public final List<StatementResult> executeMultiple() {
        if (this.statement.execute()) {
            ResultSet resultSet = this.statement.getResultSet();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
            return CollectionsKt.listOf((Object)new StatementResult.Object(resultSet));
        }
        while (!this.statement.getMoreResults(1)) {
            if (this.statement.getUpdateCount() != -1) continue;
            return CollectionsKt.emptyList();
        }
        ResultSet resultSet = this.statement.getResultSet();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"");
        return CollectionsKt.listOf((Object)new StatementResult.Object(resultSet));
    }

    public final void set(int n, Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.statement.setObject(n, object);
    }

    public final void setNull(int n, IColumnType<?> iColumnType) {
        Intrinsics.checkNotNullParameter(iColumnType, (String)"");
        if (iColumnType instanceof BinaryColumnType || iColumnType instanceof BlobColumnType && !((BlobColumnType)iColumnType).getUseObjectIdentifier()) {
            this.statement.setNull(n, -4);
            return;
        }
        this.statement.setObject(n, null);
    }

    public final void setInputStream(int n, InputStream inputStream, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
        if (bl) {
            this.statement.setBlob(n, inputStream);
            return;
        }
        InputStream inputStream2 = inputStream;
        this.statement.setBinaryStream(n, inputStream2, inputStream2.available());
    }

    public final void setArray(int n, String string, Object[] objectArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
        PreparedStatement preparedStatement = this.statement;
        preparedStatement.setArray(n, preparedStatement.getConnection().createArrayOf(string, objectArray));
    }

    public final void closeIfPossible() {
        if (!this.statement.isClosed()) {
            this.statement.close();
        }
    }

    public final List<Integer> executeBatch() {
        int[] nArray = this.statement.executeBatch();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"");
        Object object = nArray;
        int[] nArray2 = nArray;
        object = new ArrayList(((int[])object).length);
        for (int n : nArray2) {
            int n2;
            Object object2 = object;
            switch (n) {
                case -2: {
                    n2 = 1;
                    break;
                }
                case -3: {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = n;
                }
            }
            object2.add(n2);
        }
        return (List)object;
    }

    public final void cancel() {
        if (!this.statement.isClosed()) {
            this.statement.cancel();
        }
    }

    public final int fillParameters(Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> iterable) {
        return PreparedStatementApi.DefaultImpls.fillParameters((PreparedStatementApi)this, iterable);
    }
}

