/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ConsoleAppender<E>
extends OutputStreamAppender<E> {
    protected ConsoleTarget target = ConsoleTarget.SystemOut;
    protected boolean withJansi = false;
    private static final String AnsiConsole_CLASS_NAME = "org.fusesource.jansi.AnsiConsole";
    private static final String JANSI2_OUT_METHOD_NAME = "out";
    private static final String JANSI2_ERR_METHOD_NAME = "err";
    private static final String wrapSystemOut_METHOD_NAME = "wrapSystemOut";
    private static final String wrapSystemErr_METHOD_NAME = "wrapSystemErr";
    private static final Class<?>[] ARGUMENT_TYPES = new Class[]{PrintStream.class};

    public void setTarget(String string) {
        ConsoleTarget consoleTarget = ConsoleTarget.findByName(string.trim());
        if (consoleTarget == null) {
            this.targetWarn(string);
            return;
        }
        this.target = consoleTarget;
    }

    public String getTarget() {
        return this.target.getName();
    }

    private void targetWarn(String object) {
        object = new WarnStatus("[" + (String)object + "] should be one of " + Arrays.toString((Object[])ConsoleTarget.values()), this);
        object.add(new WarnStatus("Using previously set target, System.out by default.", this));
        this.addStatus((Status)object);
    }

    @Override
    public void start() {
        OutputStream outputStream = this.target.getStream();
        if (this.withJansi) {
            outputStream = this.wrapWithJansi(outputStream);
        }
        this.setOutputStream(outputStream);
        super.start();
    }

    private OutputStream wrapWithJansi(OutputStream outputStream) {
        try {
            this.addInfo("Enabling JANSI AnsiPrintStream for the console.");
            Object object = Loader.getClassLoaderOfObject(this.context);
            object = ((ClassLoader)object).loadClass(AnsiConsole_CLASS_NAME);
            Object object2 = this.target == ConsoleTarget.SystemOut ? JANSI2_OUT_METHOD_NAME : JANSI2_ERR_METHOD_NAME;
            object2 = Arrays.stream(((Class)object).getMethods()).filter(arg_0 -> ConsoleAppender.lambda$wrapWithJansi$0((String)object2, arg_0)).filter(method -> method.getParameters().length == 0).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> PrintStream.class.isAssignableFrom(method.getReturnType())).findAny();
            if (((Optional)object2).isPresent()) {
                object2 = (Method)((Optional)object2).orElseThrow(() -> new NoSuchElementException("No value present"));
                return (PrintStream)((Method)object2).invoke(null, new Object[0]);
            }
            object2 = this.target == ConsoleTarget.SystemOut ? wrapSystemOut_METHOD_NAME : wrapSystemErr_METHOD_NAME;
            object = ((Class)object).getMethod((String)object2, ARGUMENT_TYPES);
            return (OutputStream)((Method)object).invoke(null, new PrintStream(outputStream));
        }
        catch (Exception exception) {
            this.addWarn("Failed to create AnsiPrintStream. Falling back on the default stream.", exception);
            return outputStream;
        }
    }

    public boolean isWithJansi() {
        return this.withJansi;
    }

    public void setWithJansi(boolean bl) {
        this.withJansi = bl;
    }

    private static /* synthetic */ boolean lambda$wrapWithJansi$0(String string, Method method) {
        return method.getName().equals(string);
    }
}

