/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.filter;

import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;

public class EvaluatorFilter<E>
extends AbstractMatcherFilter<E> {
    EventEvaluator<E> evaluator;

    @Override
    public void start() {
        if (this.evaluator != null) {
            super.start();
            return;
        }
        EvaluatorFilter evaluatorFilter = this;
        evaluatorFilter.addError("No evaluator set for filter " + evaluatorFilter.getName());
    }

    public EventEvaluator<E> getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(EventEvaluator<E> eventEvaluator) {
        this.evaluator = eventEvaluator;
    }

    @Override
    public FilterReply decide(E e) {
        if (!this.isStarted() || !this.evaluator.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        try {
            if (this.evaluator.evaluate(e)) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        catch (EvaluationException evaluationException) {
            EvaluatorFilter evaluatorFilter = this;
            evaluatorFilter.addError("Evaluator " + evaluatorFilter.evaluator.getName() + " threw an exception", evaluationException);
            return FilterReply.NEUTRAL;
        }
    }
}

