/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.SpacePadder;

public abstract class FormattingConverter<E>
extends Converter<E> {
    static final int INITIAL_BUF_SIZE = 256;
    static final int MAX_CAPACITY = 1024;
    FormatInfo formattingInfo;

    public final FormatInfo getFormattingInfo() {
        return this.formattingInfo;
    }

    public final void setFormattingInfo(FormatInfo formatInfo) {
        if (this.formattingInfo != null) {
            throw new IllegalStateException("FormattingInfo has been already set");
        }
        this.formattingInfo = formatInfo;
    }

    @Override
    public final void write(StringBuilder stringBuilder, E object) {
        object = this.convert(object);
        if (this.formattingInfo == null) {
            stringBuilder.append((String)object);
            return;
        }
        int n = this.formattingInfo.getMin();
        int n2 = this.formattingInfo.getMax();
        if (object == null) {
            if (n > 0) {
                SpacePadder.spacePad(stringBuilder, n);
            }
            return;
        }
        int n3 = ((String)object).length();
        if (n3 > n2) {
            if (this.formattingInfo.isLeftTruncate()) {
                stringBuilder.append(((String)object).substring(n3 - n2));
                return;
            }
            stringBuilder.append(((String)object).substring(0, n2));
            return;
        }
        if (n3 < n) {
            if (this.formattingInfo.isLeftPad()) {
                SpacePadder.leftPad(stringBuilder, (String)object, n);
                return;
            }
            SpacePadder.rightPad(stringBuilder, (String)object, n);
            return;
        }
        stringBuilder.append((String)object);
    }
}

