/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.AnchoredDraggableKt;
import androidx.compose.foundation.gestures.DraggableAnchors;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\u0017\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0013\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0018H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Landroidx/compose/foundation/gestures/DefaultDraggableAnchors;", "T", "Landroidx/compose/foundation/gestures/DraggableAnchors;", "keys", "", "anchors", "", "<init>", "(Ljava/util/List;[F)V", "positionOf", "", "anchor", "(Ljava/lang/Object;)F", "hasPositionFor", "", "(Ljava/lang/Object;)Z", "closestAnchor", "position", "(F)Ljava/lang/Object;", "searchUpwards", "(FZ)Ljava/lang/Object;", "minPosition", "maxPosition", "size", "", "getSize", "()I", "anchorAt", "index", "(I)Ljava/lang/Object;", "positionAt", "equals", "other", "", "hashCode", "toString", "", "foundation"})
final class DefaultDraggableAnchors<T>
implements DraggableAnchors<T> {
    private final List<T> keys;
    private final float[] anchors;
    private final int size;

    public DefaultDraggableAnchors(List<? extends T> list, float[] fArray) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        this.keys = list;
        this.anchors = fArray;
        boolean bl = this.keys.size() == this.anchors.length;
        if (!bl) {
            InlineClassHelperKt.throwIllegalArgumentException("DraggableAnchors were constructed with inconsistent key-value sizes. Keys: " + this.keys + " | Anchors: " + ArraysKt.toList((float[])this.anchors));
        }
        this.size = this.anchors.length;
    }

    @Override
    public final float positionOf(T t2) {
        int n = this.keys.indexOf(t2);
        float[] fArray = this.anchors;
        Function1 function1 = AnchoredDraggableKt.access$getGetOrNan$p();
        boolean bl = n >= 0 ? n < fArray.length : false;
        if (bl) {
            return fArray[n];
        }
        return ((Number)function1.invoke((Object)n)).floatValue();
    }

    @Override
    public final boolean hasPositionFor(T t2) {
        return this.keys.indexOf(t2) != -1;
    }

    @Override
    public final T closestAnchor(float f2) {
        int n = -1;
        float f3 = Float.POSITIVE_INFINITY;
        float[] fArray = this.anchors;
        int n2 = 0;
        for (float f4 : fArray) {
            float f5;
            int n3 = n2++;
            f4 = Math.abs(f2 - f4);
            if (!(f5 <= f3)) continue;
            n = n3;
            f3 = f4;
        }
        return this.keys.get(n);
    }

    @Override
    public final T closestAnchor(float f2, boolean bl) {
        int n = -1;
        float f3 = Float.POSITIVE_INFINITY;
        float[] fArray = this.anchors;
        int n2 = 0;
        for (float f4 : fArray) {
            int n3 = n2++;
            f4 = bl ? f4 - f2 : f2 - f4;
            float f5 = f4 = f4 < 0.0f ? Float.POSITIVE_INFINITY : f4;
            if (!(f5 <= f3)) continue;
            n = n3;
            f3 = f4;
        }
        return this.keys.get(n);
    }

    @Override
    public final float minPosition() {
        Float f2 = ArraysKt.minOrNull((float[])this.anchors);
        if (f2 != null) {
            return f2.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public final float maxPosition() {
        Float f2 = ArraysKt.maxOrNull((float[])this.anchors);
        if (f2 != null) {
            return f2.floatValue();
        }
        return Float.NaN;
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    public final T anchorAt(int n) {
        return (T)CollectionsKt.getOrNull(this.keys, (int)n);
    }

    @Override
    public final float positionAt(int n) {
        float[] fArray = this.anchors;
        Function1 function1 = AnchoredDraggableKt.access$getGetOrNan$p();
        boolean bl = n >= 0 ? n < fArray.length : false;
        if (bl) {
            return fArray[n];
        }
        return ((Number)function1.invoke((Object)n)).floatValue();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultDraggableAnchors)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keys, ((DefaultDraggableAnchors)object).keys)) {
            return false;
        }
        if (!Arrays.equals(this.anchors, ((DefaultDraggableAnchors)object).anchors)) {
            return false;
        }
        return this.getSize() == ((DefaultDraggableAnchors)object).getSize();
    }

    public final int hashCode() {
        int n = ((Object)this.keys).hashCode();
        n = n * 31 + Arrays.hashCode(this.anchors);
        n = n * 31 + this.getSize();
        return n;
    }

    public final String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append("DraggableAnchors(anchors={");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(this.anchorAt(i) + "=" + this.positionAt(i));
            if (i >= this.getSize() - 1) continue;
            stringBuilder2.append(", ");
        }
        stringBuilder2.append("})");
        return stringBuilder.toString();
    }
}

