/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString;
import io.netty.util.NetUtilInitializations;
import io.netty.util.internal.BoundedInputStream;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final Collection<NetworkInterface> NETWORK_INTERFACES;
    public static final int SOMAXCONN;
    private static final int IPV6_WORD_COUNT = 8;
    private static final int IPV6_MAX_CHAR_COUNT = 39;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int IPV6_MAX_CHAR_BETWEEN_SEPARATOR = 4;
    private static final int IPV6_MIN_SEPARATORS = 2;
    private static final int IPV6_MAX_SEPARATORS = 8;
    private static final int IPV4_MAX_CHAR_BETWEEN_SEPARATOR = 3;
    private static final int IPV4_SEPARATORS = 3;
    private static final boolean IPV4_PREFERRED;
    private static final boolean IPV6_ADDRESSES_PREFERRED;
    private static final InternalLogger logger;

    private static Integer sysctlGetInt(String object) {
        Process process = new ProcessBuilder(new String[]{"sysctl", object}).start();
        try {
            Closeable closeable;
            block8: {
                closeable = process.getInputStream();
                closeable = new InputStreamReader(new BoundedInputStream((InputStream)closeable));
                closeable = new BufferedReader((Reader)closeable);
                try {
                    String string = ((BufferedReader)closeable).readLine();
                    if (string == null || !string.startsWith((String)object)) break block8;
                    for (int i = string.length() - 1; i > ((String)object).length(); --i) {
                        if (Character.isDigit(string.charAt(i))) continue;
                        object = Integer.valueOf(string.substring(i + 1));
                    }
                }
                catch (Throwable throwable) {
                    ((BufferedReader)closeable).close();
                    throw throwable;
                }
                {
                    ((BufferedReader)closeable).close();
                    return object;
                }
            }
            ((BufferedReader)closeable).close();
            return null;
        }
        finally {
            process.destroy();
        }
    }

    public static boolean isIpV4StackPreferred() {
        return IPV4_PREFERRED;
    }

    public static boolean isIpV6AddressesPreferred() {
        return IPV6_ADDRESSES_PREFERRED;
    }

    public static byte[] createByteArrayFromIpAddressString(String string) {
        if (NetUtil.isValidIpV4Address(string)) {
            return NetUtil.validIpV4ToBytes(string);
        }
        if (NetUtil.isValidIpV6Address(string)) {
            int n;
            if (string.charAt(0) == '[') {
                string = string.substring(1, string.length() - 1);
            }
            if ((n = string.indexOf(37)) >= 0) {
                string = string.substring(0, n);
            }
            return NetUtil.getIPv6ByName(string, true);
        }
        return null;
    }

    public static InetAddress createInetAddressFromIpAddressString(String object) {
        if (NetUtil.isValidIpV4Address((String)object)) {
            byte[] byArray = NetUtil.validIpV4ToBytes((String)object);
            try {
                return InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalStateException(unknownHostException);
            }
        }
        if (NetUtil.isValidIpV6Address((String)object)) {
            int n;
            if (((String)object).charAt(0) == '[') {
                object = ((String)object).substring(1, ((String)object).length() - 1);
            }
            if ((n = ((String)object).indexOf(37)) >= 0) {
                try {
                    int n2 = Integer.parseInt(((String)object).substring(n + 1));
                    object = ((String)object).substring(0, n);
                    byte[] byArray = NetUtil.getIPv6ByName((CharSequence)object, true);
                    object = byArray;
                    if (byArray == null) {
                        return null;
                    }
                    try {
                        return Inet6Address.getByAddress(null, (byte[])object, n2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalStateException(unknownHostException);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            byte[] byArray = NetUtil.getIPv6ByName((CharSequence)object, true);
            if (byArray == null) {
                return null;
            }
            try {
                return InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalStateException(unknownHostException);
            }
        }
        return null;
    }

    private static int decimalDigit(String string, int n) {
        return string.charAt(n) - 48;
    }

    private static byte ipv4WordToByte(String string, int n, int n2) {
        int n3 = NetUtil.decimalDigit(string, n);
        if (++n == n2) {
            return (byte)n3;
        }
        n3 = n3 * 10 + NetUtil.decimalDigit(string, n);
        if (++n == n2) {
            return (byte)n3;
        }
        return (byte)(n3 * 10 + NetUtil.decimalDigit(string, n));
    }

    static byte[] validIpV4ToBytes(String string) {
        byte[] byArray = new byte[4];
        int n = string.indexOf(46, 1);
        byArray[0] = NetUtil.ipv4WordToByte(string, 0, n);
        int n2 = n + 1;
        n = string.indexOf(46, n + 2);
        byArray[1] = NetUtil.ipv4WordToByte(string, n2, n);
        int n3 = n + 1;
        n = string.indexOf(46, n + 2);
        byArray[2] = NetUtil.ipv4WordToByte(string, n3, n);
        byArray[3] = NetUtil.ipv4WordToByte(string, n + 1, string.length());
        return byArray;
    }

    public static int ipv4AddressToInt(Inet4Address object) {
        byte[] byArray = ((Inet4Address)object).getAddress();
        object = byArray;
        return (byArray[0] & 0xFF) << 24 | (object[1] & 0xFF) << 16 | (object[2] & 0xFF) << 8 | object[3] & 0xFF;
    }

    public static String intToIpAddress(int n) {
        StringBuilder stringBuilder = new StringBuilder(15);
        stringBuilder.append(n >>> 24);
        stringBuilder.append('.');
        stringBuilder.append(n >> 16 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n >> 8 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n & 0xFF);
        return stringBuilder.toString();
    }

    public static String bytesToIpAddress(byte[] byArray) {
        return NetUtil.bytesToIpAddress(byArray, 0, byArray.length);
    }

    public static String bytesToIpAddress(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 4: {
                return new StringBuilder(15).append(byArray[n] & 0xFF).append('.').append(byArray[n + 1] & 0xFF).append('.').append(byArray[n + 2] & 0xFF).append('.').append(byArray[n + 3] & 0xFF).toString();
            }
            case 16: {
                return NetUtil.toAddressString(byArray, n, false);
            }
        }
        throw new IllegalArgumentException("length: " + n2 + " (expected: 4 or 16)");
    }

    public static boolean isValidIpV6Address(String string) {
        return NetUtil.isValidIpV6Address((CharSequence)string);
    }

    public static boolean isValidIpV6Address(CharSequence charSequence) {
        int n;
        int n2;
        int n3;
        int n4 = charSequence.length();
        if (n4 < 2) {
            return false;
        }
        int n5 = charSequence.charAt(0);
        if (n5 == 91) {
            if (charSequence.charAt(--n4) != ']') {
                return false;
            }
            n3 = 1;
            n5 = charSequence.charAt(1);
        } else {
            n3 = 0;
        }
        if (n5 == 58) {
            if (charSequence.charAt(n3 + 1) != ':') {
                return false;
            }
            n2 = 2;
            n = n3;
            n3 += 2;
        } else {
            n2 = 0;
            n = -1;
        }
        int n6 = 0;
        block5: for (int i = n3; i < n4; ++i) {
            n5 = charSequence.charAt(i);
            if (NetUtil.isValidHexChar((char)n5)) {
                if (n6 < 4) {
                    ++n6;
                    continue;
                }
                return false;
            }
            switch (n5) {
                case 58: {
                    if (n2 > 7) {
                        return false;
                    }
                    if (charSequence.charAt(i - 1) == ':') {
                        if (n >= 0) {
                            return false;
                        }
                        n = i - 1;
                    } else {
                        n6 = 0;
                    }
                    ++n2;
                    continue block5;
                }
                case 46: {
                    if (n < 0 && n2 != 6 || n2 == 7 && n >= n3 || n2 > 7) {
                        return false;
                    }
                    n5 = i - n6;
                    n2 = n5 - 2;
                    if (NetUtil.isValidIPv4MappedChar(charSequence.charAt(n2))) {
                        if (!(NetUtil.isValidIPv4MappedChar(charSequence.charAt(n2 - 1)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n2 - 2)) && NetUtil.isValidIPv4MappedChar(charSequence.charAt(n2 - 3)))) {
                            return false;
                        }
                        n2 -= 5;
                    }
                    while (n2 >= n3) {
                        char c = charSequence.charAt(n2);
                        n = c;
                        if (c != '0' && n != 58) {
                            return false;
                        }
                        --n2;
                    }
                    n = AsciiString.indexOf(charSequence, '%', n5 + 7);
                    if (n < 0) {
                        n = n4;
                    }
                    return NetUtil.isValidIpV4Address(charSequence, n5, n);
                }
                case 37: {
                    n4 = i;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (n < 0) {
            return n2 == 7 && n6 > 0;
        }
        return n + 2 == n4 || n6 > 0 && (n2 < 8 || n <= n3);
    }

    private static boolean isValidIpV4Word(CharSequence charSequence, int n, int n2) {
        char c;
        if ((n2 -= n) <= 0 || n2 > 3 || (c = charSequence.charAt(n)) < '0') {
            return false;
        }
        if (n2 == 3) {
            char c2;
            char c3 = charSequence.charAt(n + 1);
            n2 = c3;
            return c3 >= '0' && (c2 = charSequence.charAt(n + 2)) >= '0' && (c <= '1' && n2 <= 57 && c2 <= '9' || c == '2' && n2 <= 53 && (c2 <= '5' || n2 < 53 && c2 <= '9'));
        }
        return c <= '9' && (n2 == 1 || NetUtil.isValidNumericChar(charSequence.charAt(n + 1)));
    }

    private static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidNumericChar(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isValidIPv4MappedChar(char c) {
        return c == 'f' || c == 'F';
    }

    private static boolean isValidIPv4MappedSeparators(byte by, byte by2, boolean bl) {
        return by == by2 && (by == 0 || !bl && by2 == -1);
    }

    private static boolean isValidIPv4Mapped(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3 = n2 + n3 >= 14 ? 1 : 0;
        return n <= 12 && n >= 2 && (n3 == 0 || n2 < 12) && NetUtil.isValidIPv4MappedSeparators(byArray[n - 1], byArray[n - 2], n3 != 0) && PlatformDependent.isZero(byArray, 0, n - 3);
    }

    public static boolean isValidIpV4Address(CharSequence charSequence) {
        return NetUtil.isValidIpV4Address(charSequence, 0, charSequence.length());
    }

    public static boolean isValidIpV4Address(String string) {
        return NetUtil.isValidIpV4Address(string, 0, string.length());
    }

    private static boolean isValidIpV4Address(CharSequence charSequence, int n, int n2) {
        if (charSequence instanceof String) {
            return NetUtil.isValidIpV4Address((String)charSequence, n, n2);
        }
        if (charSequence instanceof AsciiString) {
            return NetUtil.isValidIpV4Address((AsciiString)charSequence, n, n2);
        }
        return NetUtil.isValidIpV4Address0(charSequence, n, n2);
    }

    private static boolean isValidIpV4Address(String string, int n, int n2) {
        int n3 = n2 - n;
        return n3 <= 15 && n3 >= 7 && (n3 = string.indexOf(46, n + 1)) > 0 && NetUtil.isValidIpV4Word(string, n, n3) && (n3 = string.indexOf(46, n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n - 1, n3) && (n3 = string.indexOf(46, n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(string, n - 1, n3) && NetUtil.isValidIpV4Word(string, n3 + 1, n2);
    }

    private static boolean isValidIpV4Address(AsciiString asciiString, int n, int n2) {
        int n3 = n2 - n;
        return n3 <= 15 && n3 >= 7 && (n3 = asciiString.indexOf('.', n + 1)) > 0 && NetUtil.isValidIpV4Word(asciiString, n, n3) && (n3 = asciiString.indexOf('.', n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n - 1, n3) && (n3 = asciiString.indexOf('.', n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(asciiString, n - 1, n3) && NetUtil.isValidIpV4Word(asciiString, n3 + 1, n2);
    }

    private static boolean isValidIpV4Address0(CharSequence charSequence, int n, int n2) {
        int n3 = n2 - n;
        return n3 <= 15 && n3 >= 7 && (n3 = AsciiString.indexOf(charSequence, '.', n + 1)) > 0 && NetUtil.isValidIpV4Word(charSequence, n, n3) && (n3 = AsciiString.indexOf(charSequence, '.', n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n - 1, n3) && (n3 = AsciiString.indexOf(charSequence, '.', n = n3 + 2)) > 0 && NetUtil.isValidIpV4Word(charSequence, n - 1, n3) && NetUtil.isValidIpV4Word(charSequence, n3 + 1, n2);
    }

    public static Inet6Address getByName(CharSequence charSequence) {
        return NetUtil.getByName(charSequence, true);
    }

    public static Inet6Address getByName(CharSequence object, boolean bl) {
        byte[] byArray = NetUtil.getIPv6ByName((CharSequence)object, bl);
        object = byArray;
        if (byArray == null) {
            return null;
        }
        try {
            return Inet6Address.getByAddress(null, (byte[])object, -1);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    static byte[] getIPv6ByName(CharSequence charSequence, boolean bl) {
        int n;
        char c;
        int n2;
        byte[] byArray = new byte[16];
        int n3 = charSequence.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        block4: for (n2 = 0; n2 < n3; ++n2) {
            c = charSequence.charAt(n2);
            switch (c) {
                case ':': {
                    if (n2 - n8 > 4 || n10 > 0 || ++n9 > 8 || n6 + 1 >= byArray.length) {
                        return null;
                    }
                    n7 <<= 4 - (n2 - n8) << 2;
                    if (n5 > 0) {
                        n5 -= 2;
                    }
                    byArray[n6++] = (byte)((n7 & 0xF) << 4 | n7 >> 4 & 0xF);
                    byArray[n6++] = (byte)((n7 >> 8 & 0xF) << 4 | n7 >> 12 & 0xF);
                    n = n2 + 1;
                    if (n < n3 && charSequence.charAt(n) == ':') {
                        if (n4 != 0 || ++n < n3 && charSequence.charAt(n) == ':') {
                            return null;
                        }
                        ++n9;
                        n4 = n6;
                        n5 = byArray.length - n4 - 2;
                        ++n2;
                    }
                    n7 = 0;
                    n8 = -1;
                    continue block4;
                }
                case '.': {
                    n = n2 - n8;
                    if (n > 3 || n8 < 0 || ++n10 > 3 || n9 > 0 && n6 + n5 < 12 || n2 + 1 >= n3 || n6 >= byArray.length || n10 == 1 && (!bl || n6 != 0 && !NetUtil.isValidIPv4Mapped(byArray, n6, n4, n5) || n == 3 && (!NetUtil.isValidNumericChar(charSequence.charAt(n2 - 1)) || !NetUtil.isValidNumericChar(charSequence.charAt(n2 - 2)) || !NetUtil.isValidNumericChar(charSequence.charAt(n2 - 3))) || n == 2 && (!NetUtil.isValidNumericChar(charSequence.charAt(n2 - 1)) || !NetUtil.isValidNumericChar(charSequence.charAt(n2 - 2))) || n == 1 && !NetUtil.isValidNumericChar(charSequence.charAt(n2 - 1)))) {
                        return null;
                    }
                    if ((n8 = ((n7 <<= 3 - n << 2) & 0xF) * 100 + (n7 >> 4 & 0xF) * 10 + (n7 >> 8 & 0xF)) > 255) {
                        return null;
                    }
                    byArray[n6++] = (byte)n8;
                    n7 = 0;
                    n8 = -1;
                    continue block4;
                }
                default: {
                    if (!NetUtil.isValidHexChar(c) || n10 > 0 && !NetUtil.isValidNumericChar(c)) {
                        return null;
                    }
                    if (n8 < 0) {
                        n8 = n2;
                    } else if (n2 - n8 > 4) {
                        return null;
                    }
                    n7 += StringUtil.decodeHexNibble(c) << (n2 - n8 << 2);
                }
            }
        }
        char c2 = c = n4 > 0 ? (char)'\u0001' : '\u0000';
        if (n10 > 0) {
            if (n8 > 0 && n2 - n8 > 3 || n10 != 3 || n6 >= byArray.length) {
                return null;
            }
            if (n9 != 0 && (n9 < 2 || (c != '\u0000' || n9 != 6 || charSequence.charAt(0) == ':') && (c == '\u0000' || n9 >= 8 || charSequence.charAt(0) == ':' && n4 > 2))) {
                return null;
            }
            if ((n8 = ((n7 <<= 3 - (n2 - n8) << 2) & 0xF) * 100 + (n7 >> 4 & 0xF) * 10 + (n7 >> 8 & 0xF)) > 255) {
                return null;
            }
            byArray[n6++] = (byte)n8;
        } else {
            n = n3 - 1;
            if (n8 > 0 && n2 - n8 > 4 || n9 < 2 || c == '\u0000' && (n9 + 1 != 8 || charSequence.charAt(0) == ':' || charSequence.charAt(n) == ':') || c != '\u0000' && (n9 > 8 || n9 == 8 && (n4 <= 2 && charSequence.charAt(0) != ':' || n4 >= 14 && charSequence.charAt(n) != ':')) || n6 + 1 >= byArray.length || n8 < 0 && charSequence.charAt(n - 1) != ':' || n4 > 2 && charSequence.charAt(0) == ':') {
                return null;
            }
            if (n8 >= 0 && n2 - n8 <= 4) {
                n7 <<= 4 - (n2 - n8) << 2;
            }
            byArray[n6++] = (byte)((n7 & 0xF) << 4 | n7 >> 4 & 0xF);
            byArray[n6++] = (byte)((n7 >> 8 & 0xF) << 4 | n7 >> 12 & 0xF);
        }
        if (n6 < byArray.length) {
            int n11 = n6 - n4;
            int n12 = byArray.length - n11;
            System.arraycopy(byArray, n4, byArray, n12, n11);
            Arrays.fill(byArray, n4, n12, (byte)0);
        }
        if (n10 > 0) {
            byArray[11] = -1;
            byArray[10] = -1;
        }
        return byArray;
    }

    public static String toSocketAddressString(InetSocketAddress object) {
        String string = String.valueOf(((InetSocketAddress)object).getPort());
        if (((InetSocketAddress)object).isUnresolved()) {
            object = NetUtil.newSocketAddressStringBuilder((String)object, string, !NetUtil.isValidIpV6Address((String)(object = NetUtil.getHostname((InetSocketAddress)object))));
        } else {
            object = ((InetSocketAddress)object).getAddress();
            String string2 = NetUtil.toAddressString((InetAddress)object);
            object = NetUtil.newSocketAddressStringBuilder(string2, string, object instanceof Inet4Address);
        }
        return ((StringBuilder)object).append(':').append(string).toString();
    }

    public static String toSocketAddressString(String string, int n) {
        String string2 = String.valueOf(n);
        return NetUtil.newSocketAddressStringBuilder(string, string2, !NetUtil.isValidIpV6Address(string)).append(':').append(string2).toString();
    }

    private static StringBuilder newSocketAddressStringBuilder(String string, String charSequence, boolean bl) {
        int n = string.length();
        if (bl) {
            return new StringBuilder(n + 1 + ((String)charSequence).length()).append(string);
        }
        charSequence = new StringBuilder(n + 3 + ((String)charSequence).length());
        if (n > 1 && string.charAt(0) == '[' && string.charAt(n - 1) == ']') {
            return ((StringBuilder)charSequence).append(string);
        }
        return ((StringBuilder)charSequence).append('[').append(string).append(']');
    }

    public static String toAddressString(InetAddress inetAddress) {
        return NetUtil.toAddressString(inetAddress, false);
    }

    public static String toAddressString(InetAddress inetAddress, boolean bl) {
        if (inetAddress instanceof Inet4Address) {
            return inetAddress.getHostAddress();
        }
        if (!(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + inetAddress);
        }
        return NetUtil.toAddressString(inetAddress.getAddress(), 0, bl);
    }

    private static String toAddressString(byte[] byArray, int n, boolean n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[8];
        for (n5 = 0; n5 < nArray.length; ++n5) {
            n4 = (n5 << 1) + n;
            nArray[n5] = (byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF;
        }
        n5 = -1;
        int n6 = -1;
        n = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] == 0) {
                if (n5 >= 0) continue;
                n5 = n3;
                continue;
            }
            if (n5 < 0) continue;
            n4 = n3 - n5;
            if (n4 > n) {
                n6 = n5;
                n = n4;
            }
            n5 = -1;
        }
        if (n5 >= 0 && (n4 = nArray.length - n5) > n) {
            n6 = n5;
            n = n4;
        }
        if (n == 1) {
            n = 0;
            n6 = -1;
        }
        n3 = n6 + n;
        StringBuilder stringBuilder = new StringBuilder(39);
        if (n3 < 0) {
            stringBuilder.append(Integer.toHexString(nArray[0]));
            for (n2 = 1; n2 < nArray.length; ++n2) {
                stringBuilder.append(':');
                stringBuilder.append(Integer.toHexString(nArray[n2]));
            }
        } else {
            if (NetUtil.inRangeEndExclusive(0, n6, n3)) {
                stringBuilder.append("::");
                n2 = n2 != 0 && n3 == 5 && nArray[5] == 65535 ? 1 : 0;
            } else {
                stringBuilder.append(Integer.toHexString(nArray[0]));
                n2 = 0;
            }
            for (n5 = 1; n5 < nArray.length; ++n5) {
                if (!NetUtil.inRangeEndExclusive(n5, n6, n3)) {
                    if (!NetUtil.inRangeEndExclusive(n5 - 1, n6, n3)) {
                        if (n2 == 0 || n5 == 6) {
                            stringBuilder.append(':');
                        } else {
                            stringBuilder.append('.');
                        }
                    }
                    if (n2 != 0 && n5 > 5) {
                        stringBuilder.append(nArray[n5] >> 8);
                        stringBuilder.append('.');
                        stringBuilder.append(nArray[n5] & 0xFF);
                        continue;
                    }
                    stringBuilder.append(Integer.toHexString(nArray[n5]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(n5 - 1, n6, n3)) continue;
                stringBuilder.append("::");
            }
        }
        return stringBuilder.toString();
    }

    public static String getHostname(InetSocketAddress inetSocketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            return inetSocketAddress.getHostString();
        }
        return inetSocketAddress.getHostName();
    }

    private static boolean inRangeEndExclusive(int n, int n2, int n3) {
        return n >= n2 && n < n3;
    }

    private NetUtil() {
    }

    static {
        IPV4_PREFERRED = SystemPropertyUtil.getBoolean("java.net.preferIPv4Stack", false);
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        Object object = SystemPropertyUtil.get("java.net.preferIPv6Addresses", "false");
        IPV6_ADDRESSES_PREFERRED = "true".equalsIgnoreCase(((String)object).trim());
        logger.debug("-Djava.net.preferIPv4Stack: {}", (Object)IPV4_PREFERRED);
        logger.debug("-Djava.net.preferIPv6Addresses: {}", object);
        NETWORK_INTERFACES = NetUtilInitializations.networkInterfaces();
        LOCALHOST4 = NetUtilInitializations.createLocalhost4();
        LOCALHOST6 = NetUtilInitializations.createLocalhost6();
        object = NetUtilInitializations.determineLoopback(NETWORK_INTERFACES, LOCALHOST4, LOCALHOST6);
        LOOPBACK_IF = ((NetUtilInitializations.NetworkIfaceAndInetAddress)object).iface();
        LOCALHOST = ((NetUtilInitializations.NetworkIfaceAndInetAddress)object).address();
        SOMAXCONN = AccessController.doPrivileged(new SoMaxConnAction());
    }

    private static final class SoMaxConnAction
    implements PrivilegedAction<Integer> {
        private SoMaxConnAction() {
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final Integer run() {
            int n = PlatformDependent.isWindows() ? 200 : (PlatformDependent.isOsx() ? 128 : 4096);
            File file = new File("/proc/sys/net/core/somaxconn");
            BufferedReader bufferedReader = null;
            if (file.exists()) {
                bufferedReader = new BufferedReader(new InputStreamReader(new BoundedInputStream(new FileInputStream(file))));
                n = Integer.parseInt(bufferedReader.readLine());
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: {}", (Object)file, (Object)n);
                }
            } else {
                Integer n2 = null;
                if (SystemPropertyUtil.getBoolean("io.netty.net.somaxconn.trySysctl", false) && ((n2 = NetUtil.sysctlGetInt("kern.ipc.somaxconn")) != null || (n2 = NetUtil.sysctlGetInt("kern.ipc.soacceptqueue")) != null)) {
                    n = n2;
                }
                if (n2 == null) {
                    logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", (Object)file, (Object)n);
                }
            }
            if (bufferedReader == null) return n;
            try {
                bufferedReader.close();
                return n;
            }
            catch (Exception exception) {}
            return n;
            catch (Exception exception) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to get SOMAXCONN from sysctl and file {}. Default: {}", file, n, exception);
                    }
                    if (bufferedReader == null) return n;
                }
                catch (Throwable throwable) {
                    if (bufferedReader == null) throw throwable;
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                    return n;
                }
                catch (Exception exception3) {}
                return n;
            }
        }
    }
}

