/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ResourceLeak;
import io.netty.util.ResourceLeakHint;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ResourceLeakDetector<T> {
    private static final String PROP_LEVEL_OLD = "io.netty.leakDetectionLevel";
    private static final String PROP_LEVEL = "io.netty.leakDetection.level";
    private static final Level DEFAULT_LEVEL;
    private static final String PROP_TARGET_RECORDS = "io.netty.leakDetection.targetRecords";
    private static final int DEFAULT_TARGET_RECORDS = 4;
    private static final String PROP_SAMPLING_INTERVAL = "io.netty.leakDetection.samplingInterval";
    private static final int DEFAULT_SAMPLING_INTERVAL = 128;
    private static final int TARGET_RECORDS;
    static final int SAMPLING_INTERVAL;
    private static Level level;
    private static final InternalLogger logger;
    private final Set<DefaultResourceLeak<?>> allLeaks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final Set<String> reportedLeaks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String resourceType;
    private final int samplingInterval;
    private volatile LeakListener leakListener;
    private static final AtomicReference<String[]> excludedMethods;

    @Deprecated
    public static void setEnabled(boolean bl) {
        ResourceLeakDetector.setLevel(bl ? Level.SIMPLE : Level.DISABLED);
    }

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > Level.DISABLED.ordinal();
    }

    public static void setLevel(Level level) {
        ResourceLeakDetector.level = ObjectUtil.checkNotNull(level, "level");
    }

    public static Level getLevel() {
        return level;
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> clazz) {
        this(StringUtil.simpleClassName(clazz));
    }

    @Deprecated
    public ResourceLeakDetector(String string) {
        this(string, 128, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> clazz, int n, long l) {
        this(clazz, n);
    }

    public ResourceLeakDetector(Class<?> clazz, int n) {
        this(StringUtil.simpleClassName(clazz), n, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(String string, int n, long l) {
        this.resourceType = ObjectUtil.checkNotNull(string, "resourceType");
        this.samplingInterval = n;
    }

    @Deprecated
    public final ResourceLeak open(T t) {
        return this.track0(t, false);
    }

    public final ResourceLeakTracker<T> track(T t) {
        return this.track0(t, false);
    }

    public ResourceLeakTracker<T> trackForcibly(T t) {
        return this.track0(t, true);
    }

    private DefaultResourceLeak track0(T t, boolean bl) {
        Level level = ResourceLeakDetector.level;
        if (bl || level == Level.PARANOID || level != Level.DISABLED && PlatformDependent.threadLocalRandom().nextInt(this.samplingInterval) == 0) {
            this.reportLeak();
            ResourceLeakDetector resourceLeakDetector = this;
            return new DefaultResourceLeak(t, this.refQueue, this.allLeaks, resourceLeakDetector.getInitialHint(resourceLeakDetector.resourceType));
        }
        return null;
    }

    private void clearRefQueue() {
        DefaultResourceLeak defaultResourceLeak;
        while ((defaultResourceLeak = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            defaultResourceLeak.dispose();
        }
    }

    protected boolean needReport() {
        return logger.isErrorEnabled();
    }

    private void reportLeak() {
        Object object;
        if (!this.needReport()) {
            this.clearRefQueue();
            return;
        }
        while ((object = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            LeakListener leakListener;
            if (!((DefaultResourceLeak)object).dispose() || !this.reportedLeaks.add((String)(object = ((DefaultResourceLeak)object).getReportAndClearRecords()))) continue;
            if (((String)object).isEmpty()) {
                ResourceLeakDetector resourceLeakDetector = this;
                resourceLeakDetector.reportUntracedLeak(resourceLeakDetector.resourceType);
            } else {
                ResourceLeakDetector resourceLeakDetector = this;
                resourceLeakDetector.reportTracedLeak(resourceLeakDetector.resourceType, (String)object);
            }
            if ((leakListener = this.leakListener) == null) continue;
            leakListener.onLeak(this.resourceType, (String)object);
        }
    }

    protected void reportTracedLeak(String string, String string2) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See https://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)string, (Object)string2);
    }

    protected void reportUntracedLeak(String string) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See https://netty.io/wiki/reference-counted-objects.html for more information.", string, PROP_LEVEL, Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    @Deprecated
    protected void reportInstancesLeak(String string) {
    }

    protected Object getInitialHint(String string) {
        return null;
    }

    public void setLeakListener(LeakListener leakListener) {
        this.leakListener = leakListener;
    }

    public static void addExclusions(Class clazz, String ... stringArray) {
        String[] stringArray2;
        Method method;
        int n;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        Object[] objectArray = clazz.getDeclaredMethods();
        int n2 = objectArray.length;
        for (n = 0; !(n >= n2 || hashSet.remove((method = objectArray[n]).getName()) && hashSet.isEmpty()); ++n) {
        }
        if (!hashSet.isEmpty()) {
            throw new IllegalArgumentException("Can't find '" + hashSet + "' in " + clazz.getName());
        }
        do {
            objectArray = excludedMethods.get();
            stringArray2 = Arrays.copyOf(objectArray, objectArray.length + 2 * stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[objectArray.length + (n << 1)] = clazz.getName();
                stringArray2[objectArray.length + (n << 1) + 1] = stringArray[n];
            }
        } while (!excludedMethods.compareAndSet((String[])objectArray, stringArray2));
    }

    static {
        boolean bl;
        DEFAULT_LEVEL = Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("io.netty.noResourceLeakDetection") != null) {
            bl = SystemPropertyUtil.getBoolean("io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)bl);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)PROP_LEVEL, (Object)Level.DISABLED.name().toLowerCase());
        } else {
            bl = false;
        }
        Object object = bl ? Level.DISABLED : DEFAULT_LEVEL;
        object = SystemPropertyUtil.get(PROP_LEVEL_OLD, ((Enum)object).name());
        object = SystemPropertyUtil.get(PROP_LEVEL, (String)object);
        object = Level.parseLevel((String)object);
        TARGET_RECORDS = SystemPropertyUtil.getInt(PROP_TARGET_RECORDS, 4);
        SAMPLING_INTERVAL = SystemPropertyUtil.getInt(PROP_SAMPLING_INTERVAL, 128);
        level = object;
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_LEVEL, (Object)((Enum)object).name().toLowerCase());
            logger.debug("-D{}: {}", (Object)PROP_TARGET_RECORDS, (Object)TARGET_RECORDS);
        }
        excludedMethods = new AtomicReference<String[]>(EmptyArrays.EMPTY_STRINGS);
    }

    private static class TraceRecord
    extends Throwable {
        private static final long serialVersionUID = 6065153674892850720L;
        private static final TraceRecord BOTTOM = new TraceRecord(){
            private static final long serialVersionUID = 7396077602074694571L;

            @Override
            public final Throwable fillInStackTrace() {
                return this;
            }
        };
        private final String hintString;
        private final TraceRecord next;
        private final int pos;

        TraceRecord(TraceRecord traceRecord, Object object) {
            this.hintString = object instanceof ResourceLeakHint ? ((ResourceLeakHint)object).toHintString() : object.toString();
            this.next = traceRecord;
            this.pos = traceRecord.pos + 1;
        }

        TraceRecord(TraceRecord traceRecord) {
            this.hintString = null;
            this.next = traceRecord;
            this.pos = traceRecord.pos + 1;
        }

        private TraceRecord() {
            this.hintString = null;
            this.next = null;
            this.pos = -1;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(2048);
            if (this.hintString != null) {
                stringBuilder.append("\tHint: ").append(this.hintString).append(StringUtil.NEWLINE);
            }
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            block0: for (int i = 3; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                String[] stringArray = (String[])excludedMethods.get();
                for (int j = 0; j < stringArray.length; j += 2) {
                    if (stringArray[j].equals(stackTraceElement.getClassName()) && stringArray[j + 1].equals(stackTraceElement.getMethodName())) continue block0;
                }
                stringBuilder.append('\t');
                stringBuilder.append(stackTraceElement.toString());
                stringBuilder.append(StringUtil.NEWLINE);
            }
            return stringBuilder.toString();
        }
    }

    private static final class DefaultResourceLeak<T>
    extends WeakReference<Object>
    implements ResourceLeak,
    ResourceLeakTracker<T> {
        private static final AtomicReferenceFieldUpdater<DefaultResourceLeak<?>, TraceRecord> headUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultResourceLeak.class, TraceRecord.class, "head");
        private static final AtomicIntegerFieldUpdater<DefaultResourceLeak<?>> droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultResourceLeak.class, "droppedRecords");
        private volatile TraceRecord head;
        private volatile int droppedRecords;
        private final Set<DefaultResourceLeak<?>> allLeaks;
        private final int trackedHash;

        DefaultResourceLeak(Object object, ReferenceQueue<Object> referenceQueue, Set<DefaultResourceLeak<?>> set, Object object2) {
            super(object, referenceQueue);
            assert (object != null);
            this.allLeaks = set;
            this.trackedHash = System.identityHashCode(object);
            set.add(this);
            headUpdater.set(this, object2 == null ? new TraceRecord(TraceRecord.BOTTOM) : new TraceRecord(TraceRecord.BOTTOM, object2));
        }

        @Override
        public final void record() {
            this.record0(null);
        }

        @Override
        public final void record(Object object) {
            this.record0(object);
        }

        private void record0(Object object) {
            if (TARGET_RECORDS > 0) {
                int n;
                TraceRecord traceRecord;
                TraceRecord traceRecord2;
                do {
                    traceRecord = traceRecord2 = headUpdater.get(this);
                    if (traceRecord2 == null) {
                        return;
                    }
                    n = traceRecord2.pos + 1;
                    if (n >= TARGET_RECORDS) {
                        n = Math.min(n - TARGET_RECORDS, 30);
                        n = PlatformDependent.threadLocalRandom().nextInt(1 << n) != 0 ? 1 : 0;
                        if (n == 0) continue;
                        traceRecord = traceRecord2.next;
                        continue;
                    }
                    n = 0;
                } while (!headUpdater.compareAndSet(this, traceRecord2, traceRecord = object != null ? new TraceRecord(traceRecord, object) : new TraceRecord(traceRecord)));
                if (n != 0) {
                    droppedRecordsUpdater.incrementAndGet(this);
                }
            }
        }

        final boolean dispose() {
            this.clear();
            return this.allLeaks.remove(this);
        }

        @Override
        public final boolean close() {
            if (this.allLeaks.remove(this)) {
                this.clear();
                headUpdater.set(this, null);
                return true;
            }
            return false;
        }

        @Override
        public final boolean close(T t) {
            assert (this.trackedHash == System.identityHashCode(t));
            try {
                boolean bl = this.close();
                return bl;
            }
            finally {
                DefaultResourceLeak.reachabilityFence0(t);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private static void reachabilityFence0(Object object) {
            if (object == null) return;
            // MONITORENTER : object
            // MONITOREXIT : object
        }

        public final String toString() {
            TraceRecord traceRecord = headUpdater.get(this);
            return this.generateReport(traceRecord);
        }

        final String getReportAndClearRecords() {
            TraceRecord traceRecord = headUpdater.getAndSet(this, null);
            return this.generateReport(traceRecord);
        }

        private String generateReport(TraceRecord traceRecord) {
            if (traceRecord == null) {
                return "";
            }
            int n = droppedRecordsUpdater.get(this);
            int n2 = 0;
            int n3 = traceRecord.pos + 1;
            StringBuilder stringBuilder = new StringBuilder(n3 << 11).append(StringUtil.NEWLINE);
            stringBuilder.append("Recent access records: ").append(StringUtil.NEWLINE);
            int n4 = 1;
            HashSet<String> hashSet = new HashSet<String>(n3);
            while (traceRecord != TraceRecord.BOTTOM) {
                String string = traceRecord.toString();
                if (hashSet.add(string)) {
                    if (traceRecord.next == TraceRecord.BOTTOM) {
                        stringBuilder.append("Created at:").append(StringUtil.NEWLINE).append(string);
                    } else {
                        stringBuilder.append('#').append(n4++).append(':').append(StringUtil.NEWLINE).append(string);
                    }
                } else {
                    ++n2;
                }
                traceRecord = traceRecord.next;
            }
            if (n2 > 0) {
                stringBuilder.append(": ").append(n2).append(" leak records were discarded because they were duplicates").append(StringUtil.NEWLINE);
            }
            if (n > 0) {
                stringBuilder.append(": ").append(n).append(" leak records were discarded because the leak record count is targeted to ").append(TARGET_RECORDS).append(". Use system property io.netty.leakDetection.targetRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setLength(stringBuilder2.length() - StringUtil.NEWLINE.length());
            return stringBuilder.toString();
        }
    }

    public static interface LeakListener {
        public void onLeak(String var1, String var2);
    }

    public static enum Level {
        DISABLED,
        SIMPLE,
        ADVANCED,
        PARANOID;


        static Level parseLevel(String string) {
            string = string.trim();
            for (Level level : Level.values()) {
                if (!string.equalsIgnoreCase(level.name()) && !string.equals(String.valueOf(level.ordinal()))) continue;
                return level;
            }
            return DEFAULT_LEVEL;
        }
    }
}

