/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ScheduledFutureTask;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import io.netty.util.concurrent.ThreadProperties;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadExecutorMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class SingleThreadEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    static final int DEFAULT_MAX_PENDING_EXECUTOR_TASKS = Math.max(16, SystemPropertyUtil.getInt("io.netty.eventexecutor.maxPendingTasks", Integer.MAX_VALUE));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final int ST_NOT_STARTED = 1;
    private static final int ST_STARTED = 2;
    private static final int ST_SHUTTING_DOWN = 3;
    private static final int ST_SHUTDOWN = 4;
    private static final int ST_TERMINATED = 5;
    private static final Runnable NOOP_TASK = new Runnable(){

        @Override
        public final void run() {
        }
    };
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "state");
    private static final AtomicReferenceFieldUpdater<SingleThreadEventExecutor, ThreadProperties> PROPERTIES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SingleThreadEventExecutor.class, ThreadProperties.class, "threadProperties");
    private final Queue<Runnable> taskQueue;
    private volatile Thread thread;
    private volatile ThreadProperties threadProperties;
    private final Executor executor;
    private volatile boolean interrupted;
    private final CountDownLatch threadLock = new CountDownLatch(1);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private final int maxPendingTasks;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, ThreadFactory threadFactory, boolean bl) {
        this(eventExecutorGroup, new ThreadPerTaskExecutor(threadFactory), bl);
    }

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, ThreadFactory threadFactory, boolean bl, int n, RejectedExecutionHandler rejectedExecutionHandler) {
        this(eventExecutorGroup, (Executor)new ThreadPerTaskExecutor(threadFactory), bl, n, rejectedExecutionHandler);
    }

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, Executor executor, boolean bl) {
        this(eventExecutorGroup, executor, bl, DEFAULT_MAX_PENDING_EXECUTOR_TASKS, RejectedExecutionHandlers.reject());
    }

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, Executor executor, boolean bl, int n, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventExecutorGroup);
        this.addTaskWakesUp = bl;
        this.maxPendingTasks = Math.max(16, n);
        this.executor = ThreadExecutorMap.apply(executor, (EventExecutor)this);
        this.taskQueue = this.newTaskQueue(this.maxPendingTasks);
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedExecutionHandler, "rejectedHandler");
    }

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, Executor executor, boolean bl, Queue<Runnable> queue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventExecutorGroup);
        this.addTaskWakesUp = bl;
        this.maxPendingTasks = DEFAULT_MAX_PENDING_EXECUTOR_TASKS;
        this.executor = ThreadExecutorMap.apply(executor, (EventExecutor)this);
        this.taskQueue = ObjectUtil.checkNotNull(queue, "taskQueue");
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedExecutionHandler, "rejectedHandler");
    }

    @Deprecated
    protected Queue<Runnable> newTaskQueue() {
        SingleThreadEventExecutor singleThreadEventExecutor = this;
        return singleThreadEventExecutor.newTaskQueue(singleThreadEventExecutor.maxPendingTasks);
    }

    protected Queue<Runnable> newTaskQueue(int n) {
        return new LinkedBlockingQueue<Runnable>(n);
    }

    protected void interruptThread() {
        Thread thread = this.thread;
        if (thread == null) {
            this.interrupted = true;
            return;
        }
        thread.interrupt();
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        return SingleThreadEventExecutor.pollTaskFrom(this.taskQueue);
    }

    protected static Runnable pollTaskFrom(Queue<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) == WAKEUP_TASK) {
        }
        return runnable;
    }

    protected Runnable takeTask() {
        Runnable runnable;
        assert (this.inEventLoop());
        if (!(this.taskQueue instanceof BlockingQueue)) {
            throw new UnsupportedOperationException();
        }
        BlockingQueue blockingQueue = (BlockingQueue)this.taskQueue;
        do {
            if ((runnable = this.peekScheduledTask()) == null) {
                Runnable runnable2 = null;
                try {
                    runnable2 = (Runnable)blockingQueue.take();
                    if (runnable2 == WAKEUP_TASK) {
                        runnable2 = null;
                    }
                }
                catch (InterruptedException interruptedException) {}
                return runnable2;
            }
            long l = runnable.delayNanos();
            runnable = null;
            if (l > 0L) {
                try {
                    runnable = (Runnable)blockingQueue.poll(l, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (runnable != null) continue;
            this.fetchFromScheduledTaskQueue();
            runnable = (Runnable)blockingQueue.poll();
        } while (runnable == null);
        if (runnable == WAKEUP_TASK) {
            return null;
        }
        return runnable;
    }

    private boolean fetchFromScheduledTaskQueue() {
        Runnable runnable;
        if (this.scheduledTaskQueue == null || this.scheduledTaskQueue.isEmpty()) {
            return true;
        }
        long l = this.getCurrentTimeNanos();
        do {
            if ((runnable = this.pollScheduledTask(l)) != null) continue;
            return true;
        } while (this.taskQueue.offer(runnable));
        this.scheduledTaskQueue.add((ScheduledFutureTask)runnable);
        return false;
    }

    private boolean executeExpiredScheduledTasks() {
        if (this.scheduledTaskQueue == null || this.scheduledTaskQueue.isEmpty()) {
            return false;
        }
        long l = this.getCurrentTimeNanos();
        Runnable runnable = this.pollScheduledTask(l);
        if (runnable == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(runnable);
        } while ((runnable = this.pollScheduledTask(l)) != null);
        return true;
    }

    protected Runnable peekTask() {
        assert (this.inEventLoop());
        return this.taskQueue.peek();
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    public int pendingTasks() {
        return this.taskQueue.size();
    }

    protected void addTask(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "task");
        if (!this.offerTask(runnable)) {
            this.reject(runnable);
        }
    }

    final boolean offerTask(Runnable runnable) {
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        return this.taskQueue.offer(runnable);
    }

    protected boolean removeTask(Runnable runnable) {
        return this.taskQueue.remove(ObjectUtil.checkNotNull(runnable, "task"));
    }

    protected boolean runAllTasks() {
        boolean bl;
        assert (this.inEventLoop());
        boolean bl2 = false;
        do {
            bl = this.fetchFromScheduledTaskQueue();
            SingleThreadEventExecutor singleThreadEventExecutor = this;
            if (!singleThreadEventExecutor.runAllTasksFrom(singleThreadEventExecutor.taskQueue)) continue;
            bl2 = true;
        } while (!bl);
        if (bl2) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        return bl2;
    }

    protected final boolean runScheduledAndExecutorTasks(int n) {
        SingleThreadEventExecutor singleThreadEventExecutor;
        boolean bl;
        assert (this.inEventLoop());
        int n2 = 0;
        do {
            singleThreadEventExecutor = this;
        } while ((bl = singleThreadEventExecutor.runExistingTasksFrom(singleThreadEventExecutor.taskQueue) | this.executeExpiredScheduledTasks()) && ++n2 < n);
        if (n2 > 0) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        return n2 > 0;
    }

    protected final boolean runAllTasksFrom(Queue<Runnable> queue) {
        Runnable runnable = SingleThreadEventExecutor.pollTaskFrom(queue);
        if (runnable == null) {
            return false;
        }
        do {
            SingleThreadEventExecutor.safeExecute(runnable);
        } while ((runnable = SingleThreadEventExecutor.pollTaskFrom(queue)) != null);
        return true;
    }

    private boolean runExistingTasksFrom(Queue<Runnable> queue) {
        Runnable runnable = SingleThreadEventExecutor.pollTaskFrom(queue);
        if (runnable == null) {
            return false;
        }
        int n = Math.min(this.maxPendingTasks, queue.size());
        SingleThreadEventExecutor.safeExecute(runnable);
        while (n-- > 0 && (runnable = queue.poll()) != null) {
            SingleThreadEventExecutor.safeExecute(runnable);
        }
        return true;
    }

    protected boolean runAllTasks(long l) {
        long l2;
        block2: {
            this.fetchFromScheduledTaskQueue();
            Runnable runnable = this.pollTask();
            if (runnable == null) {
                this.afterRunningAllTasks();
                return false;
            }
            long l3 = l > 0L ? this.getCurrentTimeNanos() + l : 0L;
            long l4 = 0L;
            do {
                SingleThreadEventExecutor.safeExecute(runnable);
                if ((++l4 & 0x3FL) == 0L && (l2 = this.getCurrentTimeNanos()) >= l3) break block2;
            } while ((runnable = this.pollTask()) != null);
            l2 = this.getCurrentTimeNanos();
        }
        this.afterRunningAllTasks();
        this.lastExecutionTime = l2;
        return true;
    }

    protected void afterRunningAllTasks() {
    }

    protected long delayNanos(long l) {
        l -= SingleThreadEventExecutor.initialNanoTime();
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask == null) {
            return SCHEDULE_PURGE_INTERVAL;
        }
        return scheduledFutureTask.delayNanos(l);
    }

    protected long deadlineNanos() {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask == null) {
            return this.getCurrentTimeNanos() + SCHEDULE_PURGE_INTERVAL;
        }
        return scheduledFutureTask.deadlineNanos();
    }

    protected void updateLastExecutionTime() {
        this.lastExecutionTime = this.getCurrentTimeNanos();
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean bl) {
        if (!bl) {
            this.taskQueue.offer(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    public void addShutdownHook(final Runnable runnable) {
        if (this.inEventLoop()) {
            this.shutdownHooks.add(runnable);
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                SingleThreadEventExecutor.this.shutdownHooks.add(runnable);
            }
        });
    }

    public void removeShutdownHook(final Runnable runnable) {
        if (this.inEventLoop()) {
            this.shutdownHooks.remove(runnable);
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                SingleThreadEventExecutor.this.shutdownHooks.remove(runnable);
            }
        });
    }

    private boolean runShutdownHooks() {
        boolean bl = false;
        while (!this.shutdownHooks.isEmpty()) {
            Object object = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            object = object.iterator();
            while (object.hasNext()) {
                Runnable runnable = (Runnable)object.next();
                try {
                    SingleThreadEventExecutor.runTask(runnable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    logger.warn("Shutdown hook raised an exception.", throwable);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.lastExecutionTime = this.getCurrentTimeNanos();
        }
        return bl;
    }

    @Override
    public Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
        boolean bl;
        int n;
        int n2;
        ObjectUtil.checkPositiveOrZero(l, "quietPeriod");
        if (l2 < l) {
            throw new IllegalArgumentException("timeout: " + l2 + " (expected >= quietPeriod (" + l + "))");
        }
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (this.isShuttingDown()) {
            return this.terminationFuture();
        }
        boolean bl2 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return this.terminationFuture();
            }
            bl = true;
            n2 = this.state;
            if (bl2) {
                n = 3;
                continue;
            }
            switch (n2) {
                case 1: 
                case 2: {
                    n = 3;
                    break;
                }
                default: {
                    n = n2;
                    bl = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n2, n));
        this.gracefulShutdownQuietPeriod = timeUnit.toNanos(l);
        this.gracefulShutdownTimeout = timeUnit.toNanos(l2);
        if (this.ensureThreadStarted(n2)) {
            return this.terminationFuture;
        }
        if (bl) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(bl2);
            }
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        boolean bl;
        int n;
        int n2;
        if (this.isShutdown()) {
            return;
        }
        boolean bl2 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return;
            }
            bl = true;
            n2 = this.state;
            if (bl2) {
                n = 4;
                continue;
            }
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    n = 4;
                    break;
                }
                default: {
                    n = n2;
                    bl = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n2, n));
        if (this.ensureThreadStarted(n2)) {
            return;
        }
        if (bl) {
            this.taskQueue.offer(WAKEUP_TASK);
            if (!this.addTaskWakesUp) {
                this.wakeup(bl2);
            }
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.state >= 3;
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 5;
    }

    protected boolean confirmShutdown() {
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelScheduledTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = this.getCurrentTimeNanos();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            if (this.gracefulShutdownQuietPeriod == 0L) {
                return true;
            }
            this.taskQueue.offer(WAKEUP_TASK);
            return false;
        }
        long l = this.getCurrentTimeNanos();
        if (this.isShutdown() || l - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (l - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.taskQueue.offer(WAKEUP_TASK);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        this.threadLock.await(l, timeUnit);
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable runnable) {
        this.execute0(runnable);
    }

    @Override
    public void lazyExecute(Runnable runnable) {
        this.lazyExecute0(runnable);
    }

    private void execute0(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "task");
        this.execute(runnable, this.wakesUpForTask(runnable));
    }

    private void lazyExecute0(Runnable runnable) {
        this.execute(ObjectUtil.checkNotNull(runnable, "task"), false);
    }

    private void execute(Runnable runnable, boolean bl) {
        boolean bl2 = this.inEventLoop();
        this.addTask(runnable);
        if (!bl2) {
            this.startThread();
            if (this.isShutdown()) {
                boolean bl3 = false;
                try {
                    if (this.removeTask(runnable)) {
                        bl3 = true;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                if (bl3) {
                    SingleThreadEventExecutor.reject();
                }
            }
        }
        if (!this.addTaskWakesUp && bl) {
            this.wakeup(bl2);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection, l, timeUnit);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection, l, timeUnit);
    }

    private void throwIfInEventLoop(String string) {
        if (this.inEventLoop()) {
            throw new RejectedExecutionException("Calling " + string + " from within the EventLoop is not allowed");
        }
    }

    public final ThreadProperties threadProperties() {
        Object object = this.threadProperties;
        if (object == null) {
            object = this.thread;
            if (object == null) {
                assert (!this.inEventLoop());
                this.submit(NOOP_TASK).syncUninterruptibly();
                object = this.thread;
                assert (object != null);
            }
            if (!PROPERTIES_UPDATER.compareAndSet(this, null, (ThreadProperties)(object = new DefaultThreadProperties((Thread)object)))) {
                object = this.threadProperties;
            }
        }
        return object;
    }

    protected boolean wakesUpForTask(Runnable runnable) {
        return true;
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    protected final void reject(Runnable runnable) {
        this.rejectedExecutionHandler.rejected(runnable, this);
    }

    private void startThread() {
        if (this.state == 1 && STATE_UPDATER.compareAndSet(this, 1, 2)) {
            try {
                this.doStartThread();
                return;
            }
            catch (Throwable throwable) {
                STATE_UPDATER.compareAndSet(this, 2, 1);
                throw throwable;
            }
        }
    }

    private boolean ensureThreadStarted(int n) {
        if (n == 1) {
            try {
                this.doStartThread();
            }
            catch (Throwable throwable) {
                STATE_UPDATER.set(this, 5);
                this.terminationFuture.tryFailure(throwable);
                if (!(throwable instanceof Exception)) {
                    PlatformDependent.throwException(throwable);
                }
                return true;
            }
        }
        return false;
    }

    private void doStartThread() {
        assert (this.thread == null);
        this.executor.execute(new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                int n;
                SingleThreadEventExecutor.this.thread = Thread.currentThread();
                if (SingleThreadEventExecutor.this.interrupted) {
                    SingleThreadEventExecutor.this.thread.interrupt();
                }
                Throwable throwable = null;
                SingleThreadEventExecutor.this.updateLastExecutionTime();
                SingleThreadEventExecutor.this.run();
                while ((n = SingleThreadEventExecutor.this.state) < 3 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n, 3)) {
                }
                if (SingleThreadEventExecutor.this.gracefulShutdownStartTime == 0L && logger.isErrorEnabled()) {
                    logger.error("Buggy " + EventExecutor.class.getSimpleName() + " implementation; " + SingleThreadEventExecutor.class.getSimpleName() + ".confirmShutdown() must be called before run() implementation terminates.");
                }
                try {
                    while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                    }
                    while ((n = SingleThreadEventExecutor.this.state) < 4 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n, 4)) {
                    }
                    SingleThreadEventExecutor.this.confirmShutdown();
                }
                finally {
                    try {
                        SingleThreadEventExecutor.this.cleanup();
                    }
                    finally {
                        FastThreadLocal.removeAll();
                        STATE_UPDATER.set(SingleThreadEventExecutor.this, 5);
                        SingleThreadEventExecutor.this.threadLock.countDown();
                        n = SingleThreadEventExecutor.this.drainTasks();
                        if (n > 0 && logger.isWarnEnabled()) {
                            logger.warn("An event executor terminated with non-empty task queue (" + n + ')');
                        }
                        SingleThreadEventExecutor.this.terminationFuture.setSuccess(null);
                    }
                }
                return;
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        logger.warn("Unexpected exception from an event executor: ", throwable3);
                    }
                    catch (Throwable throwable4) {}
                    finally {
                        int n2;
                        while ((n2 = SingleThreadEventExecutor.this.state) < 3 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n2, 3)) {
                        }
                        while (!SingleThreadEventExecutor.this.confirmShutdown()) {
                        }
                        while ((n2 = SingleThreadEventExecutor.this.state) < 4 && !STATE_UPDATER.compareAndSet(SingleThreadEventExecutor.this, n2, 4)) {
                        }
                        SingleThreadEventExecutor.this.confirmShutdown();
                    }
                }
            }
        });
    }

    final int drainTasks() {
        Runnable runnable;
        int n = 0;
        while ((runnable = this.taskQueue.poll()) != null) {
            if (WAKEUP_TASK == runnable) continue;
            ++n;
        }
        return n;
    }

    private static final class DefaultThreadProperties
    implements ThreadProperties {
        private final Thread t;

        DefaultThreadProperties(Thread thread) {
            this.t = thread;
        }

        @Override
        public final Thread.State state() {
            return this.t.getState();
        }

        @Override
        public final int priority() {
            return this.t.getPriority();
        }

        @Override
        public final boolean isInterrupted() {
            return this.t.isInterrupted();
        }

        @Override
        public final boolean isDaemon() {
            return this.t.isDaemon();
        }

        @Override
        public final String name() {
            return this.t.getName();
        }

        @Override
        public final long id() {
            return this.t.getId();
        }

        @Override
        public final StackTraceElement[] stackTrace() {
            return this.t.getStackTrace();
        }

        @Override
        public final boolean isAlive() {
            return this.t.isAlive();
        }
    }

    @Deprecated
    protected static interface NonWakeupRunnable
    extends AbstractEventExecutor.LazyRunnable {
    }
}

