/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class DefaultPriorityQueue<T extends PriorityQueueNode>
extends AbstractQueue<T>
implements PriorityQueue<T> {
    private static final PriorityQueueNode[] EMPTY_ARRAY = new PriorityQueueNode[0];
    private final Comparator<T> comparator;
    private T[] queue;
    private int size;

    public DefaultPriorityQueue(Comparator<T> comparator, int n) {
        this.comparator = ObjectUtil.checkNotNull(comparator, "comparator");
        this.queue = n != 0 ? new PriorityQueueNode[n] : EMPTY_ARRAY;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final boolean contains(Object object) {
        if (!(object instanceof PriorityQueueNode)) {
            return false;
        }
        Object object2 = object = (PriorityQueueNode)object;
        return this.contains((PriorityQueueNode)object2, object2.priorityQueueIndex(this));
    }

    @Override
    public final boolean containsTyped(T t) {
        T t2 = t;
        return this.contains((PriorityQueueNode)t2, t2.priorityQueueIndex(this));
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.size; ++i) {
            T t = this.queue[i];
            if (t == null) continue;
            t.priorityQueueIndex(this, -1);
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public final void clearIgnoringIndexes() {
        this.size = 0;
    }

    @Override
    public final boolean offer(T t) {
        if (t.priorityQueueIndex(this) != -1) {
            throw new IllegalArgumentException("e.priorityQueueIndex(): " + t.priorityQueueIndex(this) + " (expected: -1" + ") + e: " + t);
        }
        if (this.size >= this.queue.length) {
            this.queue = (PriorityQueueNode[])Arrays.copyOf(this.queue, this.queue.length + (this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1));
        }
        DefaultPriorityQueue defaultPriorityQueue = this;
        defaultPriorityQueue.bubbleUp(defaultPriorityQueue.size++, t);
        return true;
    }

    @Override
    public final T poll() {
        if (this.size == 0) {
            return null;
        }
        T t = this.queue[0];
        t.priorityQueueIndex(this, -1);
        T t2 = this.queue[--this.size];
        this.queue[this.size] = null;
        if (this.size != 0) {
            this.bubbleDown(0, t2);
        }
        return t;
    }

    @Override
    public final T peek() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    @Override
    public final boolean remove(Object object) {
        try {
            object = (PriorityQueueNode)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.removeTyped((T)object);
    }

    @Override
    public final boolean removeTyped(T t) {
        int n = t.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)t, n)) {
            return false;
        }
        t.priorityQueueIndex(this, -1);
        if (--this.size == 0 || this.size == n) {
            this.queue[n] = null;
            return true;
        }
        T t2 = this.queue[n] = this.queue[this.size];
        this.queue[this.size] = null;
        if (this.comparator.compare(t, t2) < 0) {
            this.bubbleDown(n, t2);
        } else {
            this.bubbleUp(n, t2);
        }
        return true;
    }

    @Override
    public final void priorityChanged(T t) {
        int n;
        T t2;
        int n2 = t.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)t, n2)) {
            return;
        }
        if (n2 != 0 && this.comparator.compare(t, t2 = this.queue[n = n2 - 1 >>> 1]) < 0) {
            this.bubbleUp(n2, t);
            return;
        }
        this.bubbleDown(n2, t);
    }

    @Override
    public final Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public final <X> X[] toArray(X[] XArray) {
        if (XArray.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, XArray.getClass());
        }
        System.arraycopy(this.queue, 0, XArray, 0, this.size);
        if (XArray.length > this.size) {
            XArray[this.size] = null;
        }
        return XArray;
    }

    @Override
    public final Iterator<T> iterator() {
        return new PriorityQueueIterator();
    }

    private boolean contains(PriorityQueueNode priorityQueueNode, int n) {
        return n >= 0 && n < this.size && priorityQueueNode.equals(this.queue[n]);
    }

    private void bubbleDown(int n, T t) {
        int n2 = this.size >>> 1;
        while (n < n2) {
            int n3 = (n << 1) + 1;
            T t2 = this.queue[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && this.comparator.compare(t2, this.queue[n4]) > 0) {
                n3 = n4;
                t2 = this.queue[n3];
            }
            if (this.comparator.compare(t, t2) <= 0) break;
            this.queue[n] = t2;
            t2.priorityQueueIndex(this, n);
            n = n3;
        }
        this.queue[n] = t;
        t.priorityQueueIndex(this, n);
    }

    private void bubbleUp(int n, T t) {
        int n2;
        T t2;
        while (n > 0 && this.comparator.compare(t, t2 = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = t2;
            t2.priorityQueueIndex(this, n);
            n = n2;
        }
        this.queue[n] = t;
        t.priorityQueueIndex(this, n);
    }

    private final class PriorityQueueIterator
    implements Iterator<T> {
        private int index;

        private PriorityQueueIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.index < DefaultPriorityQueue.this.size;
        }

        @Override
        public final T next() {
            if (this.index >= DefaultPriorityQueue.this.size) {
                throw new NoSuchElementException();
            }
            return DefaultPriorityQueue.this.queue[this.index++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

