/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;

public final class SocketUtils {
    private static final Enumeration<Object> EMPTY = Collections.enumeration(Collections.emptyList());

    private SocketUtils() {
    }

    private static <T> Enumeration<T> empty() {
        return EMPTY;
    }

    public static void connect(Socket object, SocketAddress socketAddress, int n) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((Socket)object, socketAddress, n){
                final /* synthetic */ Socket val$socket;
                final /* synthetic */ SocketAddress val$remoteAddress;
                final /* synthetic */ int val$timeout;
                {
                    this.val$socket = socket;
                    this.val$remoteAddress = socketAddress;
                    this.val$timeout = n;
                }

                @Override
                public final Void run() {
                    this.val$socket.connect(this.val$remoteAddress, this.val$timeout);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(Socket object, SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((Socket)object, socketAddress){
                final /* synthetic */ Socket val$socket;
                final /* synthetic */ SocketAddress val$bindpoint;
                {
                    this.val$socket = socket;
                    this.val$bindpoint = socketAddress;
                }

                @Override
                public final Void run() {
                    this.val$socket.bind(this.val$bindpoint);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static boolean connect(SocketChannel object, SocketAddress socketAddress) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>((SocketChannel)object, socketAddress){
                final /* synthetic */ SocketChannel val$socketChannel;
                final /* synthetic */ SocketAddress val$remoteAddress;
                {
                    this.val$socketChannel = socketChannel;
                    this.val$remoteAddress = socketAddress;
                }

                @Override
                public final Boolean run() {
                    return this.val$socketChannel.connect(this.val$remoteAddress);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(SocketChannel object, SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((SocketChannel)object, socketAddress){
                final /* synthetic */ SocketChannel val$socketChannel;
                final /* synthetic */ SocketAddress val$address;
                {
                    this.val$socketChannel = socketChannel;
                    this.val$address = socketAddress;
                }

                @Override
                public final Void run() {
                    this.val$socketChannel.bind(this.val$address);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static SocketChannel accept(ServerSocketChannel object) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SocketChannel>((ServerSocketChannel)object){
                final /* synthetic */ ServerSocketChannel val$serverSocketChannel;
                {
                    this.val$serverSocketChannel = serverSocketChannel;
                }

                @Override
                public final SocketChannel run() {
                    return this.val$serverSocketChannel.accept();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(DatagramChannel object, SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((DatagramChannel)object, socketAddress){
                final /* synthetic */ DatagramChannel val$networkChannel;
                final /* synthetic */ SocketAddress val$address;
                {
                    this.val$networkChannel = datagramChannel;
                    this.val$address = socketAddress;
                }

                @Override
                public final Void run() {
                    this.val$networkChannel.bind(this.val$address);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static SocketAddress localSocketAddress(final ServerSocket serverSocket) {
        return AccessController.doPrivileged(new PrivilegedAction<SocketAddress>(){

            @Override
            public final SocketAddress run() {
                return serverSocket.getLocalSocketAddress();
            }
        });
    }

    public static InetAddress addressByName(String object) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>((String)object){
                final /* synthetic */ String val$hostname;
                {
                    this.val$hostname = string;
                }

                @Override
                public final InetAddress run() {
                    return InetAddress.getByName(this.val$hostname);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (UnknownHostException)privilegedActionException.getCause();
        }
    }

    public static InetAddress[] allAddressesByName(String object) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress[]>((String)object){
                final /* synthetic */ String val$hostname;
                {
                    this.val$hostname = string;
                }

                @Override
                public final InetAddress[] run() {
                    return InetAddress.getAllByName(this.val$hostname);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (UnknownHostException)privilegedActionException.getCause();
        }
    }

    public static InetSocketAddress socketAddress(final String string, final int n) {
        return AccessController.doPrivileged(new PrivilegedAction<InetSocketAddress>(){

            @Override
            public final InetSocketAddress run() {
                return new InetSocketAddress(string, n);
            }
        });
    }

    public static Enumeration<InetAddress> addressesFromNetworkInterface(NetworkInterface object) {
        if ((object = AccessController.doPrivileged(new PrivilegedAction<Enumeration<InetAddress>>((NetworkInterface)object){
            final /* synthetic */ NetworkInterface val$intf;
            {
                this.val$intf = networkInterface;
            }

            @Override
            public final Enumeration<InetAddress> run() {
                return this.val$intf.getInetAddresses();
            }
        })) == null) {
            return SocketUtils.empty();
        }
        return object;
    }

    public static InetAddress loopbackAddress() {
        return AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

            @Override
            public final InetAddress run() {
                if (PlatformDependent.javaVersion() >= 7) {
                    return InetAddress.getLoopbackAddress();
                }
                try {
                    return InetAddress.getByName(null);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IllegalStateException(unknownHostException);
                }
            }
        });
    }

    public static byte[] hardwareAddressFromNetworkInterface(NetworkInterface object) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>((NetworkInterface)object){
                final /* synthetic */ NetworkInterface val$intf;
                {
                    this.val$intf = networkInterface;
                }

                @Override
                public final byte[] run() {
                    return this.val$intf.getHardwareAddress();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException;
            throw (SocketException)privilegedActionException.getCause();
        }
    }
}

