/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslClientHelloHandler;
import io.netty.handler.ssl.SslHandshakeTimeoutException;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSniHandler<T>
extends SslClientHelloHandler<T> {
    protected final long handshakeTimeoutMillis;
    private ScheduledFuture<?> timeoutFuture;
    private String hostname;

    private static String extractSniHostname(ByteBuf object) {
        int n = object.readerIndex();
        int n2 = object.writerIndex();
        if (n2 - (n += 34) >= 6) {
            int n3 = object.getUnsignedByte(n);
            n += n3 + 1;
            n3 = object.getUnsignedShort(n);
            n += n3 + 2;
            n3 = object.getUnsignedByte(n);
            n += n3 + 1;
            n3 = object.getUnsignedShort(n);
            if ((n3 = (n += 2) + n3) <= n2) {
                while (n3 - n >= 4) {
                    int n4;
                    n2 = object.getUnsignedShort(n);
                    n += 2;
                    if (n3 - (n += 2) < (n4 = object.getUnsignedShort(n))) break;
                    if (n2 == 0) {
                        if (n3 - (n += 2) < 3) break;
                        n2 = object.getUnsignedByte(n);
                        ++n;
                        if (n2 != 0 || n3 - (n += 2) < (n2 = object.getUnsignedShort(n))) break;
                        object = object.toString(n, n2, CharsetUtil.US_ASCII);
                        return object.toLowerCase(Locale.US);
                    }
                    n += n4;
                }
            }
        }
        return null;
    }

    protected AbstractSniHandler(long l) {
        this(0, l);
    }

    protected AbstractSniHandler(int n, long l) {
        super(n);
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)l, (String)"handshakeTimeoutMillis");
    }

    public AbstractSniHandler() {
        this(0, 0L);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isActive()) {
            this.checkStartTimeout(channelHandlerContext);
        }
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.fireChannelActive();
        this.checkStartTimeout(channelHandlerContext);
    }

    private void checkStartTimeout(final ChannelHandlerContext channelHandlerContext) {
        if (this.handshakeTimeoutMillis <= 0L || this.timeoutFuture != null) {
            return;
        }
        this.timeoutFuture = channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (channelHandlerContext.channel().isActive()) {
                    SslHandshakeTimeoutException sslHandshakeTimeoutException = new SslHandshakeTimeoutException("handshake timed out after " + AbstractSniHandler.this.handshakeTimeoutMillis + "ms");
                    channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(sslHandshakeTimeoutException));
                    channelHandlerContext.close();
                }
            }
        }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    protected Future<T> lookup(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        this.hostname = byteBuf == null ? null : AbstractSniHandler.extractSniHostname(byteBuf);
        return this.lookup(channelHandlerContext, this.hostname);
    }

    @Override
    protected void onLookupComplete(ChannelHandlerContext channelHandlerContext, Future<T> future) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        try {
            this.onLookupComplete(channelHandlerContext, this.hostname, future);
            return;
        }
        finally {
            AbstractSniHandler.fireSniCompletionEvent(channelHandlerContext, this.hostname, future);
        }
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2);

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3);

    private static void fireSniCompletionEvent(ChannelHandlerContext channelHandlerContext, String string, Future<?> object) {
        if ((object = object.cause()) == null) {
            channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(string));
            return;
        }
        channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(string, (Throwable)object));
    }
}

