/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.conscrypt.AllocatedBuffer;
import org.conscrypt.BufferAllocator;
import org.conscrypt.Conscrypt;
import org.conscrypt.HandshakeListener;

abstract class ConscryptAlpnSslEngine
extends JdkSslEngine {
    private static final boolean USE_BUFFER_ALLOCATOR = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.conscrypt.useBufferAllocator", (boolean)true);

    static ConscryptAlpnSslEngine newClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ClientEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    static ConscryptAlpnSslEngine newServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ServerEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    private ConscryptAlpnSslEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, List<String> list) {
        super(sSLEngine);
        if (USE_BUFFER_ALLOCATOR) {
            Conscrypt.setBufferAllocator((SSLEngine)sSLEngine, (BufferAllocator)new BufferAllocatorAdapter(byteBufAllocator));
        }
        Conscrypt.setApplicationProtocols((SSLEngine)sSLEngine, (String[])list.toArray(EmptyArrays.EMPTY_STRINGS));
    }

    final int calculateOutNetBufSize(int n, int n2) {
        return this.calculateSpace(n, n2, Integer.MAX_VALUE);
    }

    final int calculateRequiredOutBufSpace(int n, int n2) {
        return this.calculateSpace(n, n2, Conscrypt.maxEncryptedPacketLength());
    }

    private int calculateSpace(int n, int n2, long l) {
        long l2 = (long)Conscrypt.maxSealOverhead((SSLEngine)this.getWrappedEngine()) * (long)n2;
        return (int)Math.min(l, (long)n + l2);
    }

    final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
        return Conscrypt.unwrap((SSLEngine)this.getWrappedEngine(), (ByteBuffer[])byteBufferArray, (ByteBuffer[])byteBufferArray2);
    }

    private static final class BufferAdapter
    extends AllocatedBuffer {
        private final ByteBuf nettyBuffer;
        private final ByteBuffer buffer;

        BufferAdapter(ByteBuf byteBuf) {
            this.nettyBuffer = byteBuf;
            this.buffer = byteBuf.nioBuffer(0, byteBuf.capacity());
        }

        public final ByteBuffer nioBuffer() {
            return this.buffer;
        }

        public final AllocatedBuffer retain() {
            this.nettyBuffer.retain();
            return this;
        }

        public final AllocatedBuffer release() {
            this.nettyBuffer.release();
            return this;
        }
    }

    private static final class BufferAllocatorAdapter
    extends BufferAllocator {
        private final ByteBufAllocator alloc;

        BufferAllocatorAdapter(ByteBufAllocator byteBufAllocator) {
            this.alloc = byteBufAllocator;
        }

        public final AllocatedBuffer allocateDirectBuffer(int n) {
            return new BufferAdapter(this.alloc.directBuffer(n));
        }
    }

    private static final class ServerEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector;

        ServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)sSLEngine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() {
                    ServerEngine.this.selectProtocol();
                }
            });
            this.protocolSelector = (JdkApplicationProtocolNegotiator.ProtocolSelector)ObjectUtil.checkNotNull((Object)jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())), (String)"protocolSelector");
        }

        private void selectProtocol() {
            try {
                String string = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
                this.protocolSelector.select(string != null ? Collections.singletonList(string) : Collections.emptyList());
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw SslUtils.toSSLHandshakeException(throwable);
            }
        }
    }

    private static final class ClientEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener;

        ClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)sSLEngine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() {
                    ClientEngine.this.selectProtocol();
                }
            });
            this.protocolListener = (JdkApplicationProtocolNegotiator.ProtocolSelectionListener)ObjectUtil.checkNotNull((Object)jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), (String)"protocolListener");
        }

        private void selectProtocol() {
            Object object = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
            try {
                this.protocolListener.selected((String)object);
                return;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw SslUtils.toSSLHandshakeException(throwable);
            }
        }
    }
}

