/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

final class JdkAlpnSslUtils {
    private static final InternalLogger logger;
    private static final Method SET_APPLICATION_PROTOCOLS;
    private static final Method GET_APPLICATION_PROTOCOL;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL;
    private static final Method SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;

    private JdkAlpnSslUtils() {
    }

    static boolean supportsAlpn() {
        return GET_APPLICATION_PROTOCOL != null;
    }

    static String getApplicationProtocol(SSLEngine object) {
        try {
            return (String)GET_APPLICATION_PROTOCOL.invoke(object, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static String getHandshakeApplicationProtocol(SSLEngine object) {
        try {
            return (String)GET_HANDSHAKE_APPLICATION_PROTOCOL.invoke(object, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static void setApplicationProtocols(SSLEngine object, List<String> stringArray) {
        SSLParameters sSLParameters = ((SSLEngine)object).getSSLParameters();
        stringArray = stringArray.toArray(EmptyArrays.EMPTY_STRINGS);
        try {
            SET_APPLICATION_PROTOCOLS.invoke((Object)sSLParameters, new Object[]{stringArray});
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        ((SSLEngine)object).setSSLParameters(sSLParameters);
    }

    static void setHandshakeApplicationProtocolSelector(SSLEngine object, BiFunction<SSLEngine, List<String>, String> biFunction) {
        try {
            SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke(object, biFunction);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(SSLEngine object) {
        try {
            return (BiFunction)GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke(object, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static {
        Method method;
        Method method2;
        Method method3;
        Method method4;
        Object object;
        logger = InternalLoggerFactory.getInstance(JdkAlpnSslUtils.class);
        try {
            object = SSLContext.getInstance("TLS");
            ((SSLContext)object).init(null, null, null);
            SSLEngine sSLEngine = ((SSLContext)object).createSSLEngine();
            object = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return SSLEngine.class.getMethod("getHandshakeApplicationProtocol", new Class[0]);
                }
            });
            ((Method)object).invoke((Object)sSLEngine, new Object[0]);
            method4 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
                }
            });
            method4.invoke((Object)sSLEngine, new Object[0]);
            method3 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
                }
            });
            method3.invoke((Object)sSLEngine.getSSLParameters(), new Object[]{EmptyArrays.EMPTY_STRINGS});
            method2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return SSLEngine.class.getMethod("setHandshakeApplicationProtocolSelector", BiFunction.class);
                }
            });
            method2.invoke((Object)sSLEngine, new BiFunction<SSLEngine, List<String>, String>(){

                @Override
                public final String apply(SSLEngine sSLEngine, List<String> list) {
                    return null;
                }
            });
            method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return SSLEngine.class.getMethod("getHandshakeApplicationProtocolSelector", new Class[0]);
                }
            });
            method.invoke((Object)sSLEngine, new Object[0]);
        }
        catch (Throwable throwable) {
            int n = PlatformDependent.javaVersion();
            if (n >= 9) {
                logger.error("Unable to initialize JdkAlpnSslUtils, but the detected java version was: {}", (Object)n, (Object)throwable);
            }
            object = null;
            method4 = null;
            method3 = null;
            method2 = null;
            method = null;
        }
        GET_HANDSHAKE_APPLICATION_PROTOCOL = object;
        GET_APPLICATION_PROTOCOL = method4;
        SET_APPLICATION_PROTOCOLS = method3;
        SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = method2;
        GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = method;
    }
}

