/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.internal.tcnative.SSL;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.EmptyArrays;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

final class OpenSslPrivateKey
extends AbstractReferenceCounted
implements PrivateKey {
    private long privateKeyAddress;

    OpenSslPrivateKey(long l) {
        this.privateKeyAddress = l;
    }

    @Override
    public final String getAlgorithm() {
        return "unknown";
    }

    @Override
    public final String getFormat() {
        return null;
    }

    @Override
    public final byte[] getEncoded() {
        return null;
    }

    private long privateKeyAddress() {
        if (this.refCnt() <= 0) {
            throw new IllegalReferenceCountException();
        }
        return this.privateKeyAddress;
    }

    protected final void deallocate() {
        SSL.freePrivateKey((long)this.privateKeyAddress);
        this.privateKeyAddress = 0L;
    }

    public final OpenSslPrivateKey retain() {
        super.retain();
        return this;
    }

    public final OpenSslPrivateKey retain(int n) {
        super.retain(n);
        return this;
    }

    public final OpenSslPrivateKey touch() {
        super.touch();
        return this;
    }

    public final OpenSslPrivateKey touch(Object object) {
        return this;
    }

    @Override
    public final void destroy() {
        OpenSslPrivateKey openSslPrivateKey = this;
        openSslPrivateKey.release(openSslPrivateKey.refCnt());
    }

    @Override
    public final boolean isDestroyed() {
        return this.refCnt() == 0;
    }

    final OpenSslKeyMaterial newKeyMaterial(long l, X509Certificate[] x509CertificateArray) {
        return new OpenSslPrivateKeyMaterial(l, x509CertificateArray);
    }

    final class OpenSslPrivateKeyMaterial
    extends AbstractReferenceCounted
    implements OpenSslKeyMaterial {
        long certificateChain;
        private final X509Certificate[] x509CertificateChain;

        OpenSslPrivateKeyMaterial(long l, X509Certificate[] x509CertificateArray) {
            this.certificateChain = l;
            this.x509CertificateChain = x509CertificateArray == null ? EmptyArrays.EMPTY_X509_CERTIFICATES : x509CertificateArray;
            OpenSslPrivateKey.this.retain();
        }

        @Override
        public final X509Certificate[] certificateChain() {
            return (X509Certificate[])this.x509CertificateChain.clone();
        }

        @Override
        public final long certificateChainAddress() {
            if (this.refCnt() <= 0) {
                throw new IllegalReferenceCountException();
            }
            return this.certificateChain;
        }

        @Override
        public final long privateKeyAddress() {
            if (this.refCnt() <= 0) {
                throw new IllegalReferenceCountException();
            }
            return OpenSslPrivateKey.this.privateKeyAddress();
        }

        @Override
        public final OpenSslKeyMaterial touch(Object object) {
            OpenSslPrivateKey.this.touch(object);
            return this;
        }

        @Override
        public final OpenSslKeyMaterial retain() {
            super.retain();
            return this;
        }

        @Override
        public final OpenSslKeyMaterial retain(int n) {
            super.retain(n);
            return this;
        }

        @Override
        public final OpenSslKeyMaterial touch() {
            OpenSslPrivateKey.this.touch();
            return this;
        }

        protected final void deallocate() {
            this.releaseChain();
            OpenSslPrivateKey.this.release();
        }

        private void releaseChain() {
            SSL.freeX509Chain((long)this.certificateChain);
            this.certificateChain = 0L;
        }
    }
}

