/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslPrivateKey;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.internal.tcnative.SSL;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;

public final class OpenSslX509KeyManagerFactory
extends KeyManagerFactory {
    private final OpenSslKeyManagerFactorySpi spi;

    public OpenSslX509KeyManagerFactory() {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(null));
    }

    public OpenSslX509KeyManagerFactory(Provider provider) {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(provider));
    }

    public OpenSslX509KeyManagerFactory(String string, Provider provider) {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(string, provider));
    }

    private OpenSslX509KeyManagerFactory(OpenSslKeyManagerFactorySpi openSslKeyManagerFactorySpi) {
        OpenSslKeyManagerFactorySpi openSslKeyManagerFactorySpi2 = openSslKeyManagerFactorySpi;
        super(openSslKeyManagerFactorySpi2, openSslKeyManagerFactorySpi2.kmf.getProvider(), openSslKeyManagerFactorySpi.kmf.getAlgorithm());
        this.spi = openSslKeyManagerFactorySpi;
    }

    private static OpenSslKeyManagerFactorySpi newOpenSslKeyManagerFactorySpi(Provider provider) {
        try {
            return OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(null, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    private static OpenSslKeyManagerFactorySpi newOpenSslKeyManagerFactorySpi(String string, Provider provider) {
        if (string == null) {
            string = KeyManagerFactory.getDefaultAlgorithm();
        }
        return new OpenSslKeyManagerFactorySpi(provider == null ? KeyManagerFactory.getInstance(string) : KeyManagerFactory.getInstance(string, provider));
    }

    final OpenSslKeyMaterialProvider newProvider() {
        return this.spi.newProvider();
    }

    public static OpenSslX509KeyManagerFactory newEngineBased(File file, String string) {
        return OpenSslX509KeyManagerFactory.newEngineBased(SslContext.toX509Certificates(file), string);
    }

    public static OpenSslX509KeyManagerFactory newEngineBased(X509Certificate[] object, String string) {
        ObjectUtil.checkNotNull((Object)object, (String)"certificateChain");
        object = new OpenSslKeyStore((X509Certificate[])object.clone(), false);
        object.load(null, null);
        OpenSslX509KeyManagerFactory openSslX509KeyManagerFactory = new OpenSslX509KeyManagerFactory();
        openSslX509KeyManagerFactory.init((KeyStore)object, string == null ? null : string.toCharArray());
        return openSslX509KeyManagerFactory;
    }

    public static OpenSslX509KeyManagerFactory newKeyless(File file) {
        return OpenSslX509KeyManagerFactory.newKeyless(SslContext.toX509Certificates(file));
    }

    public static OpenSslX509KeyManagerFactory newKeyless(InputStream inputStream) {
        return OpenSslX509KeyManagerFactory.newKeyless(SslContext.toX509Certificates(inputStream));
    }

    public static OpenSslX509KeyManagerFactory newKeyless(X509Certificate ... object) {
        ObjectUtil.checkNotNull((Object)object, (String)"certificateChain");
        object = new OpenSslKeyStore((X509Certificate[])object.clone(), true);
        object.load(null, null);
        OpenSslX509KeyManagerFactory openSslX509KeyManagerFactory = new OpenSslX509KeyManagerFactory();
        openSslX509KeyManagerFactory.init((KeyStore)object, null);
        return openSslX509KeyManagerFactory;
    }

    private static final class OpenSslKeyStore
    extends KeyStore {
        private OpenSslKeyStore(final X509Certificate[] x509CertificateArray, final boolean bl) {
            super(new KeyStoreSpi(){
                private final Date creationDate = new Date();

                @Override
                public Key engineGetKey(String string, char[] object) {
                    if (this.engineContainsAlias(string)) {
                        long l;
                        if (bl) {
                            l = 0L;
                        } else {
                            try {
                                l = SSL.loadPrivateKeyFromEngine((String)string, (String)(object == null ? null : new String((char[])object)));
                            }
                            catch (Exception exception) {
                                UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Unable to load key from engine");
                                object = unrecoverableKeyException;
                                unrecoverableKeyException.initCause(exception);
                                throw object;
                            }
                        }
                        return new OpenSslPrivateKey(l);
                    }
                    return null;
                }

                @Override
                public Certificate[] engineGetCertificateChain(String string) {
                    if (this.engineContainsAlias(string)) {
                        return (X509Certificate[])x509CertificateArray.clone();
                    }
                    return null;
                }

                @Override
                public Certificate engineGetCertificate(String string) {
                    if (this.engineContainsAlias(string)) {
                        return x509CertificateArray[0];
                    }
                    return null;
                }

                @Override
                public Date engineGetCreationDate(String string) {
                    if (this.engineContainsAlias(string)) {
                        return this.creationDate;
                    }
                    return null;
                }

                @Override
                public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) {
                    throw new KeyStoreException("Not supported");
                }

                @Override
                public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) {
                    throw new KeyStoreException("Not supported");
                }

                @Override
                public void engineSetCertificateEntry(String string, Certificate certificate) {
                    throw new KeyStoreException("Not supported");
                }

                @Override
                public void engineDeleteEntry(String string) {
                    throw new KeyStoreException("Not supported");
                }

                @Override
                public Enumeration<String> engineAliases() {
                    return Collections.enumeration(Collections.singleton("key"));
                }

                @Override
                public boolean engineContainsAlias(String string) {
                    return "key".equals(string);
                }

                @Override
                public int engineSize() {
                    return 1;
                }

                @Override
                public boolean engineIsKeyEntry(String string) {
                    return this.engineContainsAlias(string);
                }

                @Override
                public boolean engineIsCertificateEntry(String string) {
                    return this.engineContainsAlias(string);
                }

                @Override
                public String engineGetCertificateAlias(Certificate certificate) {
                    if (certificate instanceof X509Certificate) {
                        X509Certificate[] x509CertificateArray2 = x509CertificateArray;
                        int n = x509CertificateArray.length;
                        for (int i = 0; i < n; ++i) {
                            X509Certificate x509Certificate = x509CertificateArray2[i];
                            if (!x509Certificate.equals(certificate)) continue;
                            return "key";
                        }
                    }
                    return null;
                }

                @Override
                public void engineStore(OutputStream outputStream, char[] cArray) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void engineLoad(InputStream inputStream, char[] cArray) {
                    if (inputStream != null && cArray != null) {
                        throw new UnsupportedOperationException();
                    }
                }
            }, null, "native");
            OpenSsl.ensureAvailability();
        }
    }

    private static final class OpenSslKeyManagerFactorySpi
    extends KeyManagerFactorySpi {
        final KeyManagerFactory kmf;
        private volatile ProviderFactory providerFactory;

        OpenSslKeyManagerFactorySpi(KeyManagerFactory keyManagerFactory) {
            this.kmf = (KeyManagerFactory)ObjectUtil.checkNotNull((Object)keyManagerFactory, (String)"kmf");
        }

        @Override
        protected final synchronized void engineInit(KeyStore keyStore, char[] cArray) {
            if (this.providerFactory != null) {
                throw new KeyStoreException("Already initialized");
            }
            if (!keyStore.aliases().hasMoreElements()) {
                throw new KeyStoreException("No aliases found");
            }
            this.kmf.init(keyStore, cArray);
            this.providerFactory = new ProviderFactory(ReferenceCountedOpenSslContext.chooseX509KeyManager(this.kmf.getKeyManagers()), OpenSslKeyManagerFactorySpi.password(cArray), Collections.list(keyStore.aliases()));
        }

        private static String password(char[] cArray) {
            if (cArray == null || cArray.length == 0) {
                return null;
            }
            return new String(cArray);
        }

        @Override
        protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            throw new InvalidAlgorithmParameterException("Not supported");
        }

        @Override
        protected final KeyManager[] engineGetKeyManagers() {
            ProviderFactory providerFactory = this.providerFactory;
            if (providerFactory == null) {
                throw new IllegalStateException("engineInit(...) not called yet");
            }
            return new KeyManager[]{providerFactory.keyManager};
        }

        final OpenSslKeyMaterialProvider newProvider() {
            ProviderFactory providerFactory = this.providerFactory;
            if (providerFactory == null) {
                throw new IllegalStateException("engineInit(...) not called yet");
            }
            return providerFactory.newProvider();
        }

        private static final class ProviderFactory {
            private final X509KeyManager keyManager;
            private final String password;
            private final Iterable<String> aliases;

            ProviderFactory(X509KeyManager x509KeyManager, String string, Iterable<String> iterable) {
                this.keyManager = x509KeyManager;
                this.password = string;
                this.aliases = iterable;
            }

            final OpenSslKeyMaterialProvider newProvider() {
                return new OpenSslPopulatedKeyMaterialProvider(this.keyManager, this.password, this.aliases);
            }

            private static final class OpenSslPopulatedKeyMaterialProvider
            extends OpenSslKeyMaterialProvider {
                private final Map<String, Object> materialMap = new HashMap<String, Object>();

                OpenSslPopulatedKeyMaterialProvider(X509KeyManager object, String string2, Iterable<String> iterable) {
                    super((X509KeyManager)object, string2);
                    try {
                        for (String string2 : iterable) {
                            if (string2 == null || this.materialMap.containsKey(string2)) continue;
                            try {
                                this.materialMap.put(string2, super.chooseKeyMaterial((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, string2));
                            }
                            catch (Exception exception) {
                                this.materialMap.put(string2, exception);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.destroy();
                        throw throwable;
                    }
                    ObjectUtil.checkNonEmpty(this.materialMap, (String)"materialMap");
                }

                @Override
                final OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator object, String string) {
                    object = this.materialMap.get(string);
                    if (object == null) {
                        return null;
                    }
                    if (object instanceof OpenSslKeyMaterial) {
                        return ((OpenSslKeyMaterial)object).retain();
                    }
                    throw (Exception)object;
                }

                @Override
                final void destroy() {
                    for (Object object : this.materialMap.values()) {
                        ReferenceCountUtil.release((Object)object);
                    }
                    this.materialMap.clear();
                }
            }
        }
    }
}

