/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.header;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;

public final class KotlinClassHeader {
    private final Kind kind;
    private final JvmMetadataVersion metadataVersion;
    private final String[] data;
    private final String[] incompatibleData;
    private final String[] strings;
    private final String extraString;
    private final int extraInt;
    private final String packageName;
    private final byte[] serializedIr;

    public KotlinClassHeader(Kind kind, JvmMetadataVersion jvmMetadataVersion, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int n, String string2, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        this.kind = kind;
        this.metadataVersion = jvmMetadataVersion;
        this.data = stringArray;
        this.incompatibleData = stringArray2;
        this.strings = stringArray3;
        this.extraString = string;
        this.extraInt = n;
        this.packageName = string2;
        this.serializedIr = byArray;
    }

    public final Kind getKind() {
        return this.kind;
    }

    public final JvmMetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    public final String[] getData() {
        return this.data;
    }

    public final String[] getIncompatibleData() {
        return this.incompatibleData;
    }

    public final String[] getStrings() {
        return this.strings;
    }

    public final String getMultifileClassName() {
        String string = this.extraString;
        if (this.kind == Kind.MULTIFILE_CLASS_PART) {
            return string;
        }
        return null;
    }

    public final List<String> getMultifilePartNames() {
        Object[] objectArray = this.data;
        Object object = this.kind == Kind.MULTIFILE_CLASS ? objectArray : null;
        List list = object != null ? ArraysKt.asList((Object[])object) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isUnstableJvmIrBinary() {
        KotlinClassHeader kotlinClassHeader = this;
        if (kotlinClassHeader.has(kotlinClassHeader.extraInt, 16)) {
            KotlinClassHeader kotlinClassHeader2 = this;
            if (!kotlinClassHeader2.has(kotlinClassHeader2.extraInt, 32)) {
                return true;
            }
        }
        return false;
    }

    public final boolean isPreRelease() {
        KotlinClassHeader kotlinClassHeader = this;
        return kotlinClassHeader.has(kotlinClassHeader.extraInt, 2);
    }

    public final String toString() {
        return (Object)((Object)this.kind) + " version=" + this.metadataVersion;
    }

    private final boolean has(int n, int n2) {
        return (n & n2) != 0;
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final Companion Companion;
        private final int id;
        private static final Map<Integer, Kind> entryById;
        public static final /* enum */ Kind UNKNOWN;
        public static final /* enum */ Kind CLASS;
        public static final /* enum */ Kind FILE_FACADE;
        public static final /* enum */ Kind SYNTHETIC_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS_PART;
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Kind(int n2) {
            this.id = n2;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }

        private static final /* synthetic */ Kind[] $values() {
            Kind[] kindArray = new Kind[6];
            Kind[] kindArray2 = kindArray;
            kindArray[0] = UNKNOWN;
            kindArray2[1] = CLASS;
            kindArray2[2] = FILE_FACADE;
            kindArray2[3] = SYNTHETIC_CLASS;
            kindArray2[4] = MULTIFILE_CLASS;
            kindArray2[5] = MULTIFILE_CLASS_PART;
            return kindArray2;
        }

        @JvmStatic
        public static final Kind getById(int n) {
            return Companion.getById(n);
        }

        static {
            UNKNOWN = new Kind(0);
            CLASS = new Kind(1);
            FILE_FACADE = new Kind(2);
            SYNTHETIC_CLASS = new Kind(3);
            MULTIFILE_CLASS = new Kind(4);
            MULTIFILE_CLASS_PART = new Kind(5);
            $VALUES = Kind.$values();
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Kind[] kindArray = Kind.values();
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kindArray.length), (int)16);
            Map map = new LinkedHashMap(n);
            int n2 = kindArray.length;
            for (int i = 0; i < n2; ++i) {
                Kind kind;
                Kind kind2 = kind = kindArray[i];
                Map map2 = map;
                map2.put(kind2.id, kind);
            }
            entryById = map;
        }

        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            public final Kind getById(int n) {
                Kind kind = (Kind)((Object)entryById.get(n));
                if (kind == null) {
                    kind = UNKNOWN;
                }
                return kind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }
}

