/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import java.util.NoSuchElementException;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.Utf8;

class LiteralByteString
extends ByteString {
    protected final byte[] bytes;
    private int hash = 0;

    LiteralByteString(byte[] byArray) {
        this.bytes = byArray;
    }

    public byte byteAt(int n) {
        return this.bytes[n];
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, n, byArray, n2, n3);
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n, int n2) {
        outputStream.write(this.bytes, this.getOffsetIntoBytes() + n, n2);
    }

    @Override
    public String toString(String string) {
        return new String(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size(), string);
    }

    @Override
    public boolean isValidUtf8() {
        int n;
        int n2 = n = this.getOffsetIntoBytes();
        return Utf8.isValidUtf8(this.bytes, n2, n2 + ((ByteString)this).size());
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = n2 = this.getOffsetIntoBytes() + n2;
        return Utf8.partialIsValidUtf8(n, this.bytes, n4, n4 + n3);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        if (((ByteString)this).size() != ((ByteString)object).size()) {
            return false;
        }
        if (((ByteString)this).size() == 0) {
            return true;
        }
        if (object instanceof LiteralByteString) {
            return this.equalsRange((LiteralByteString)object, 0, ((ByteString)this).size());
        }
        if (object instanceof RopeByteString) {
            return object.equals(this);
        }
        object = String.valueOf(String.valueOf(object.getClass()));
        throw new IllegalArgumentException(new StringBuilder(49 + ((String)object).length()).append("Has a new type of ByteString been created? Found ").append((String)object).toString());
    }

    boolean equalsRange(LiteralByteString literalByteString, int n, int n2) {
        if (n2 > ((ByteString)literalByteString).size()) {
            int n3 = ((ByteString)this).size();
            throw new IllegalArgumentException(new StringBuilder(40).append("Length too large: ").append(n2).append(n3).toString());
        }
        if (n + n2 > ((ByteString)literalByteString).size()) {
            int n4 = ((ByteString)literalByteString).size();
            throw new IllegalArgumentException(new StringBuilder(59).append("Ran off end of other: ").append(n).append(", ").append(n2).append(", ").append(n4).toString());
        }
        byte[] byArray = this.bytes;
        byte[] byArray2 = literalByteString.bytes;
        int n5 = this.getOffsetIntoBytes() + n2;
        n2 = this.getOffsetIntoBytes();
        int n6 = literalByteString.getOffsetIntoBytes() + n;
        while (n2 < n5) {
            if (byArray[n2] != byArray2[n6]) {
                return false;
            }
            ++n2;
            ++n6;
        }
        return true;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            n = ((ByteString)this).size();
            if ((n = this.partialHash(n, 0, n)) == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        return LiteralByteString.hashCode(n, this.bytes, this.getOffsetIntoBytes() + n2, n3);
    }

    static int hashCode(int n, byte[] byArray, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            n = n * 31 + byArray[i];
        }
        return n;
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this);
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new LiteralByteIterator();
    }

    @Override
    protected int getTreeDepth() {
        return 0;
    }

    @Override
    protected boolean isBalanced() {
        return true;
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }

    private class LiteralByteIterator
    implements ByteString.ByteIterator {
        private int position = 0;
        private final int limit;

        private LiteralByteIterator() {
            this.limit = ((ByteString)LiteralByteString.this).size();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.limit;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            try {
                return LiteralByteString.this.bytes[this.position++];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NoSuchElementException(arrayIndexOutOfBoundsException.getMessage());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

