/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;

public interface Http2Headers
extends Headers<CharSequence, CharSequence, Http2Headers> {
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator();

    public Iterator<CharSequence> valueIterator(CharSequence var1);

    public Http2Headers method(CharSequence var1);

    public Http2Headers scheme(CharSequence var1);

    public Http2Headers authority(CharSequence var1);

    public Http2Headers path(CharSequence var1);

    public Http2Headers status(CharSequence var1);

    public CharSequence method();

    public CharSequence scheme();

    public CharSequence authority();

    public CharSequence path();

    public CharSequence status();

    public boolean contains(CharSequence var1, CharSequence var2, boolean var3);

    public static enum PseudoHeaderName {
        METHOD(":method", true),
        SCHEME(":scheme", true),
        AUTHORITY(":authority", true),
        PATH(":path", true),
        STATUS(":status", false),
        PROTOCOL(":protocol", true);

        private static final char PSEUDO_HEADER_PREFIX = ':';
        private static final byte PSEUDO_HEADER_PREFIX_BYTE = 58;
        private final AsciiString value;
        private final boolean requestOnly;

        private PseudoHeaderName(String string2, boolean bl) {
            this.value = AsciiString.cached((String)string2);
            this.requestOnly = bl;
        }

        public final AsciiString value() {
            return this.value;
        }

        public static boolean hasPseudoHeaderFormat(CharSequence charSequence) {
            if (charSequence instanceof AsciiString) {
                return (charSequence = (AsciiString)charSequence).length() > 0 && charSequence.byteAt(0) == 58;
            }
            return charSequence.length() > 0 && charSequence.charAt(0) == ':';
        }

        public static boolean isPseudoHeader(CharSequence charSequence) {
            return PseudoHeaderName.getPseudoHeader(charSequence) != null;
        }

        public static boolean isPseudoHeader(AsciiString asciiString) {
            return PseudoHeaderName.getPseudoHeader(asciiString) != null;
        }

        public static boolean isPseudoHeader(String string) {
            return PseudoHeaderName.getPseudoHeader(string) != null;
        }

        public static PseudoHeaderName getPseudoHeader(CharSequence charSequence) {
            if (charSequence instanceof AsciiString) {
                return PseudoHeaderName.getPseudoHeader((AsciiString)charSequence);
            }
            return PseudoHeaderName.getPseudoHeaderName(charSequence);
        }

        private static PseudoHeaderName getPseudoHeaderName(CharSequence charSequence) {
            int n = charSequence.length();
            if (n > 0 && charSequence.charAt(0) == ':') {
                switch (n) {
                    case 5: {
                        if (":path".contentEquals(charSequence)) {
                            return PATH;
                        }
                        return null;
                    }
                    case 7: {
                        if (":method" == charSequence) {
                            return METHOD;
                        }
                        if (":scheme" == charSequence) {
                            return SCHEME;
                        }
                        if (":status" == charSequence) {
                            return STATUS;
                        }
                        if (":method".contentEquals(charSequence)) {
                            return METHOD;
                        }
                        if (":scheme".contentEquals(charSequence)) {
                            return SCHEME;
                        }
                        if (":status".contentEquals(charSequence)) {
                            return STATUS;
                        }
                        return null;
                    }
                    case 9: {
                        if (":protocol".contentEquals(charSequence)) {
                            return PROTOCOL;
                        }
                        return null;
                    }
                    case 10: {
                        if (":authority".contentEquals(charSequence)) {
                            return AUTHORITY;
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        public static PseudoHeaderName getPseudoHeader(AsciiString asciiString) {
            int n = asciiString.length();
            if (n > 0 && asciiString.charAt(0) == ':') {
                switch (n) {
                    case 5: {
                        if (PATH.value().equals((Object)asciiString)) {
                            return PATH;
                        }
                        return null;
                    }
                    case 7: {
                        if (asciiString == METHOD.value()) {
                            return METHOD;
                        }
                        if (asciiString == SCHEME.value()) {
                            return SCHEME;
                        }
                        if (asciiString == STATUS.value()) {
                            return STATUS;
                        }
                        if (METHOD.value().equals((Object)asciiString)) {
                            return METHOD;
                        }
                        if (SCHEME.value().equals((Object)asciiString)) {
                            return SCHEME;
                        }
                        if (STATUS.value().equals((Object)asciiString)) {
                            return STATUS;
                        }
                        return null;
                    }
                    case 9: {
                        if (PROTOCOL.value().equals((Object)asciiString)) {
                            return PROTOCOL;
                        }
                        return null;
                    }
                    case 10: {
                        if (AUTHORITY.value().equals((Object)asciiString)) {
                            return AUTHORITY;
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        public final boolean isRequestOnly() {
            return this.requestOnly;
        }
    }
}

