/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DecoratingHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2MaxRstFrameListener;
import io.netty.util.internal.ObjectUtil;

final class Http2MaxRstFrameDecoder
extends DecoratingHttp2ConnectionDecoder {
    private final int maxRstFramesPerWindow;
    private final int secondsPerWindow;

    Http2MaxRstFrameDecoder(Http2ConnectionDecoder http2ConnectionDecoder, int n, int n2) {
        super(http2ConnectionDecoder);
        this.maxRstFramesPerWindow = ObjectUtil.checkPositive((int)n, (String)"maxRstFramesPerWindow");
        this.secondsPerWindow = ObjectUtil.checkPositive((int)n2, (String)"secondsPerWindow");
    }

    @Override
    public final void frameListener(Http2FrameListener http2FrameListener) {
        if (http2FrameListener != null) {
            super.frameListener(new Http2MaxRstFrameListener(http2FrameListener, this.maxRstFramesPerWindow, this.secondsPerWindow));
            return;
        }
        super.frameListener(null);
    }

    @Override
    public final Http2FrameListener frameListener() {
        Http2FrameListener http2FrameListener = this.frameListener0();
        if (http2FrameListener instanceof Http2MaxRstFrameListener) {
            return ((Http2MaxRstFrameListener)http2FrameListener).listener;
        }
        return http2FrameListener;
    }

    final Http2FrameListener frameListener0() {
        return super.frameListener();
    }
}

