/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class DataPacketExtension
implements ExtensionElement {
    public static final String ELEMENT = "data";
    public static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final QName QNAME = new QName("http://jabber.org/protocol/ibb", "data");
    private final String sessionID;
    private final UInt16 seq;
    private final String data;
    private byte[] decodedData;

    public DataPacketExtension(String string, int n, String string2) {
        this(string, UInt16.from((int)n), string2);
    }

    public DataPacketExtension(String string, UInt16 uInt16, String string2) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("Session ID must not be null or empty");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        this.sessionID = string;
        this.seq = (UInt16)Objects.requireNonNull((Object)uInt16);
        this.data = string2;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public UInt16 getSeq() {
        return this.seq;
    }

    public String getData() {
        return this.data;
    }

    public byte[] getDecodedData() {
        if (this.decodedData != null) {
            return this.decodedData;
        }
        if (this.data.matches(".*={1,2}+.+")) {
            return null;
        }
        this.decodedData = Base64.decode((String)this.data);
        return this.decodedData;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        xmlEnvironment = this.getIQChildElementBuilder(new IQ.IQChildElementXmlStringBuilder((ExtensionElement)this, xmlEnvironment));
        xmlEnvironment.closeElement((NamedElement)this);
        return xmlEnvironment;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.attribute("seq", (CharSequence)this.seq);
        iQChildElementXmlStringBuilder.attribute("sid", this.sessionID);
        iQChildElementXmlStringBuilder.rightAngleBracket();
        iQChildElementXmlStringBuilder.append((CharSequence)this.data);
        return iQChildElementXmlStringBuilder;
    }
}

