/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.stringencoder.Base32;
import org.jivesoftware.smack.util.stringencoder.StringEncoder;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private static final Logger LOGGER = Logger.getLogger(SimpleDirectoryPersistentCache.class.getName());
    private final File cacheDir;
    private final StringEncoder<String> filenameEncoder;

    public SimpleDirectoryPersistentCache(File file) {
        this(file, (StringEncoder<String>)Base32.getStringEncoder());
    }

    public SimpleDirectoryPersistentCache(File file, StringEncoder<String> stringEncoder) {
        if (!file.exists()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" is not a directory");
        }
        this.cacheDir = file;
        this.filenameEncoder = stringEncoder;
    }

    @Override
    public void addDiscoverInfoByNodePersistent(String object, DiscoverInfo discoverInfo) {
        object = this.getFileFor((String)object);
        try {
            if (((File)object).createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile((File)object, discoverInfo);
            }
            return;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to write disco info to file", iOException);
            return;
        }
    }

    @Override
    public DiscoverInfo lookup(String object) {
        if (!((File)(object = this.getFileFor((String)object))).isFile()) {
            return null;
        }
        DiscoverInfo discoverInfo = null;
        try {
            discoverInfo = SimpleDirectoryPersistentCache.restoreInfoFromFile((File)object);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Coud not restore info from file", exception);
        }
        return discoverInfo;
    }

    private File getFileFor(String string) {
        string = this.filenameEncoder.encode((Object)string);
        return new File(this.cacheDir, string);
    }

    @Override
    public void emptyCache() {
        File[] fileArray = this.cacheDir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            file.delete();
        }
    }

    private static void writeInfoToFile(File object, DiscoverInfo discoverInfo) {
        object = new DataOutputStream(new FileOutputStream((File)object));
        try {
            ((DataOutputStream)object).writeUTF(discoverInfo.toXML().toString());
            return;
        }
        finally {
            ((FilterOutputStream)object).close();
        }
    }

    private static DiscoverInfo restoreInfoFromFile(File object) {
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream((File)object));){
            object = dataInputStream.readUTF();
        }
        if (object == null) {
            return null;
        }
        return (DiscoverInfo)PacketParserUtils.parseStanza((String)object);
    }
}

