/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleContentTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.JingleTransportInitiationCallback;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.JingleS5BTransportManager;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;

public class JingleS5BTransportSession
extends JingleTransportSession<JingleS5BTransport> {
    private static final Logger LOGGER = Logger.getLogger(JingleS5BTransportSession.class.getName());
    private JingleTransportInitiationCallback callback;
    private UsedCandidate ourChoice;
    private UsedCandidate theirChoice;
    private static final UsedCandidate CANDIDATE_FAILURE = new UsedCandidate(null, null, null);

    public JingleS5BTransportSession(JingleSession jingleSession) {
        super(jingleSession);
    }

    @Override
    public JingleS5BTransport createTransport() {
        if (this.ourProposal == null) {
            this.ourProposal = this.createTransport(JingleManager.randomId(), Bytestream.Mode.tcp);
        }
        return (JingleS5BTransport)this.ourProposal;
    }

    @Override
    public void setTheirProposal(JingleContentTransport jingleContentTransport) {
        this.theirProposal = (JingleS5BTransport)jingleContentTransport;
    }

    public JingleS5BTransport createTransport(String object, Bytestream.Mode object2) {
        object = JingleS5BTransport.getBuilder().setStreamId((String)object).setMode((Bytestream.Mode)((Object)object2)).setDestinationAddress(Socks5Utils.createDigest((String)object, (i)this.jingleSession.getLocal(), (i)this.jingleSession.getRemote()));
        if (JingleS5BTransportManager.isUseLocalCandidates()) {
            for (Bytestream.StreamHost object32 : this.transportManager().getLocalStreamHosts()) {
                ((JingleS5BTransport.Builder)object).addTransportCandidate(new JingleS5BTransportCandidate(object32, 100, JingleS5BTransportCandidate.Type.direct));
            }
        }
        object2 = Collections.emptyList();
        if (JingleS5BTransportManager.isUseExternalCandidates()) {
            try {
                object2 = this.transportManager().getAvailableStreamHosts();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                LOGGER.log(Level.WARNING, "Could not determine available StreamHosts.", throwable);
            }
        }
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object2 = (Bytestream.StreamHost)iterator.next();
            ((JingleS5BTransport.Builder)object).addTransportCandidate(new JingleS5BTransportCandidate((Bytestream.StreamHost)object2, 0, JingleS5BTransportCandidate.Type.proxy));
        }
        return ((JingleS5BTransport.Builder)object).build();
    }

    public void setTheirTransport(JingleContentTransport jingleContentTransport) {
        this.theirProposal = (JingleS5BTransport)jingleContentTransport;
    }

    @Override
    public void initiateOutgoingSession(JingleTransportInitiationCallback jingleTransportInitiationCallback) {
        this.callback = jingleTransportInitiationCallback;
        this.initiateSession();
    }

    @Override
    public void initiateIncomingSession(JingleTransportInitiationCallback jingleTransportInitiationCallback) {
        this.callback = jingleTransportInitiationCallback;
        this.initiateSession();
    }

    private void initiateSession() {
        Socks5Proxy.getSocks5Proxy().addTransfer(this.createTransport().getDestinationAddress());
        Object object = this.jingleSession.getContents().get(0);
        JingleS5BTransportSession jingleS5BTransportSession = this;
        UsedCandidate usedCandidate = jingleS5BTransportSession.chooseFromProposedCandidates((JingleS5BTransport)jingleS5BTransportSession.theirProposal);
        if (usedCandidate == null) {
            this.ourChoice = CANDIDATE_FAILURE;
            object = this.transportManager().createCandidateError(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), object.getSenders(), object.getCreator(), object.getName(), ((JingleS5BTransport)this.theirProposal).getStreamId());
            try {
                this.jingleSession.getConnection().sendStanza((Stanza)object);
            }
            catch (InterruptedException | SmackException.NotConnectedException throwable) {
                LOGGER.log(Level.WARNING, "Could not send candidate-error.", throwable);
            }
        } else {
            this.ourChoice = usedCandidate;
            object = this.transportManager().createCandidateUsed(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), object.getSenders(), object.getCreator(), object.getName(), ((JingleS5BTransport)this.theirProposal).getStreamId(), this.ourChoice.candidate.getCandidateId());
            try {
                this.jingleSession.getConnection().createStanzaCollectorAndSend((IQ)object).nextResultOrThrow();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                LOGGER.log(Level.WARNING, "Could not send candidate-used.", throwable);
            }
        }
        this.connectIfReady();
    }

    private UsedCandidate chooseFromProposedCandidates(JingleS5BTransport object) {
        for (JingleContentTransportCandidate jingleContentTransportCandidate : ((JingleContentTransport)object).getCandidates()) {
            jingleContentTransportCandidate = (JingleS5BTransportCandidate)jingleContentTransportCandidate;
            try {
                return this.connectToTheirCandidate((JingleS5BTransportCandidate)jingleContentTransportCandidate);
            }
            catch (IOException | InterruptedException | TimeoutException | SmackException | XMPPException throwable) {
                LOGGER.log(Level.WARNING, "Could not connect to " + ((JingleS5BTransportCandidate)jingleContentTransportCandidate).getHost(), throwable);
            }
        }
        LOGGER.log(Level.WARNING, "Failed to connect to any candidate.");
        return null;
    }

    private UsedCandidate connectToTheirCandidate(JingleS5BTransportCandidate jingleS5BTransportCandidate) {
        Object object = jingleS5BTransportCandidate.getStreamHost();
        InetAddress inetAddress = ((Bytestream.StreamHost)object).getAddress().asInetAddress();
        object = new Socks5Client((Bytestream.StreamHost)object, ((JingleS5BTransport)this.theirProposal).getDestinationAddress());
        object = ((Socks5Client)object).getSocket(10000);
        LOGGER.log(Level.INFO, "Connected to their StreamHost " + inetAddress + " using dstAddr " + ((JingleS5BTransport)this.theirProposal).getDestinationAddress());
        return new UsedCandidate((JingleS5BTransport)this.theirProposal, jingleS5BTransportCandidate, (Socket)object);
    }

    private UsedCandidate connectToOurCandidate(JingleS5BTransportCandidate jingleS5BTransportCandidate) {
        Object object = jingleS5BTransportCandidate.getStreamHost();
        InetAddress inetAddress = ((Bytestream.StreamHost)object).getAddress().asInetAddress();
        object = new Socks5ClientForInitiator((Bytestream.StreamHost)object, ((JingleS5BTransport)this.ourProposal).getDestinationAddress(), this.jingleSession.getConnection(), ((JingleS5BTransport)this.ourProposal).getStreamId(), (i)this.jingleSession.getRemote());
        object = ((Socks5Client)object).getSocket(10000);
        LOGGER.log(Level.INFO, "Connected to our StreamHost " + inetAddress + " using dstAddr " + ((JingleS5BTransport)this.ourProposal).getDestinationAddress());
        return new UsedCandidate((JingleS5BTransport)this.ourProposal, jingleS5BTransportCandidate, (Socket)object);
    }

    @Override
    public String getNamespace() {
        return "urn:xmpp:jingle:transports:s5b:1";
    }

    @Override
    public IQ handleTransportInfo(Jingle jingle) {
        Object object = (JingleS5BTransportInfo)jingle.getContents().get(0).getTransport().getInfo();
        switch (object.getElementName()) {
            case "candidate-used": {
                return this.handleCandidateUsed(jingle);
            }
            case "activated": {
                return this.handleCandidateActivate(jingle);
            }
            case "candidate-error": {
                return this.handleCandidateError(jingle);
            }
            case "proxy-error": {
                return this.handleProxyError(jingle);
            }
        }
        return IQ.createResultIQ((IQ)jingle);
    }

    public IQ handleCandidateUsed(Jingle jingle) {
        Object object = (JingleS5BTransportInfo)jingle.getContents().get(0).getTransport().getInfo();
        object = ((JingleS5BTransportInfo.CandidateUsed)object).getCandidateId();
        this.theirChoice = new UsedCandidate((JingleS5BTransport)this.ourProposal, ((JingleS5BTransport)this.ourProposal).getCandidate((String)object), null);
        this.theirChoice.candidate;
        this.connectIfReady();
        return IQ.createResultIQ((IQ)jingle);
    }

    public IQ handleCandidateActivate(Jingle jingle) {
        LOGGER.log(Level.INFO, "handleCandidateActivate");
        Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(this.ourChoice.socket, this.ourChoice.candidate.getJid().n().a((CharSequence)this.jingleSession.getRemote().n()));
        this.callback.onSessionInitiated(socks5BytestreamSession);
        return IQ.createResultIQ((IQ)jingle);
    }

    public IQ handleCandidateError(Jingle jingle) {
        this.theirChoice = CANDIDATE_FAILURE;
        this.connectIfReady();
        return IQ.createResultIQ((IQ)jingle);
    }

    public IQ handleProxyError(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void connectIfReady() {
        block15: {
            block13: {
                block14: {
                    var1_1 /* !! */  = this.jingleSession.getContents().get(0);
                    if (this.ourChoice == null || this.theirChoice == null) {
                        JingleS5BTransportSession.LOGGER.log(Level.INFO, "Not ready.");
                        return;
                    }
                    if (this.ourChoice == JingleS5BTransportSession.CANDIDATE_FAILURE && this.theirChoice == JingleS5BTransportSession.CANDIDATE_FAILURE) {
                        JingleS5BTransportSession.LOGGER.log(Level.INFO, "Failure.");
                        this.jingleSession.onTransportMethodFailed(this.getNamespace());
                        return;
                    }
                    JingleS5BTransportSession.LOGGER.log(Level.INFO, "Ready.");
                    if (this.ourChoice == JingleS5BTransportSession.CANDIDATE_FAILURE || this.theirChoice == JingleS5BTransportSession.CANDIDATE_FAILURE) break block13;
                    if (UsedCandidate.access$000(this.ourChoice).getPriority() <= UsedCandidate.access$000(this.theirChoice).getPriority()) break block14;
                    var2_4 = this.ourChoice;
                    break block15;
                }
                if (UsedCandidate.access$000(this.ourChoice).getPriority() < UsedCandidate.access$000(this.theirChoice).getPriority()) ** GOTO lbl-1000
                var2_4 = this.jingleSession.isInitiator() != false ? this.ourChoice : this.theirChoice;
                break block15;
            }
            if (this.ourChoice != JingleS5BTransportSession.CANDIDATE_FAILURE) {
                var2_4 = this.ourChoice;
            } else lbl-1000:
            // 2 sources

            {
                var2_4 = this.theirChoice;
            }
        }
        if (var2_4 == this.theirChoice) {
            JingleS5BTransportSession.LOGGER.log(Level.INFO, "Their choice, so our proposed candidate is used.");
            var3_5 = UsedCandidate.access$000(var2_4).getType() == JingleS5BTransportCandidate.Type.proxy;
            try {
                var2_4 = this.connectToOurCandidate(UsedCandidate.access$000(var2_4));
            }
            catch (IOException | InterruptedException | TimeoutException | SmackException | XMPPException var4_7) {
                JingleS5BTransportSession.LOGGER.log(Level.INFO, "Could not connect to our candidate.", var4_7);
                return;
            }
            if (var3_5) {
                JingleS5BTransportSession.LOGGER.log(Level.INFO, "Is external proxy. Activate it.");
                var4_8 = new Bytestream(((JingleS5BTransport)this.ourProposal).getStreamId());
                var4_8.setMode(null);
                var4_8.setType(IQ.Type.set);
                var4_8.setTo(UsedCandidate.access$000(var2_4).getJid());
                var4_8.setToActivate((i)this.jingleSession.getRemote());
                var4_8.setFrom((i)this.jingleSession.getLocal());
                try {
                    this.jingleSession.getConnection().createStanzaCollectorAndSend((IQ)var4_8).nextResultOrThrow();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException var1_2) {
                    JingleS5BTransportSession.LOGGER.log(Level.WARNING, "Could not activate proxy.", var1_2);
                    return;
                }
                JingleS5BTransportSession.LOGGER.log(Level.INFO, "Send candidate-activate.");
                var1_1 /* !! */  = this.transportManager().createCandidateActivated(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), var1_1 /* !! */ .getSenders(), var1_1 /* !! */ .getCreator(), var1_1 /* !! */ .getName(), UsedCandidate.access$300(var2_4).getStreamId(), UsedCandidate.access$000(var2_4).getCandidateId());
                try {
                    this.jingleSession.getConnection().createStanzaCollectorAndSend((IQ)var1_1 /* !! */ ).nextResultOrThrow();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException var1_3) {
                    JingleS5BTransportSession.LOGGER.log(Level.WARNING, "Could not send candidate-activated", var1_3);
                    return;
                }
            }
            JingleS5BTransportSession.LOGGER.log(Level.INFO, "Start transmission.");
            var4_8 = new Socks5BytestreamSession(UsedCandidate.access$200(var2_4), var3_5 == false);
            this.callback.onSessionInitiated((BytestreamSession)var4_8);
            return;
        }
        JingleS5BTransportSession.LOGGER.log(Level.INFO, "Our choice, so their candidate was used.");
        var3_6 = UsedCandidate.access$000(var2_4).getType() == JingleS5BTransportCandidate.Type.proxy;
        if (!var3_6) {
            JingleS5BTransportSession.LOGGER.log(Level.INFO, "Direct connection.");
            var4_9 = new Socks5BytestreamSession(UsedCandidate.access$200(var2_4), true);
            this.callback.onSessionInitiated(var4_9);
            return;
        }
        JingleS5BTransportSession.LOGGER.log(Level.INFO, "Our choice was their external proxy. wait for candidate-activate.");
    }

    public JingleS5BTransportManager transportManager() {
        return JingleS5BTransportManager.getInstanceFor(this.jingleSession.getConnection());
    }

    private static final class UsedCandidate {
        private final Socket socket;
        private final JingleS5BTransport transport;
        private final JingleS5BTransportCandidate candidate;

        private UsedCandidate(JingleS5BTransport jingleS5BTransport, JingleS5BTransportCandidate jingleS5BTransportCandidate, Socket socket) {
            this.socket = socket;
            this.transport = jingleS5BTransport;
            this.candidate = jingleS5BTransportCandidate;
        }

        static /* synthetic */ JingleS5BTransport access$300(UsedCandidate usedCandidate) {
            return usedCandidate.transport;
        }
    }
}

