/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.roster.provider.RosterPacketProvider;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.xdata.AbstractMultiFormField;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.FormFieldWithOptions;
import org.jivesoftware.smackx.xdata.JidMultiFormField;
import org.jivesoftware.smackx.xdata.JidSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProviderManager;
import org.jivesoftware.smackx.xdatalayout.provider.DataLayoutProvider;

public class DataFormProvider
extends ExtensionElementProvider<DataForm> {
    private static final Logger LOGGER = Logger.getLogger(DataFormProvider.class.getName());
    public static final DataFormProvider INSTANCE = new DataFormProvider();
    private static final Set<FieldNameAndFormType> UNKNOWN_FIELDS = new CopyOnWriteArraySet<FieldNameAndFormType>();

    /*
     * Enabled aggressive block sorting
     */
    public DataForm parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        Object object = DataForm.Type.fromString(xmlPullParser.getAttributeValue("", "type"));
        object = DataForm.builder((DataForm.Type)((Object)object));
        String string = null;
        DataForm.ReportedData reportedData = null;
        block22: while (true) {
            Object object2 = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object2.ordinal()]) {
                case 1: {
                    object2 = xmlPullParser.getName();
                    Object object3 = xmlPullParser.getNamespace();
                    XmlEnvironment xmlEnvironment2 = XmlEnvironment.from((XmlPullParser)xmlPullParser, (XmlEnvironment)xmlEnvironment);
                    int n2 = -1;
                    switch (((String)object2).hashCode()) {
                        case 757376421: {
                            if (!((String)object2).equals("instructions")) break;
                            n2 = 0;
                            break;
                        }
                        case 110371416: {
                            if (!((String)object2).equals("title")) break;
                            n2 = 1;
                            break;
                        }
                        case 97427706: {
                            if (!((String)object2).equals("field")) break;
                            n2 = 2;
                            break;
                        }
                        case 3242771: {
                            if (!((String)object2).equals("item")) break;
                            n2 = 3;
                            break;
                        }
                        case -427039533: {
                            if (!((String)object2).equals("reported")) break;
                            n2 = 4;
                            break;
                        }
                        case 107944136: {
                            if (!((String)object2).equals("query")) break;
                            n2 = 5;
                            break;
                        }
                        case 3433103: {
                            if (!((String)object2).equals("page")) break;
                            n2 = 6;
                            break;
                        }
                    }
                    switch (n2) {
                        case 0: {
                            ((DataForm.Builder)object).addInstruction(xmlPullParser.nextText());
                            break block0;
                        }
                        case 1: {
                            ((DataForm.Builder)object).setTitle(xmlPullParser.nextText());
                            break block0;
                        }
                        case 2: {
                            object2 = DataFormProvider.parseField(xmlPullParser, xmlEnvironment2, string);
                            object3 = ((FormField)object2).asHiddenFormTypeFieldIfPossible();
                            if (object3 != null) {
                                if (string != null) {
                                    throw new SmackParsingException("Multiple hidden form type fields");
                                }
                                string = ((AbstractSingleStringValueFormField)object3).getValue();
                            }
                            ((DataForm.Builder)object).addField((FormField)object2);
                            break block0;
                        }
                        case 3: {
                            object2 = DataFormProvider.parseItem(xmlPullParser, xmlEnvironment2, string, reportedData);
                            ((DataForm.Builder)object).addItem((DataForm.Item)object2);
                            break block0;
                        }
                        case 4: {
                            if (reportedData != null) {
                                throw new SmackParsingException("Data form with multiple <reported/> elements");
                            }
                            reportedData = DataFormProvider.parseReported(xmlPullParser, xmlEnvironment2, string);
                            ((DataForm.Builder)object).setReportedData(reportedData);
                            break block0;
                        }
                        case 5: {
                            if (!((String)object3).equals("jabber:iq:roster")) break;
                            ((DataForm.Builder)object).addExtensionElement((Element)RosterPacketProvider.INSTANCE.parse(xmlPullParser));
                            break block0;
                        }
                        case 6: {
                            if (!((String)object3).equals("http://jabber.org/protocol/xdata-layout")) break;
                            ((DataForm.Builder)object).addExtensionElement((Element)DataLayoutProvider.parse(xmlPullParser));
                        }
                    }
                    continue block22;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block22;
                }
            }
        }
        return ((DataForm.Builder)object).build();
    }

    private static FormField parseField(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment, String string) {
        return DataFormProvider.parseField(xmlPullParser, xmlEnvironment, string, null);
    }

    private static FormField parseField(XmlPullParser object, XmlEnvironment xmlEnvironment, String string, DataForm.ReportedData reportedData) {
        Object object2;
        Object object3;
        Object object4;
        int n = object.getDepth();
        String string2 = object.getAttributeValue("var");
        String string3 = object.getAttributeValue("", "label");
        FormField.Type type = null;
        Object object5 = object.getAttributeValue("type");
        if (object5 != null) {
            type = FormField.Type.fromString((String)object5);
        }
        object5 = new ArrayList();
        ArrayList<FormField.Option> arrayList = new ArrayList<FormField.Option>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean bl = false;
        block19: while (true) {
            object4 = object.nextTag();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$TagEvent[object4.ordinal()]) {
                case 1: {
                    object4 = object.getQName();
                    if (((QName)object4).equals(FormField.Value.QNAME)) {
                        object3 = DataFormProvider.parseValue(object);
                        object5.add(object3);
                        continue block19;
                    }
                    if (((QName)object4).equals(FormField.Option.QNAME)) {
                        object3 = DataFormProvider.parseOption(object);
                        arrayList.add((FormField.Option)object3);
                        continue block19;
                    }
                    if (((QName)object4).equals(FormField.Required.QNAME)) {
                        bl = true;
                        continue block19;
                    }
                    object3 = FormFieldChildElementProviderManager.getFormFieldChildElementProvider((QName)object4);
                    if (object3 == null) {
                        LOGGER.warning("Unknown form field child element " + object4 + " ignored");
                        continue block19;
                    }
                    Object object6 = object;
                    object2 = (FormFieldChildElement)object3.parse(object6, XmlEnvironment.from((XmlPullParser)object6, (XmlEnvironment)xmlEnvironment));
                    arrayList2.add(object2);
                    continue block19;
                }
                case 2: {
                    if (object.getDepth() == n) break block19;
                }
                default: {
                    continue block19;
                }
            }
            break;
        }
        if (type == null && reportedData != null && (object4 = reportedData.getField(string2)) != null) {
            type = ((FormField)object4).getType();
        }
        if (type == null) {
            if (string2.equals("FORM_TYPE")) {
                type = FormField.Type.hidden;
            } else {
                type = FormFieldRegistry.lookup(string, string2);
                if (type == null) {
                    object4 = new FieldNameAndFormType(string2, string);
                    if (!UNKNOWN_FIELDS.contains(object4)) {
                        LOGGER.warning("The Field '" + string2 + "' from FORM_TYPE '" + string + "' is not registered. Field type is unknown, assuming text-single.");
                        UNKNOWN_FIELDS.add((FieldNameAndFormType)object4);
                    }
                    type = FormField.Type.text_single;
                }
            }
        }
        switch (type) {
            case bool: {
                object4 = DataFormProvider.parseBooleanFormField(string2, (List<FormField.Value>)object5);
                break;
            }
            case fixed: {
                object4 = DataFormProvider.parseSingleKindFormField(FormField.fixedBuilder(string2), (List<FormField.Value>)object5);
                break;
            }
            case hidden: {
                object4 = DataFormProvider.parseSingleKindFormField(FormField.hiddenBuilder(string2), (List<FormField.Value>)object5);
                break;
            }
            case jid_multi: {
                object4 = FormField.jidMultiBuilder(string2);
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = (FormField.Value)object3.next();
                    ((JidMultiFormField.Builder)object4).addValue((FormField.Value)object2);
                }
                break;
            }
            case jid_single: {
                DataFormProvider.ensureAtMostSingleValue(type, (List<FormField.Value>)object5);
                object3 = FormField.jidSingleBuilder(string2);
                if (!object5.isEmpty()) {
                    object2 = (FormField.Value)object5.get(0);
                    ((JidSingleFormField.Builder)object3).setValue((FormField.Value)object2);
                }
                object4 = object3;
                break;
            }
            case list_multi: {
                object2 = FormField.listMultiBuilder(string2);
                DataFormProvider.addOptionsToBuilder(arrayList, object2);
                object4 = DataFormProvider.parseMultiKindFormField(object2, (List<FormField.Value>)object5);
                break;
            }
            case list_single: {
                object = FormField.listSingleBuilder(string2);
                DataFormProvider.addOptionsToBuilder(arrayList, object);
                object4 = DataFormProvider.parseSingleKindFormField(object, (List<FormField.Value>)object5);
                break;
            }
            case text_multi: {
                object4 = DataFormProvider.parseMultiKindFormField(FormField.textMultiBuilder(string2), (List<FormField.Value>)object5);
                break;
            }
            case text_private: {
                object4 = DataFormProvider.parseSingleKindFormField(FormField.textPrivateBuilder(string2), (List<FormField.Value>)object5);
                break;
            }
            case text_single: {
                object4 = DataFormProvider.parseSingleKindFormField(FormField.textSingleBuilder(string2), (List<FormField.Value>)object5);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type " + (Object)((Object)type)));
            }
        }
        switch (type) {
            case list_multi: 
            case list_single: {
                break;
            }
            default: {
                if (arrayList.isEmpty()) break;
                throw new SmackParsingException("Form fields of type " + (Object)((Object)type) + " must not have options. This one had " + arrayList.size());
            }
        }
        if (string3 != null) {
            ((FormField.Builder)object4).setLabel(string3);
        }
        ((FormField.Builder)object4).setRequired(bl);
        ((FormField.Builder)object4).addFormFieldChildElements(arrayList2);
        return ((FormField.Builder)object4).build();
    }

    private static FormField.Builder<?, ?> parseBooleanFormField(String object, List<FormField.Value> object2) {
        object = FormField.booleanBuilder((String)object);
        DataFormProvider.ensureAtMostSingleValue(((FormField.Builder)object).getType(), object2);
        if (object2.size() == 1) {
            object2 = object2.get(0);
            ((BooleanFormField.Builder)object).setValue((FormField.Value)object2);
        }
        return object;
    }

    private static AbstractSingleStringValueFormField.Builder<?, ?> parseSingleKindFormField(AbstractSingleStringValueFormField.Builder<?, ?> builder, List<FormField.Value> object) {
        DataFormProvider.ensureAtMostSingleValue(builder.getType(), object);
        if (object.size() == 1) {
            object = object.get(0).getValue().toString();
            builder.setValue((CharSequence)object);
        }
        return builder;
    }

    private static AbstractMultiFormField.Builder<?, ?> parseMultiKindFormField(AbstractMultiFormField.Builder<?, ?> builder, List<FormField.Value> object) {
        object = object.iterator();
        while (object.hasNext()) {
            FormField.Value value = (FormField.Value)object.next();
            builder.addValue(value.getValue());
        }
        return builder;
    }

    private static DataForm.Item parseItem(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment, String string, DataForm.ReportedData reportedData) {
        int n = xmlPullParser.getDepth();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block10: while (true) {
            Object object = xmlPullParser.nextTag();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$TagEvent[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "field": {
                            XmlPullParser xmlPullParser2 = xmlPullParser;
                            object = DataFormProvider.parseField(xmlPullParser2, XmlEnvironment.from((XmlPullParser)xmlPullParser2, (XmlEnvironment)xmlEnvironment), string, reportedData);
                            arrayList.add(object);
                        }
                    }
                    continue block10;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block10;
                }
                default: {
                    continue block10;
                }
            }
            break;
        }
        return new DataForm.Item(arrayList);
    }

    private static DataForm.ReportedData parseReported(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment, String string) {
        int n = xmlPullParser.getDepth();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block10: while (true) {
            Object object = xmlPullParser.nextTag();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$TagEvent[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "field": {
                            XmlPullParser xmlPullParser2 = xmlPullParser;
                            object = DataFormProvider.parseField(xmlPullParser2, XmlEnvironment.from((XmlPullParser)xmlPullParser2, (XmlEnvironment)xmlEnvironment), string);
                            arrayList.add(object);
                        }
                    }
                    continue block10;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block10;
                }
                default: {
                    continue block10;
                }
            }
            break;
        }
        return new DataForm.ReportedData(arrayList);
    }

    public static FormField.Value parseValue(XmlPullParser object) {
        object = object.nextText();
        return new FormField.Value((CharSequence)object);
    }

    public static FormField.Option parseOption(XmlPullParser xmlPullParser) {
        int n = xmlPullParser.getDepth();
        FormField.Option option = null;
        String string = xmlPullParser.getAttributeValue("", "label");
        block10: while (true) {
            Object object = xmlPullParser.nextTag();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$TagEvent[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "value": {
                            option = new FormField.Option(string, xmlPullParser.nextText());
                        }
                    }
                    continue block10;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block10;
                }
                default: {
                    continue block10;
                }
            }
            break;
        }
        return option;
    }

    private static void ensureAtMostSingleValue(FormField.Type type, List<FormField.Value> list) {
        if (list.size() > 1) {
            throw new SmackParsingException((Object)((Object)type) + " fields can have at most one value, this one had " + list.size());
        }
    }

    private static void addOptionsToBuilder(Collection<FormField.Option> object, FormFieldWithOptions.Builder<?> builder) {
        object = object.iterator();
        while (object.hasNext()) {
            FormField.Option option = (FormField.Option)object.next();
            builder.addOption(option);
        }
    }

    private static final class FieldNameAndFormType {
        private final String fieldName;
        private final String formType;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        private FieldNameAndFormType(String string, String string2) {
            this.fieldName = string;
            this.formType = string2;
        }

        public final int hashCode() {
            return this.hashCodeCache.getHashCode(builder -> builder.append((Object)this.fieldName).append((Object)this.formType).build());
        }

        public final boolean equals(Object object) {
            return EqualsUtil.equals((Object)this, (Object)object, (builder, fieldNameAndFormType) -> builder.append((Object)this.fieldName, (Object)fieldNameAndFormType.fieldName).append((Object)this.formType, (Object)fieldNameAndFormType.formType));
        }
    }
}

