/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.date;

import io.ktor.util.date.GMTDate;
import io.ktor.util.date.GMTDateBuilder;
import io.ktor.util.date.InvalidDateStringException;
import io.ktor.util.date.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000f\u001a\u00020\u000e*\u00020\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lio/ktor/util/date/GMTDateParser;", "", "", "pattern", "<init>", "(Ljava/lang/String;)V", "dateString", "Lio/ktor/util/date/GMTDate;", "parse", "(Ljava/lang/String;)Lio/ktor/util/date/GMTDate;", "Lio/ktor/util/date/GMTDateBuilder;", "", "type", "chunk", "", "handleToken", "(Lio/ktor/util/date/GMTDateBuilder;CLjava/lang/String;)V", "Ljava/lang/String;", "Companion", "ktor-utils"})
public final class GMTDateParser {
    public static final Companion Companion = new Companion(null);
    private final String pattern;
    public static final char SECONDS = 's';
    public static final char MINUTES = 'm';
    public static final char HOURS = 'h';
    public static final char DAY_OF_MONTH = 'd';
    public static final char MONTH = 'M';
    public static final char YEAR = 'Y';
    public static final char ZONE = 'z';
    public static final char ANY = '*';

    public GMTDateParser(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.pattern = string;
        if (!(((CharSequence)this.pattern).length() > 0)) {
            string = "Date parser pattern shouldn't be empty.";
            throw new IllegalStateException(string.toString());
        }
    }

    public final GMTDate parse(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        GMTDateBuilder gMTDateBuilder = new GMTDateBuilder();
        int n = 0;
        char c = this.pattern.charAt(0);
        int n2 = 0;
        int n3 = 1;
        try {
            while (n3 < this.pattern.length()) {
                if (this.pattern.charAt(n3) == c) {
                    ++n3;
                    continue;
                }
                n = n2 + n3 - n;
                String string2 = string.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                this.handleToken(gMTDateBuilder, c, string2);
                n2 = n;
                n = n3;
                c = this.pattern.charAt(n3);
                ++n3;
            }
            if (n2 < string.length()) {
                String string3 = string.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                this.handleToken(gMTDateBuilder, c, string3);
            }
        }
        catch (Throwable throwable) {
            throw new InvalidDateStringException(string, n2, this.pattern);
        }
        return gMTDateBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private final void handleToken(GMTDateBuilder object, char c, String string) {
        boolean bl;
        block11: {
            switch (c) {
                case 's': {
                    ((GMTDateBuilder)object).setSeconds(Integer.parseInt(string));
                    return;
                }
                case 'm': {
                    ((GMTDateBuilder)object).setMinutes(Integer.parseInt(string));
                    return;
                }
                case 'h': {
                    ((GMTDateBuilder)object).setHours(Integer.parseInt(string));
                    return;
                }
                case 'd': {
                    ((GMTDateBuilder)object).setDayOfMonth(Integer.parseInt(string));
                    return;
                }
                case 'M': {
                    ((GMTDateBuilder)object).setMonth(Month.Companion.from(string));
                    return;
                }
                case 'Y': {
                    ((GMTDateBuilder)object).setYear(Integer.parseInt(string));
                    return;
                }
                case 'z': {
                    if (Intrinsics.areEqual((Object)string, (Object)"GMT")) return;
                    throw new IllegalStateException("Check failed.");
                }
                case '*': {
                    return;
                }
            }
            object = string;
            for (int k = 0; k < object.length(); ++k) {
                char c2 = object.charAt(k);
                char c3 = c2;
                c3 = c2;
                if (c2 == c) continue;
                bl = false;
                break block11;
            }
            bl = true;
        }
        if (bl) return;
        throw new IllegalStateException("Check failed.");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/ktor/util/date/GMTDateParser$Companion;", "", "<init>", "()V", "", "SECONDS", "C", "MINUTES", "HOURS", "DAY_OF_MONTH", "MONTH", "YEAR", "ZONE", "ANY", "ktor-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

