/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.Ringbuffer;
import java.io.PrintStream;
import java.lang.reflect.Array;

public class SyncedRingbuffer<T>
implements Ringbuffer<T> {
    private final Object syncGlobal = new Object();
    private T[] array;
    private int capacity;
    private int readPos;
    private int writePos;
    private int size;

    @Override
    public final String toString() {
        return "SyncedRingbuffer<?>[filled " + this.size + " / " + this.capacity + ", writePos " + this.writePos + ", readPos " + this.readPos + "]";
    }

    @Override
    public final void dump(PrintStream printStream, String string) {
        printStream.println(string + " " + this.toString() + " {");
        for (int i = 0; i < this.capacity; ++i) {
            printStream.println("\t[" + i + "]: " + this.array[i]);
        }
        printStream.println("}");
    }

    public SyncedRingbuffer(T[] TArray) {
        this.capacity = TArray.length;
        this.array = SyncedRingbuffer.newArray(TArray.getClass(), this.capacity);
        this.resetImpl(true, TArray);
    }

    public SyncedRingbuffer(Class<? extends T[]> clazz, int n) {
        this.capacity = n;
        this.array = SyncedRingbuffer.newArray(clazz, n);
        this.resetImpl(false, null);
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final void clear() {
        Object object = this.syncGlobal;
        synchronized (object) {
            this.resetImpl(false, null);
            for (int i = 0; i < this.capacity; ++i) {
                this.array[i] = null;
            }
            return;
        }
    }

    @Override
    public final void resetFull(T[] TArray) {
        this.resetImpl(true, TArray);
    }

    private final void resetImpl(boolean bl, T[] TArray) {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (TArray != null) {
                if (TArray.length != this.capacity()) {
                    throw new IllegalArgumentException("copyFrom array length " + TArray.length + " != capacity " + this);
                }
                System.arraycopy(TArray, 0, this.array, 0, TArray.length);
            } else if (bl) {
                throw new IllegalArgumentException("copyFrom array is null");
            }
            this.readPos = 0;
            this.writePos = 0;
            this.size = bl ? this.capacity : 0;
            return;
        }
    }

    @Override
    public final int size() {
        Object object = this.syncGlobal;
        synchronized (object) {
            return this.size;
        }
    }

    @Override
    public final int getFreeSlots() {
        Object object = this.syncGlobal;
        synchronized (object) {
            return this.capacity - this.size;
        }
    }

    @Override
    public final boolean isEmpty() {
        Object object = this.syncGlobal;
        synchronized (object) {
            return this.size == 0;
        }
    }

    @Override
    public final boolean isFull() {
        Object object = this.syncGlobal;
        synchronized (object) {
            return this.capacity == this.size;
        }
    }

    @Override
    public final T get() {
        try {
            return this.getImpl(false, false);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final T getBlocking() {
        return this.getImpl(true, false);
    }

    @Override
    public final T peek() {
        try {
            return this.getImpl(false, true);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final T peekBlocking() {
        return this.getImpl(true, true);
    }

    /*
     * WARNING - void declaration
     */
    private final T getImpl(boolean bl, boolean bl2) {
        Object object = this.syncGlobal;
        synchronized (object) {
            void var2_4;
            if (this.size == 0) {
                if (bl) {
                    while (this.size == 0) {
                        this.syncGlobal.wait();
                    }
                } else {
                    return null;
                }
            }
            int n = this.readPos;
            T t = this.array[n];
            if (var2_4 == false) {
                this.array[n] = null;
                --this.size;
                this.readPos = (n + 1) % this.capacity;
                this.syncGlobal.notifyAll();
            }
            return t;
        }
    }

    @Override
    public final boolean put(T t) {
        try {
            return this.putImpl(t, false, false);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public final void putBlocking(T t) {
        if (!this.putImpl(t, false, true)) {
            throw new InternalError("Blocking put failed: " + this);
        }
    }

    @Override
    public final boolean putSame(boolean bl) {
        return this.putImpl(null, true, bl);
    }

    private final boolean putImpl(T t, boolean bl, boolean bl2) {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (this.capacity == this.size) {
                if (bl2) {
                    while (this.capacity == this.size) {
                        this.syncGlobal.wait();
                    }
                } else {
                    return false;
                }
            }
            int n = this.writePos;
            if (!bl) {
                this.array[n] = t;
            }
            ++this.size;
            this.writePos = (n + 1) % this.capacity;
            this.syncGlobal.notifyAll();
            return true;
        }
    }

    @Override
    public final void waitForFreeSlots(int n) {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (this.capacity - this.size < n) {
                while (this.capacity - this.size < n) {
                    this.syncGlobal.wait();
                }
            }
            return;
        }
    }

    @Override
    public final void growEmptyBuffer(T[] TArray) {
        Object object = this.syncGlobal;
        synchronized (object) {
            int n;
            Class<?> clazz;
            if (TArray == null) {
                throw new IllegalArgumentException("newElements is null");
            }
            T[] TArray2 = this.array.getClass();
            if (TArray2 != (clazz = TArray.getClass())) {
                throw new IllegalArgumentException("newElements array-type mismatch, internal " + TArray2 + ", newElements " + clazz);
            }
            if (this.size != 0) {
                throw new IllegalStateException("Buffer is not empty: " + this);
            }
            if (this.readPos != this.writePos) {
                throw new InternalError("R/W pos not equal: " + this);
            }
            int n2 = TArray.length;
            int n3 = this.capacity + n2;
            T[] TArray3 = this.array;
            TArray2 = SyncedRingbuffer.newArray(TArray2, n3);
            this.writePos += n2;
            if (this.readPos > 0) {
                System.arraycopy(TArray3, 0, TArray2, 0, this.readPos);
            }
            if (n2 > 0) {
                System.arraycopy(TArray, 0, TArray2, this.readPos, n2);
            }
            if ((n = this.capacity - this.readPos) > 0) {
                System.arraycopy(TArray3, this.readPos, TArray2, this.writePos, n);
            }
            this.size = n2;
            this.capacity = n3;
            this.array = TArray2;
            return;
        }
    }

    @Override
    public final void growFullBuffer(int n) {
        Object object = this.syncGlobal;
        synchronized (object) {
            if (n < 0) {
                throw new IllegalArgumentException("amount " + n + " < 0 ");
            }
            if (this.capacity != this.size) {
                throw new IllegalStateException("Buffer is not full: " + this);
            }
            if (this.readPos != this.writePos) {
                throw new InternalError("R/W pos not equal: " + this);
            }
            T[] TArray = this.array.getClass();
            int n2 = this.capacity + n;
            T[] TArray2 = this.array;
            TArray = SyncedRingbuffer.newArray(TArray, n2);
            this.readPos += n;
            if (this.writePos > 0) {
                System.arraycopy(TArray2, 0, TArray, 0, this.writePos);
            }
            if ((n = this.capacity - this.writePos) > 0) {
                System.arraycopy(TArray2, this.writePos, TArray, this.readPos, n);
            }
            this.capacity = n2;
            this.array = TArray;
            return;
        }
    }

    private static <T> T[] newArray(Class<? extends T[]> clazz, int n) {
        if (clazz == Object[].class) {
            return new Object[n];
        }
        return (Object[])Array.newInstance(clazz.getComponentType(), n);
    }
}

