/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.cache;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.InterruptSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import jogamp.common.Debug;

public class TempFileCache {
    private static final boolean DEBUG = Debug.debug("TempFileCache");
    private static boolean staticInitError = false;
    private static boolean staticTempIsExecutable = true;
    private static final String tmpDirPrefix = "file_cache";
    private static final File tmpBaseDir;
    static final String tmpRootPropName = "jnlp.jogamp.tmp.cache.root";
    private static String tmpRootPropValue;
    private static File tmpRootDir;
    private boolean initError = false;
    private File individualTmpDir;

    public static boolean initSingleton() {
        return !staticInitError;
    }

    private static void initTmpRoot() {
        tmpRootPropValue = System.getProperty(tmpRootPropName);
        if (tmpRootPropValue != null) {
            if (tmpRootPropValue.indexOf(47) >= 0 || tmpRootPropValue.indexOf(File.separatorChar) >= 0) {
                throw new IOException("Illegal value of: jnlp.jogamp.tmp.cache.root");
            }
            if (DEBUG) {
                System.err.println("TempFileCache: Trying existing value of: jnlp.jogamp.tmp.cache.root=" + tmpRootPropValue);
            }
            tmpRootDir = new File(tmpBaseDir, tmpRootPropValue);
            if (DEBUG) {
                System.err.println("TempFileCache: Trying tmpRootDir = " + tmpRootDir.getAbsolutePath());
            }
            if (tmpRootDir.isDirectory()) {
                if (!tmpRootDir.canWrite()) {
                    throw new IOException("Temp root directory is not writable: " + tmpRootDir.getAbsolutePath());
                }
            } else {
                System.err.println("TempFileCache: None existing tmpRootDir = " + tmpRootDir.getAbsolutePath() + ", assuming new path due to update");
                tmpRootPropValue = null;
                tmpRootDir = null;
                System.clearProperty(tmpRootPropName);
            }
        }
        if (tmpRootPropValue == null) {
            Object object = File.createTempFile("jln", ".tmp", tmpBaseDir);
            if (DEBUG) {
                System.err.println("TempFileCache: tmpFile = " + ((File)object).getAbsolutePath());
            }
            final FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            AutoCloseable autoCloseable = fileOutputStream.getChannel();
            autoCloseable = autoCloseable.lock();
            object = ((File)object).getAbsolutePath();
            object = ((String)object).substring(0, ((String)object).lastIndexOf(".tmp"));
            Object object2 = (String)object + ".lck";
            object2 = new File((String)object2);
            if (DEBUG) {
                System.err.println("TempFileCache: lckFile = " + ((File)object2).getAbsolutePath());
            }
            ((File)object2).createNewFile();
            object2 = new FileOutputStream((File)object2);
            AutoCloseable autoCloseable2 = ((FileOutputStream)object2).getChannel();
            autoCloseable2 = autoCloseable2.lock();
            tmpRootDir = new File((String)object);
            if (DEBUG) {
                System.err.println("TempFileCache: tmpRootDir = " + tmpRootDir.getAbsolutePath());
            }
            if (!tmpRootDir.mkdir()) {
                throw new IOException("Cannot create " + tmpRootDir);
            }
            Runtime.getRuntime().addShutdownHook(new InterruptSource.Thread((FileLock)autoCloseable, (FileOutputStream)object2, (FileLock)autoCloseable2){
                final /* synthetic */ FileLock val$tmpLock;
                final /* synthetic */ FileOutputStream val$lckOut;
                final /* synthetic */ FileLock val$lckLock;
                {
                    this.val$tmpLock = fileLock;
                    this.val$lckOut = fileOutputStream2;
                    this.val$lckLock = fileLock2;
                }

                @Override
                public void run() {
                    try {
                        fileOutputStream.close();
                        this.val$tmpLock.release();
                        this.val$lckOut.close();
                        this.val$lckLock.release();
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            });
            Object object3 = object;
            tmpRootPropValue = ((String)object3).substring(((String)object3).lastIndexOf(File.separator) + 1);
            System.setProperty(tmpRootPropName, tmpRootPropValue);
            if (DEBUG) {
                System.err.println("TempFileCache: Setting jnlp.jogamp.tmp.cache.root=" + tmpRootPropValue);
            }
            object = new InterruptSource.Thread(){

                @Override
                public void run() {
                    TempFileCache.deleteOldTempDirs();
                }
            };
            ((Thread)object).setName("TempFileCache-Reaper");
            ((Thread)object).start();
        }
    }

    private static void deleteOldTempDirs() {
        if (DEBUG) {
            System.err.println("TempFileCache: *** Reaper: deleteOldTempDirs in " + tmpBaseDir.getAbsolutePath());
        }
        String[] stringArray = tmpRootPropValue + ".lck";
        stringArray = new FilenameFilter((String)stringArray){
            final /* synthetic */ String val$ourLockFile;
            {
                this.val$ourLockFile = string;
            }

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".lck") && !string.equals(this.val$ourLockFile);
            }
        };
        if ((stringArray = tmpBaseDir.list((FilenameFilter)stringArray)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = stringArray[i];
                Object object2 = ((String)object).substring(0, ((String)object).lastIndexOf(".lck"));
                Object object3 = (String)object2 + ".tmp";
                object = new File(tmpBaseDir, (String)object);
                object3 = new File(tmpBaseDir, (String)object3);
                object2 = new File(tmpBaseDir, (String)object2);
                if (((File)object).exists() && ((File)object3).exists() && ((File)object2).isDirectory()) {
                    FileLock fileLock;
                    Closeable closeable;
                    FileLock fileLock2;
                    FileOutputStream fileOutputStream;
                    block17: {
                        block16: {
                            fileOutputStream = null;
                            fileLock2 = null;
                            try {
                                fileOutputStream = new FileOutputStream((File)object3);
                                closeable = fileOutputStream.getChannel();
                                fileLock2 = ((FileChannel)closeable).tryLock();
                            }
                            catch (Exception exception) {
                                if (!DEBUG) break block16;
                                exception.printStackTrace();
                            }
                        }
                        if (fileLock2 == null) continue;
                        closeable = null;
                        fileLock = null;
                        try {
                            closeable = new FileOutputStream((File)object);
                            FileChannel fileChannel = ((FileOutputStream)closeable).getChannel();
                            fileLock = fileChannel.tryLock();
                        }
                        catch (Exception exception) {
                            if (!DEBUG) break block17;
                            exception.printStackTrace();
                        }
                    }
                    if (fileLock != null) {
                        TempFileCache.removeAll((File)object2);
                        try {
                            ((FileOutputStream)closeable).close();
                        }
                        catch (IOException iOException) {}
                        ((File)object).delete();
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                        ((File)object3).delete();
                        continue;
                    }
                    try {
                        if (closeable != null) {
                            ((FileOutputStream)closeable).close();
                        }
                        fileOutputStream.close();
                        fileLock2.release();
                    }
                    catch (IOException iOException) {
                        if (!DEBUG) continue;
                        iOException.printStackTrace();
                    }
                    continue;
                }
                if (!DEBUG) continue;
                System.err.println("TempFileCache: Skipping: " + ((File)object2).getAbsolutePath());
            }
        }
    }

    private static void removeAll(File file) {
        File[] fileArray;
        if (DEBUG) {
            System.err.println("TempFileCache: removeAll(" + file + ")");
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                TempFileCache.removeAll(fileArray[i]);
            }
        }
        file.delete();
    }

    public TempFileCache() {
        if (DEBUG) {
            System.err.println("TempFileCache: new TempFileCache() --------------------- (static ok: " + !staticInitError + ")");
            System.err.println("TempFileCache: Thread: " + Thread.currentThread().getName() + ", CL 0x" + Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()) + ", this 0x" + Integer.toHexString(this.hashCode()));
        }
        if (!staticInitError) {
            try {
                this.createTmpDir();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
                this.initError = true;
            }
        }
        if (DEBUG) {
            System.err.println("TempFileCache: tempDir " + this.individualTmpDir + " (ok: " + !this.initError + ")");
            System.err.println("----------------------------------------------------------");
        }
    }

    public void destroy() {
        if (DEBUG) {
            System.err.println("TempFileCache: destroy() --------------------- (static ok: " + !staticInitError + ")");
            System.err.println("TempFileCache: Thread: " + Thread.currentThread().getName() + ", CL 0x" + Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()) + ", this 0x" + Integer.toHexString(this.hashCode()));
        }
        if (!staticInitError) {
            try {
                TempFileCache.removeAll(this.individualTmpDir);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
        this.individualTmpDir = null;
        if (DEBUG) {
            System.err.println("TempFileCache: destroy() END");
        }
    }

    public boolean isValid(boolean bl) {
        return !staticInitError && !this.initError && (!bl || staticTempIsExecutable);
    }

    public static File getBaseDir() {
        return tmpBaseDir;
    }

    public static File getRootDir() {
        return tmpRootDir;
    }

    public File getTempDir() {
        return this.individualTmpDir;
    }

    private void createTmpDir() {
        Object object = File.createTempFile("jln", ".tmp", tmpRootDir);
        object = ((File)object).getAbsolutePath();
        object = ((String)object).substring(0, ((String)object).lastIndexOf(".tmp"));
        this.individualTmpDir = new File((String)object);
        if (!this.individualTmpDir.mkdir()) {
            throw new IOException("Cannot create " + this.individualTmpDir);
        }
    }

    static {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            File file = null;
            try {
                file = new File(IOUtil.getTempDir(true), tmpDirPrefix);
                file = IOUtil.testDir(file, true, false);
                staticTempIsExecutable = true;
            }
            catch (Exception exception) {
                System.err.println("Warning: Caught Exception while retrieving executable temp base directory:");
                exception.printStackTrace();
                staticTempIsExecutable = false;
                try {
                    file = new File(IOUtil.getTempDir(false), tmpDirPrefix);
                    file = IOUtil.testDir(file, true, false);
                }
                catch (Exception exception2) {
                    System.err.println("Warning: Caught Exception while retrieving non-executable temp base directory:");
                    exception2.printStackTrace();
                    staticInitError = true;
                }
            }
            tmpBaseDir = file;
            if (DEBUG) {
                String string = tmpBaseDir != null ? tmpBaseDir.getAbsolutePath() : null;
                System.err.println("TempFileCache: Static Initialization ---------------------------------------------- OK: " + !staticInitError);
                System.err.println("TempFileCache: Thread: " + Thread.currentThread().getName() + ", CL 0x" + Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()) + ", tempBaseDir " + string + ", executable " + staticTempIsExecutable);
            }
            if (!staticInitError) {
                try {
                    TempFileCache.initTmpRoot();
                }
                catch (Exception exception) {
                    System.err.println("Warning: Caught Exception due to initializing TmpRoot:");
                    exception.printStackTrace();
                    staticInitError = true;
                    staticTempIsExecutable = false;
                }
            }
            if (DEBUG) {
                System.err.println("------------------------------------------------------------------ OK: " + !staticInitError);
            }
            return;
        }
    }
}

