/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.jna.linux.AppIndicator;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkCheck;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.jna.rendering.RenderProvider;
import dorkbox.os.OS;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.ui.swing.SwingUIFactory;
import dorkbox.systemTray.util.AutoDetectTrayType;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.ImageResizeUtil;
import dorkbox.systemTray.util.LinuxSwingUI;
import dorkbox.systemTray.util.SizeAndScaling;
import dorkbox.systemTray.util.SizeAndScalingWindows;
import dorkbox.systemTray.util.SystemTrayFixesLinux;
import dorkbox.systemTray.util.SystemTrayFixesMacOS;
import dorkbox.systemTray.util.SystemTrayFixesWindows;
import dorkbox.systemTray.util.WindowsSwingUI;
import dorkbox.updates.Updates;
import dorkbox.util.CacheUtil;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemTray {
    public static final Logger logger = LoggerFactory.getLogger(SystemTray.class);
    public static volatile boolean AUTO_SIZE = OS.INSTANCE.getBoolean(SystemTray.class.getSimpleName() + ".AUTO_SIZE", true);
    public static volatile String APP_NAME = "SystemTray";
    public static volatile boolean FORCE_GTK2 = OS.INSTANCE.getBoolean(SystemTray.class.getSimpleName() + ".FORCE_GTK2", false);
    public static volatile boolean PREFER_GTK3 = OS.INSTANCE.getBoolean(SystemTray.class.getSimpleName() + ".PREFER_GTK3", true);
    public static volatile TrayType FORCE_TRAY_TYPE = TrayType.AppIndicator.safeFromString(OS.INSTANCE.getProperty(SystemTray.class.getSimpleName() + ".FORCE_TRAY_TYPE", TrayType.AutoDetect.name()));
    public static volatile boolean AUTO_FIX_INCONSISTENCIES = OS.INSTANCE.getBoolean(SystemTray.class.getSimpleName() + ".AUTO_FIX_INCONSISTENCIES", true);
    public static volatile boolean ENABLE_ROOT_CHECK = OS.INSTANCE.getBoolean(SystemTray.class.getSimpleName() + ".ENABLE_ROOT_CHECK", true);
    public static volatile boolean DEBUG = OS.INSTANCE.getBoolean(SystemTray.class.getSimpleName() + ".DEBUG", false);
    public static volatile SwingUIFactory SWING_UI = null;
    private final Tray menu;
    private final ImageResizeUtil imageResizeUtil;

    public static String getVersion() {
        return "4.5";
    }

    public static SystemTray get() {
        return SystemTray.get(APP_NAME);
    }

    public static synchronized SystemTray get(String string) {
        Object object;
        Object object2;
        TrayType trayType;
        Object object3;
        if (AUTO_FIX_INCONSISTENCIES) {
            System.setProperty("apple.awt.application.appearance", "system");
        }
        if (GraphicsEnvironment.isHeadless()) {
            logger.error("Cannot use the SystemTray in a headless environment");
            return null;
        }
        if (!RenderProvider.isSupported()) {
            if (RenderProvider.isSwt()) {
                logger.error("Unable to use currently loaded version of SWT, it is TOO OLD. Please use version 4.4+");
            }
            return null;
        }
        SystemTray systemTray = AutoDetectTrayType.getInstance(string);
        if (systemTray != null) {
            if (DEBUG) {
                logger.info("Returning existing tray: " + string);
            }
            return systemTray;
        }
        boolean bl = OS.INSTANCE.isLinux() || OS.INSTANCE.isUnix();
        boolean bl2 = OS.INSTANCE.isWindows();
        boolean bl3 = OS.INSTANCE.isMacOsX();
        if (bl2) {
            SizeAndScalingWindows.setDpiAware();
            if (FORCE_TRAY_TYPE != TrayType.AutoDetect && FORCE_TRAY_TYPE != TrayType.Swing && FORCE_TRAY_TYPE != TrayType.WindowsNative) {
                logger.warn("Windows cannot use the '" + (Object)((Object)FORCE_TRAY_TYPE) + "' SystemTray type on windows, auto-detecting implementation!");
                FORCE_TRAY_TYPE = TrayType.AutoDetect;
            }
        } else if (bl3) {
            if (RenderProvider.isSwt() && FORCE_TRAY_TYPE == TrayType.Swing) {
                if (AUTO_FIX_INCONSISTENCIES) {
                    logger.warn("Unable to load Swing + SWT (for all versions of Java). Using the AWT Tray type instead.");
                    FORCE_TRAY_TYPE = TrayType.Awt;
                } else {
                    logger.error("Unable to load Swing + SWT (for all versions of Java). Please set `SystemTray.AUTO_FIX_INCONSISTENCIES=true;` to automatically fix this problem.\"");
                    return null;
                }
            }
            if (FORCE_TRAY_TYPE != TrayType.AutoDetect && FORCE_TRAY_TYPE != TrayType.Swing && FORCE_TRAY_TYPE != TrayType.Awt) {
                FORCE_TRAY_TYPE = TrayType.AutoDetect;
                logger.warn("MacOS cannot use the '" + (Object)((Object)FORCE_TRAY_TYPE) + "' SystemTray type, defaulting to the AWT Tray type instead.");
            }
        } else if (bl) {
            int n = GtkCheck.getLoadedGtkVersion();
            if (n == 2) {
                if (AUTO_FIX_INCONSISTENCIES) {
                    if (!FORCE_GTK2) {
                        if (RenderProvider.isJavaFX()) {
                            if (OS.INSTANCE.getJavaVersion() < 11) {
                                FORCE_GTK2 = true;
                                if (DEBUG) {
                                    logger.debug("Forcing GTK2 because JavaFX is GTK2");
                                }
                            } else {
                                object3 = System.getProperty("jdk.gtk.version", "0");
                                if (((String)object3).startsWith("2")) {
                                    FORCE_GTK2 = true;
                                    if (DEBUG) {
                                        logger.debug("Forcing GTK2 because JavaFX System property `jdk.gtk.version` was set to 2 (so we force GTK2)");
                                    }
                                }
                            }
                        } else if (RenderProvider.isSwt() && RenderProvider.getGtkVersion() != 3) {
                            FORCE_GTK2 = true;
                            if (DEBUG) {
                                logger.debug("Forcing GTK2 because SWT is GTK2");
                            }
                        } else {
                            FORCE_GTK2 = true;
                            if (DEBUG) {
                                logger.debug("Forcing GTK2 because Java has already loaded GTK2");
                            }
                        }
                    }
                } else if (!FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when there is a mismatch for GTK loaded preferences. Please correctly set `SystemTray.FORCE_GTK2=true` or set `SystemTray.AUTO_FIX_INCONSISTENCIES=true`.  Aborting...");
                    return null;
                }
            } else if (n == 3) {
                if (AUTO_FIX_INCONSISTENCIES) {
                    if (RenderProvider.isJavaFX()) {
                        if (FORCE_GTK2 && OS.INSTANCE.getJavaVersion() >= 9) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure JavaFX to use GTK2 (via `System.setProperty(\"jdk.gtk.version\", \"3\");`) before JavaFX is initialized, or set `SystemTray.FORCE_GTK2=false;`  Undoing `FORCE_GTK2`.");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because JavaFX is GTK3");
                            }
                        }
                    } else if (RenderProvider.isSwt()) {
                        if (FORCE_GTK2) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when SWT is configured to use GTK3 and the SystemTray is configured to use GTK2. Please set `SystemTray.FORCE_GTK2=false;`");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because SWT is GTK3");
                            }
                        }
                    } else {
                        if (FORCE_GTK2) {
                            FORCE_GTK2 = false;
                            logger.warn("Unable to use the SystemTray when Swing is configured to use GTK3 and the SystemTray is configured to use GTK2. Undoing `FORCE_GTK2.");
                        }
                        if (!PREFER_GTK3) {
                            PREFER_GTK3 = true;
                            if (DEBUG) {
                                logger.debug("Preferring GTK3 even though specified otherwise, because Java has already loaded GTK3");
                            }
                        }
                    }
                } else if (RenderProvider.isJavaFX()) {
                    if (FORCE_GTK2) {
                        if (OS.INSTANCE.getJavaVersion() >= 9) {
                            logger.error("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please configure JavaFX to use GTK2 (via `System.setProperty(\"jdk.gtk.version\", \"3\");`) before JavaFX is initialized, or set `SystemTray.FORCE_GTK2=false;`  Aborting.");
                        } else {
                            logger.error("Unable to use the SystemTray when JavaFX is configured to use GTK3 and the SystemTray is configured to use GTK2. Please set `SystemTray.FORCE_GTK2=false;`  Aborting.");
                        }
                        return null;
                    }
                } else if (RenderProvider.isSwt()) {
                    if (FORCE_GTK2) {
                        logger.error("Unable to use the SystemTray when SWT is configured to use GTK3 and the SystemTray is configured to use GTK2. Please set `SystemTray.FORCE_GTK2=false;`");
                        return null;
                    }
                } else if (FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when Swing is configured to use GTK3 and the SystemTray is configured to use GTK2. Aborting.");
                    return null;
                }
            } else if (RenderProvider.isDefault()) {
                object3 = System.getProperty("swing.gtk.version", "0");
                if (object3 != null && ((String)object3).startsWith("3") && FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when there is a mismatch for GTK loaded preferences. Please correctly set `SystemTray.FORCE_GTK2=true` and System property `swing.gtk.version=\"2.2\".  Aborting...");
                    return null;
                }
                object3 = System.getProperty("jdk.gtk.version", "0");
                if (object3 != null && ((String)object3).startsWith("3") && FORCE_GTK2) {
                    logger.error("Unable to use the SystemTray when there is a mismatch for GTK loaded preferences. Please correctly set `SystemTray.FORCE_GTK2=true` and System property `jdk.gtk.version=\"2.2\".  Aborting...");
                    return null;
                }
                if ("0".equals(object3) && AUTO_FIX_INCONSISTENCIES) {
                    if (PREFER_GTK3) {
                        System.setProperty("swing.gtk.version", "3");
                        System.setProperty("jdk.gtk.version", "3");
                    } else {
                        System.setProperty("swing.gtk.version", "2");
                        System.setProperty("jdk.gtk.version", "2");
                    }
                }
            }
        }
        if ((trayType = FORCE_TRAY_TYPE == TrayType.AutoDetect ? AutoDetectTrayType.get(string) : FORCE_TRAY_TYPE) == null) {
            if (OS.DesktopEnv.INSTANCE.isChromeOS()) {
                logger.error("ChromeOS detected and it is not supported. Aborting.");
            }
            return null;
        }
        if (bl) {
            if (trayType == TrayType.Gtk) {
                object3 = OS.DesktopEnv.INSTANCE.getEnv();
                if (OS.Linux.INSTANCE.isUbuntu() && OS.DesktopEnv.INSTANCE.isUnity((OS.DesktopEnv.Env)object3)) {
                    if (AUTO_FIX_INCONSISTENCIES) {
                        if (Gtk.isGtk2) {
                            trayType = TrayType.Swing;
                            logger.warn("Forcing Swing Tray type because Ubuntu Unity display environment removed support for GtkStatusIcons and GTK2+ was specified.");
                        } else {
                            FORCE_TRAY_TYPE = TrayType.AppIndicator;
                            trayType = TrayType.AppIndicator;
                            logger.warn("Forcing AppIndicator because Ubuntu Unity display environment removed support for GtkStatusIcons.");
                        }
                    } else {
                        logger.error("Unable to use the GtkStatusIcons when running on Ubuntu with the Unity display environment, and thus the SystemTray will not work. Please set `SystemTray.AUTO_FIX_INCONSISTENCIES=true;` to automatically fix this problem.");
                        return null;
                    }
                }
                if (object3 == OS.DesktopEnv.Env.Gnome) {
                    if (OS.Linux.INSTANCE.isKali()) {
                        if (DEBUG && PREFER_GTK3) {
                            logger.debug("Preferring GTK2 because this OS has weird graphical issues with GTK3 status icons");
                        }
                        PREFER_GTK3 = false;
                    } else if (OS.Linux.INSTANCE.isFedora()) {
                        object2 = OS.DesktopEnv.INSTANCE.getGnomeVersion();
                        if (object2 == null) {
                            if (PREFER_GTK3 && DEBUG) {
                                logger.debug("Preferring GTK2 because this OS has weird graphical issues with GTK3 status icons");
                            }
                            PREFER_GTK3 = false;
                        } else {
                            int n = 0;
                            object2 = ((String)object2).split("\\.", 2);
                            try {
                                n = Integer.parseInt(object2[0]);
                            }
                            catch (Exception exception) {}
                            if (n == 2 || n == 3) {
                                if (PREFER_GTK3 && DEBUG) {
                                    logger.debug("Preferring GTK2 because this OS has weird graphical issues with GTK3 status icons");
                                }
                                PREFER_GTK3 = false;
                            }
                        }
                    }
                }
            }
            if (trayType == TrayType.AppIndicator) {
                if (ENABLE_ROOT_CHECK && OS.Linux.INSTANCE.isRoot()) {
                    if (AUTO_FIX_INCONSISTENCIES) {
                        trayType = TrayType.Swing;
                        logger.warn("Attempting to load the SystemTray as the 'root/sudo' user. This will likely not work because of dbus restrictions. Using the Swing Tray type instead. Please refer to the readme notes or issue #63 on how to work around this.");
                    } else {
                        logger.error("Attempting to load the SystemTray as the 'root/sudo' user. This will likely NOT WORK because of dbus restrictions. Please refer to the readme notes or issue #63 on how to work around this.");
                    }
                }
                if (OS.Linux.INSTANCE.isElementaryOS() && OS.Linux.INSTANCE.getElementaryOSVersion()[0] >= 5 && !new File("/usr/share/doc/wingpanel-indicator-ayatana").isDirectory()) {
                    logger.error("Unable to use the SystemTray as-is with this version of ElementaryOS. By default, tray icons *are not* supported, but a workaround has been developed. Please see: https://git.dorkbox.com/dorkbox/elementary-indicators");
                    return null;
                }
            }
        }
        if (bl2 && AUTO_FIX_INCONSISTENCIES && trayType == TrayType.Swing && !AUTO_SIZE) {
            logger.error("When using the SystemTray on Windows as the SWING type, it will not properly scale to fit the menubar. BecauseAUTO_SIZE is disabled, this will result in a terrible experience. Changing from Swing -> WindowsNative.");
            trayType = TrayType.WindowsNative;
        }
        if (trayType == null) {
            trayType = TrayType.Swing;
            logger.error("SystemTray initialization failed. (Unable to discover which implementation to use). Falling back to the Swing Tray.");
        }
        if (AUTO_FIX_INCONSISTENCIES) {
            if (bl2 && trayType == TrayType.WindowsNative && ((LookAndFeel)(object3 = UIManager.getLookAndFeel())).getName().equals("Metal")) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {}
            }
            if (SWING_UI == null) {
                if (bl && trayType == TrayType.Swing) {
                    SWING_UI = new LinuxSwingUI();
                } else if (bl2 && (trayType == TrayType.Swing || trayType == TrayType.WindowsNative)) {
                    SWING_UI = new WindowsSwingUI();
                }
            }
        }
        if (DEBUG) {
            logger.debug("Version {}", (Object)SystemTray.getVersion());
            logger.debug("OS: {}", (Object)System.getProperty("os.name"));
            logger.debug("Arch: {}", (Object)System.getProperty("os.arch"));
            object3 = System.getProperty("java.vm.name", "");
            object2 = System.getProperty("java.version", "");
            String string2 = System.getProperty("java.vm.specification.vendor", "");
            logger.debug("{} {} {}", new Object[]{string2, object3, object2});
            logger.debug("JPMS enabled: {}", (Object)OS.INSTANCE.getUsesJpms());
            logger.debug("Is Auto sizing tray/menu? {}", (Object)AUTO_SIZE);
            logger.debug("Is JavaFX detected? {}", (Object)RenderProvider.isJavaFX());
            logger.debug("Is SWT detected? {}", (Object)RenderProvider.isSwt());
            object2 = UIManager.getLookAndFeel();
            if (trayType == TrayType.Swing || trayType == TrayType.WindowsNative) {
                if (((LookAndFeel)object2).isNativeLookAndFeel()) {
                    logger.debug("Java Native installed L&F: {} ({})", (Object)((LookAndFeel)object2).getID(), (Object)object2.getClass().getName());
                } else {
                    logger.debug("Java Swing installed L&F: {} ({})", (Object)((LookAndFeel)object2).getID(), (Object)object2.getClass().getName());
                }
                object = UIManager.getInstalledLookAndFeels();
                if (((UIManager.LookAndFeelInfo[])object).length > 0) {
                    logger.debug("Java Swing L&F's (detected):");
                    object3 = object;
                    int n = ((UIManager.LookAndFeelInfo[])object).length;
                    for (int i = 0; i < n; ++i) {
                        object = object3[i];
                        logger.debug("\t{} ({})", (Object)((UIManager.LookAndFeelInfo)object).getName(), (Object)((UIManager.LookAndFeelInfo)object).getClassName());
                    }
                }
            }
            if (FORCE_TRAY_TYPE == TrayType.AutoDetect) {
                logger.debug("Auto-detecting tray type");
            } else {
                logger.debug("Forced tray type: {}", (Object)FORCE_TRAY_TYPE.name());
            }
            if (OS.INSTANCE.isLinux()) {
                logger.debug("Force GTK2: {}", (Object)FORCE_GTK2);
                logger.debug("Prefer GTK3: {}", (Object)PREFER_GTK3);
            }
        }
        try {
            if (bl) {
                GtkEventDispatch.startGui((boolean)FORCE_GTK2, (boolean)PREFER_GTK3, (boolean)DEBUG);
                GtkEventDispatch.waitForEventsToComplete();
                if (DEBUG) {
                    logger.debug("GTK Version: " + Gtk.MAJOR + "." + Gtk.MINOR + "." + Gtk.MICRO);
                    logger.debug("Is the system already running GTK? {}", (Object)Gtk.alreadyRunningGTK);
                }
                if (!Gtk.isLoaded) {
                    trayType = TrayType.Swing;
                    logger.error("Unable to initialize GTK! Something is severely wrong! Using the Swing Tray type instead.");
                } else if (trayType == TrayType.AppIndicator && !AppIndicator.isLoaded) {
                    object3 = AppIndicator.getInstallString((boolean)GtkCheck.isGtk2);
                    object2 = OS.Linux.PackageManager.INSTANCE.getType().getInstallString() + " " + (String)object3;
                    String string3 = "Please install " + (String)object3 + ", for example: '" + (String)object2 + "'.";
                    if (AUTO_FIX_INCONSISTENCIES && java.awt.SystemTray.isSupported() && !OS.DesktopEnv.INSTANCE.isKDE()) {
                        trayType = TrayType.Swing;
                        logger.warn("Unable to initialize the AppIndicator correctly. Using the Swing Tray type instead.");
                        logger.warn(string3);
                    } else {
                        logger.error("AppIndicator unable to load.  " + string3);
                        return null;
                    }
                }
            }
            SizeAndScaling.initSizes(trayType);
            if (!RenderProvider.isDefault() && SwingUtilities.isEventDispatchThread()) {
                logger.error("SystemTray initialization for JavaFX or SWT **CAN NOT** occur on the Swing Event Dispatch Thread (EDT). Something is seriously wrong.");
                return null;
            }
            if (trayType == TrayType.Swing || trayType == TrayType.Awt || trayType == TrayType.Osx || trayType == TrayType.WindowsNative) {
                Toolkit.getDefaultToolkit();
            }
            if (AUTO_FIX_INCONSISTENCIES) {
                if (bl2) {
                    SystemTrayFixesWindows.fix(trayType);
                } else if (bl3) {
                    SystemTrayFixesMacOS.fix(trayType);
                } else if (bl) {
                    SystemTrayFixesLinux.fix(trayType);
                }
            }
            object3 = () -> {
                AutoDetectTrayType.removeSystemTrayHook(string);
                if (!AutoDetectTrayType.hasOtherTrays()) {
                    EventDispatch.shutdown();
                }
            };
            object2 = new CacheUtil(string + "Cache_" + System.getProperty("user.name"));
            Object object4 = new ImageResizeUtil((CacheUtil)object2);
            object2 = new AtomicReference();
            object = AutoDetectTrayType.selectType(trayType);
            if (RenderProvider.isDefault() && (trayType == TrayType.Swing || trayType == TrayType.Awt || trayType == TrayType.Osx)) {
                SwingUtil.INSTANCE.invokeAndWait(() -> SystemTray.lambda$get$1((AtomicReference)object2, object, string, (ImageResizeUtil)object4, (Runnable)object3));
            } else {
                ((AtomicReference)object2).set((Tray)((Class)object).getConstructors()[0].newInstance(string, object4, object3));
            }
            object3 = (Tray)((AtomicReference)object2).get();
            if (object3 == null) {
                logger.error("Unable to create tray type: '{}'", (Object)trayType);
                return null;
            }
            if (DEBUG) {
                logger.info("Successfully loaded type: {}", (Object)trayType);
            } else {
                logger.info("Successfully loaded");
            }
            object2 = new SystemTray((Tray)object3, (ImageResizeUtil)object4);
            AutoDetectTrayType.setInstance(string, (SystemTray)object2);
            object4 = AutoDetectTrayType.getShutdownHook(string);
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)object4));
            return object2;
        }
        catch (Exception exception) {
            logger.error("Unable to create tray type: '{}", (Object)trayType, (Object)exception);
            return null;
        }
    }

    private SystemTray(Tray tray, ImageResizeUtil imageResizeUtil) {
        this.menu = tray;
        this.imageResizeUtil = imageResizeUtil;
    }

    public final void shutdown() {
        ((Entry)this.menu).remove();
    }

    public final void shutdown(Runnable runnable) {
        this.shutdown();
        EventDispatch.runLater(() -> {
            runnable = new Thread(() -> {
                EventDispatch.waitForShutdown();
                runnable.run();
            });
            ((Thread)runnable).setName("SystemTrayShutdown");
            ((Thread)runnable).setDaemon(true);
            ((Thread)runnable).start();
        });
    }

    public final String getStatus() {
        return this.menu.getStatus();
    }

    public final Menu setStatus(String string) {
        this.menu.setStatus(string);
        return this.menu;
    }

    public final Menu getMenu() {
        return this.menu;
    }

    public final Menu setMenu(JMenu componentArray) {
        Object object = componentArray.getIcon();
        if (object != null) {
            object = new BufferedImage(object.getIconWidth(), object.getIconHeight(), 2);
            this.setImage((Image)object);
        }
        componentArray = object = componentArray.getMenuComponents();
        int n = ((Component[])object).length;
        for (int i = 0; i < n; ++i) {
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                this.menu.add((JMenu)component);
                continue;
            }
            if (component instanceof JCheckBoxMenuItem) {
                this.menu.add((JCheckBoxMenuItem)component);
                continue;
            }
            if (component instanceof JMenuItem) {
                this.menu.add((JMenuItem)component);
                continue;
            }
            if (!(component instanceof JSeparator)) continue;
            this.menu.add((JSeparator)component);
        }
        return this.menu;
    }

    public final Menu setEnabled(boolean bl) {
        this.menu.setEnabled(bl);
        return this.menu;
    }

    public final Menu setTooltip(String string) {
        this.menu.setTooltip(string);
        return this.menu;
    }

    public final void setImage(File file) {
        if (file == null) {
            throw new NullPointerException("imageFile");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, file));
    }

    public final Menu setImage(String string) {
        if (string == null) {
            throw new NullPointerException("imagePath");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, string));
        return this.menu;
    }

    public final Menu setImage(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("imageUrl");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, uRL));
        return this.menu;
    }

    public final Menu setImage(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("imageStream");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, inputStream));
        return this.menu;
    }

    public final Menu setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("image");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, image));
        return this.menu;
    }

    public final Menu setImage(ImageInputStream imageInputStream) {
        if (imageInputStream == null) {
            throw new NullPointerException("image");
        }
        this.menu.setImageFromTray(this.imageResizeUtil.shouldResizeOrCache(true, imageInputStream));
        return this.menu;
    }

    public final int getTrayImageSize() {
        return SizeAndScaling.TRAY_SIZE;
    }

    public final int getMenuImageSize() {
        return SizeAndScaling.TRAY_MENU_SIZE;
    }

    public final TrayType getType() {
        return AutoDetectTrayType.fromClass(this.menu.getClass());
    }

    public final void remove() {
        ((Entry)this.menu).remove();
    }

    private static /* synthetic */ void lambda$get$1(AtomicReference atomicReference, Class clazz, String string, ImageResizeUtil imageResizeUtil, Runnable runnable) {
        try {
            atomicReference.set((Tray)clazz.getConstructors()[0].newInstance(string, imageResizeUtil, runnable));
            return;
        }
        catch (Exception exception) {
            logger.error("Unable to create tray type: '{}'", (Object)clazz.getSimpleName(), (Object)exception);
            return;
        }
    }

    static {
        Updates.INSTANCE.add(SystemTray.class, "b35c107332d844559a3f877fcef42a21", SystemTray.getVersion());
    }

    public static enum TrayType {
        AutoDetect,
        Gtk,
        AppIndicator,
        WindowsNative,
        Swing,
        Osx,
        Awt;


        public final TrayType safeFromString(String string) {
            try {
                return TrayType.valueOf(string);
            }
            catch (Exception exception) {
                return AutoDetect;
            }
        }
    }
}

