/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.gnomeShell;

import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.gnomeShell.ExtensionSupport;
import java.io.File;
import java.util.List;

public class LegacyExtension {
    private static final String UID = "SystemTray@Dorkbox";
    private static final String SHELL_RESTART_COMMAND = "gnome-shell --replace &";

    public static void install(String string) {
        boolean bl;
        String string2;
        if (OS.DesktopEnv.INSTANCE.isWayland()) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Gnome-shell legacy extension not possible with wayland.");
            }
            return;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing the legacy gnome-shell extension.");
        }
        if ((string2 = ExtensionSupport.getGnomeVersion()) == null) {
            return;
        }
        List<String> list = ExtensionSupport.getEnabledExtensions();
        boolean bl2 = list.contains("topIcons@adel.gadllah@gmail.com");
        boolean bl3 = list.contains(UID);
        if (bl2) {
            return;
        }
        Object object = System.getProperty("user.home");
        object = new File((String)object + "/.local/share/gnome-shell/extensions/SystemTray@Dorkbox");
        File file = new File((File)object, "metadata.json");
        string2 = ExtensionSupport.createMetadata(UID, SystemTray.getVersion(), string, string2);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Checking the legacy gnome-shell extension");
        }
        if (bl3 && !ExtensionSupport.needsUpgrade(string2, file)) {
            return;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing legacy gnome-shell extension");
        }
        if ((bl = ExtensionSupport.writeFile(string2, file)) && !bl3) {
            boolean bl4 = ExtensionSupport.installFile("extension.js", (File)object, string);
            if (!bl4) {
                SystemTray.logger.error("Unable to install legacy gnome-shell extension!!");
            } else if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Enabling legacy gnome-shell extension");
            }
            if (!list.contains(UID)) {
                list.add(UID);
            }
            ExtensionSupport.setEnabledExtensions(list);
            ExtensionSupport.restartShell(SHELL_RESTART_COMMAND);
        }
    }

    public static void unInstall() {
        if (OS.DesktopEnv.INSTANCE.isWayland()) {
            if (OS.Linux.INSTANCE.isUbuntu() && OS.Linux.INSTANCE.getUbuntuVersion()[0] == 17) {
                return;
            }
            if (OS.Linux.INSTANCE.isFedora()) {
                return;
            }
            if (SystemTray.DEBUG) {
                SystemTray.logger.warn("Trying to restart the shell with an unknown version of wayland. Please create an issue with OS and debug information.");
            } else {
                SystemTray.logger.warn("Trying to restart the shell with an unknown version of wayland. Please set `SystemTray.DEBUG=true;` then create an issue with OS and debug information.");
            }
        }
        ExtensionSupport.unInstall(UID, SHELL_RESTART_COMMAND);
    }

    public static void restartShell() {
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("DEBUG mode enabled. You need to log-out/in or manually restart the shell via '{}' to apply the changes.", (Object)SHELL_RESTART_COMMAND);
            return;
        }
        ExtensionSupport.restartShell(SHELL_RESTART_COMMAND);
    }
}

